#ifndef _ASM_GENERIC_TYPES_H
#define _ASM_GENERIC_TYPES_H
/*
 * int-ll64 is used practically everywhere now,
 * so use it as a reasonable default.
 */
#ifndef __ASSEMBLY__
/*
 * __xx is ok: it doesn't pollute the POSIX namespace. Use these in the
  * header files exported to user space
   */
   
   typedef __signed__ char __s8;
   typedef unsigned char __u8;
   
   typedef __signed__ short __s16;
   typedef unsigned short __u16;
   
   typedef __signed__ int __s32;
   typedef unsigned int __u32;
   
#ifdef __GNUC__
   __extension__ typedef __signed__ long long __s64;
   __extension__ typedef unsigned long long __u64;
#else
   typedef __signed__ long long __s64;
   typedef unsigned long long __u64;
#endif
   

typedef unsigned short umode_t;

// NOTE: The following constants are non-standard Linux definitions
    //       for dirent.d_type.
        enum
            {
                    DT_UNKNOWN  = 0,
                    DT_FIFO     = 1,
                    DT_CHR      = 2,
                    DT_DIR      = 4,
                    DT_BLK      = 6,
                    DT_REG      = 8,
                    DT_LNK      = 10,
                    DT_SOCK     = 12,
                    DT_WHT      = 14
            };
#endif /* __ASSEMBLY__ */

/*
 * These aren't exported outside the kernel to avoid name space clashes
 */

#endif /* _ASM_GENERIC_TYPES_H */
