﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;

namespace ConvertIMPGUI
{
    public class BBeBObject
    {
        #region Member Variables
        public short type;     // Object type
        public short id;      	// Unique object ID
        short dataFlags;
        byte[] data;
        int dataLength;
        ArrayList tags = null;
        public int location; 	// Where Object was placed in file
        public int size;	// Size of Object in file
        public CBBeBFile bbebFile = null;
        #endregion

        #region Constructors
        public BBeBObject(ref CBBeBFile _bbebFile, int aType)
        {
            bbebFile = _bbebFile;
            id = bbebFile.globalBBeBObject++;
            type = (short)aType;

            dataFlags = 0;
            location = 0;
            size = 0;
            data = null;
            dataLength = 0;
            tags = new ArrayList();

            // Record certain id's in LRF Header
            if (type == CBBeBFile.OBJECT_TYPE_BookAtr)
            {
                bbebFile.putShort(CBBeBFile.LRF_ROOT_ID, id);
            }
            else if (type == CBBeBFile.OBJECT_TYPE_TOC)
            {
                bbebFile.putShort(CBBeBFile.LRF_TOC_ID, id);
            }

            bbebFile.objectList.Add(this);
        }

        public BBeBObject(ref CBBeBFile _bbebFile, int aType, int aDataFlags, byte[] aData)
            : this(ref _bbebFile, aType)
        {
            dataFlags = (short)aDataFlags;
            data = aData;
            dataLength = data.Length;
        }

        public BBeBObject(ref CBBeBFile _bbebFile, int aType, int aDataFlags, byte[] aData, int aLength)
            : this(ref _bbebFile, aType)
        {
            dataFlags = (short)aDataFlags;
            data = aData;
            dataLength = aLength;
        }
        #endregion

        #region addTag
        public void addTag(int aID, int aValue)
        {
            byte[] value = new byte[2 + 2];

            value[0] = (byte)(aID & 0x00ff);
            value[1] = (byte)0xf5;
            bbebFile.putShort(value, 2, aValue);

            tags.Add(value);
        }
        #endregion

        #region addTagInt
        public void addTagInt(int aID, int aValue)
        {
            byte[] value = new byte[2 + 4];

            value[0] = (byte)(aID & 0x00ff);
            value[1] = (byte)0xf5;
            bbebFile.putInt(value, 2, aValue);

            tags.Add(value);
        }
        #endregion

        #region addTag (int, byte[])
        public void addTag(int aID, byte[] aValue)
        {
            byte[] value = new byte[2 + aValue.Length];

            value[0] = (byte)(aID & 0x00ff);
            value[1] = (byte)0xf5;
            System.Array.Copy(aValue, 0, value, 2, aValue.Length);

            tags.Add(value);
        }
        #endregion

        #region addTag
        public void addToBuffer()
        {
            // Record position of sub file record in file
            location = bbebFile.getPutPosition();

            // Put in Object Type TAG
            bbebFile.putShort(0xf500);
            bbebFile.putInt(id);
            bbebFile.putShort(type);

            // Put in tags
            for (int i = 0; i < tags.Count; i++)
            {
                bbebFile.putBytes((byte[])tags[i]);
            }

            // Write data block if we have one
            if (data != null)
            {
                bbebFile.putShort(0xf554);	// dataflags
                bbebFile.putShort(dataFlags);
                bbebFile.putShort(0xf504);	// length
                bbebFile.putInt(dataLength);
                bbebFile.putShort(0xf505);	// data
                bbebFile.putBytes(data, 0, dataLength);
                bbebFile.putShort(0xf506);	// end of data
            }

            // Write end of sub file marker
            bbebFile.putShort(0xf501);	// end of Sub File

            // Record size of sub file data written
            size = bbebFile.getPutPosition() - location;
        }
        #endregion
    }
}
