using System;
using System.Collections;
using System.Windows.Forms;

namespace ConvertIMPGUI
{
	#region ListViewItemStringComparer Class
	class ListViewItemStringComparer : IComparer
	{
		private int col;
		private bool asc;

		public ListViewItemStringComparer()
		{
			col = 0;
		}
		
		public ListViewItemStringComparer(int column, bool sort)
		{
			col = column;
			asc = sort;
		}

		public int Compare(object x, object y)
		{
			if (asc)
				return String.Compare(((ListViewItem)x).SubItems[col].Text, ((ListViewItem)y).SubItems[col].Text);
			else
				return String.Compare(((ListViewItem)y).SubItems[col].Text, ((ListViewItem)x).SubItems[col].Text);
		}
	}
	#endregion

	#region ListViewItemFileSizeComparer Class
	class ListViewItemFileSizeComparer : IComparer
	{
		private int col;
		private bool asc;

		public ListViewItemFileSizeComparer()
		{
			col = 0;
		}
        public ListViewItemFileSizeComparer(int column, bool sort)
		{
			col = column;
			asc = sort;
		}
		public int Compare(object x, object y)
		{
			if (asc)
			{
                if (Int32.Parse(((ListViewItem)x).SubItems[col].Text.Replace("bytes", "")) < Int32.Parse(((ListViewItem)y).SubItems[col].Text.Replace("bytes", "")))
					return -1;
                else if (Int32.Parse(((ListViewItem)x).SubItems[col].Text.Replace("bytes", "")) > Int32.Parse(((ListViewItem)y).SubItems[col].Text.Replace("bytes", "")))
					return 1;
				else
					return 0;
			}
			else
			{
                if (Int32.Parse(((ListViewItem)y).SubItems[col].Text.Replace("bytes", "")) < Int32.Parse(((ListViewItem)x).SubItems[col].Text.Replace("bytes", "")))
					return -1;
                else if (Int32.Parse(((ListViewItem)y).SubItems[col].Text.Replace("bytes", "")) > Int32.Parse(((ListViewItem)x).SubItems[col].Text.Replace("bytes", "")))
					return 1;
				else
					return 0;
			}
		}
	}
	#endregion
}
