/*
   Simple interaction with the wm8350 chip.
    
   by Rafal Kolanski (xaph.net) 2010
*/
#include <sys/types.h>
#include <sys/ioctl.h>

#include <unistd.h>
#include <fcntl.h>

#include <stdio.h>
#include <stdlib.h>

struct wm8350_inter {
    unsigned short data[3];
};

int get_wm8350_register(int fd, unsigned short reg) {
    struct wm8350_inter w = { .data = {reg, 0, 0}};
    
    int out = ioctl(fd, 0x40065000, &w);
    if (out < 0)
        return out;
    return w.data[1];
}

void print_binary(unsigned int val, int bits) {
    int x = 1 << (bits - 1);
    while (x > 0) {
        printf("%c", '0' + !!(val & x));
        x >>= 1;
    }
}

int main(int argc, char** argv) {
    int fd;

    printf("Attempting to access wm8350\n");
    fd = open("/dev/wm8350", O_RDWR);
    if (fd < 0) {
        perror("open");
        goto cleanup;
    }

    if (argc == 2) {
        char* end;
        unsigned reg = strtoul(argv[1], &end, 0);
        if (!(argv[1][0] && end && !end[0])) {
            printf("Invalid register number.\n");
            goto cleanup;
        }
        
        int v = get_wm8350_register(fd, reg);
        if (v >= 0) {
            printf("%42s6543109876543210\n", "");
            printf("%42s................\n", "");
            printf("wm8350 value for register 0x%02x : %04x  -  ", reg, v);
            print_binary(v, 16);
            printf("\n");
        } else {
            printf("Error: %d\n", v);
            goto cleanup;
        }
    }

    /* Clean up */
cleanup:
    if (fd >= 0)
        close(fd);
    printf("Exiting.\n");    
    return 0;
}

