/*
    Test script for PRS600 to query the the SD and MS cards via /dev/sdmsctl*
    
    by Rafal Kolanski (xaph.net) 2010
*/
#include <sys/types.h>
#include <sys/ioctl.h>

#include <unistd.h>
#include <fcntl.h>

#include <stdio.h>
#include <stdlib.h>

/* This is from the disassembly. The source to msdrv.ko is not available. */
#define SDMS_STATUS_REQUEST 0x80186b09

/* I'm sure the structure is 24 bytes long, but I don't know what they mean. */
#define SDMS_STATUS_SIZE 24
struct sdms_inter {
    unsigned char data[SDMS_STATUS_SIZE];
};

int get_card_status(const char* dev) {
    struct sdms_inter sdms;
    int fd, res;

    fd = open(dev, 0);
    if (fd < 0) {
        perror("open");
        return -1;
    }

    res = ioctl(fd, SDMS_STATUS_REQUEST, &sdms);
    if (res) {
        perror("ioctl");
        return -1;
    }

    for (int i = 0 ; i < SDMS_STATUS_SIZE ; i++) printf("%02x ", sdms.data[i]);
    printf("\n");

    close(fd);

    return !!(sdms.data[0]); // sony returns 1 on any non-zero value
}

int main(int argc, char** argv) {

    printf("SD card status: %d\n", get_card_status("/dev/sdmscard/sdmsctl0"));
    printf("MS card status: %d\n", get_card_status("/dev/sdmscard/sdmsctl2"));

    return 0;
}

/*

SD card inserted
# ./sdms 
02 00 07 c0 88 c3 06 c0 00 d0 1b c4 00 00 00 00 00 54 3d 00 00 00 00 00 
SD card status: 2
00 00 ab c7 e8 46 b0 c7 00 29 09 c0 20 c2 c0 c7 00 00 00 00 00 00 00 00 
MS card status: 0

SD card removed
# ./sdms 
00 00 07 c0 88 c3 06 c0 00 50 25 c4 00 00 00 00 00 00 00 00 00 00 00 00 
SD card status: 0
00 00 c4 c7 e8 46 b0 c7 00 29 09 c0 20 c2 c0 c7 00 00 00 00 00 00 00 00 
MS card status: 0

SD card inserted again
# ./sdms 
02 00 07 c0 88 c3 06 c0 00 d0 1b c4 00 00 00 00 00 54 3d 00 00 00 00 00 
SD card status: 2
00 00 b6 c7 e8 46 b0 c7 00 29 09 c0 20 c2 c0 c7 00 00 00 00 00 00 00 00 
MS card status: 0

MS card inserted
# ./sdms 
02 00 07 c0 88 c3 06 c0 00 50 25 c4 00 00 00 00 00 54 3d 00 00 00 00 00 
SD card status: 2
20 00 a7 c7 e8 46 b0 c7 00 29 09 c0 20 c2 c0 c7 00 f8 1d 00 00 00 00 00 
MS card status: 32

example oscillations when both cards inserted:
# ./sdms 
02 00 07 c0 88 c3 06 c0 00 d0 1b c4 00 00 00 00 00 54 3d 00 00 00 00 00 
SD card status: 2
20 00 c4 c7 e8 46 b0 c7 00 29 09 c0 20 c2 c0 c7 00 f8 1d 00 00 00 00 00 
MS card status: 32
# ./sdms 
02 00 07 c0 88 c3 06 c0 00 50 25 c4 00 00 00 00 00 54 3d 00 00 00 00 00 
SD card status: 2
20 00 b8 c7 e8 46 b0 c7 00 29 09 c0 20 c2 c0 c7 00 f8 1d 00 00 00 00 00 
MS card status: 32
# ./sdms 
02 00 07 c0 88 c3 06 c0 00 d0 1b c4 00 00 00 00 00 54 3d 00 00 00 00 00 
SD card status: 2
20 00 b8 c7 e8 46 b0 c7 00 29 09 c0 20 c2 c0 c7 00 f8 1d 00 00 00 00 00 
MS card status: 32
# ./sdms 
02 00 07 c0 88 c3 06 c0 00 50 25 c4 00 00 00 00 00 54 3d 00 00 00 00 00 
SD card status: 2
20 00 b8 c7 e8 46 b0 c7 00 29 09 c0 20 c2 c0 c7 00 f8 1d 00 00 00 00 00 
MS card status: 32
# ./sdms 
02 00 07 c0 88 c3 06 c0 00 d0 1b c4 00 00 00 00 00 54 3d 00 00 00 00 00 
SD card status: 2
20 00 c4 c7 e8 46 b0 c7 00 29 09 c0 20 c2 c0 c7 00 f8 1d 00 00 00 00 00 
MS card status: 32
# ./sdms 
02 00 07 c0 88 c3 06 c0 00 50 25 c4 00 00 00 00 00 54 3d 00 00 00 00 00 
SD card status: 2
20 00 b8 c7 e8 46 b0 c7 00 29 09 c0 20 c2 c0 c7 00 f8 1d 00 00 00 00 00 
MS card status: 32
# ./sdms 
02 00 07 c0 88 c3 06 c0 00 d0 1b c4 00 00 00 00 00 54 3d 00 00 00 00 00 
SD card status: 2
20 00 a6 c7 e8 46 b0 c7 00 29 09 c0 20 c2 c0 c7 00 f8 1d 00 00 00 00 00 
MS card status: 32

I remove the SD card
# ./sdms 
00 00 07 c0 88 c3 06 c0 00 50 25 c4 00 00 00 00 00 00 00 00 00 00 00 00 
SD card status: 0
20 00 04 c7 e8 46 b0 c7 00 29 09 c0 20 c2 c0 c7 00 f8 1d 00 00 00 00 00 
MS card status: 32

example oscillations with no cards inserted:
# ./sdms 
00 00 07 c0 88 c3 06 c0 00 d0 1b c4 00 00 00 00 00 00 00 00 00 00 00 00 
SD card status: 0
00 00 b8 c7 e8 46 b0 c7 00 29 09 c0 20 c2 c0 c7 00 00 00 00 00 00 00 00 
MS card status: 0
# ./sdms 
00 00 07 c0 88 c3 06 c0 00 50 25 c4 00 00 00 00 00 00 00 00 00 00 00 00 
SD card status: 0
00 00 a6 c7 e8 46 b0 c7 00 29 09 c0 20 c2 c0 c7 00 00 00 00 00 00 00 00 
MS card status: 0
# ./sdms 
00 00 07 c0 88 c3 06 c0 00 d0 1b c4 00 00 00 00 00 00 00 00 00 00 00 00 
SD card status: 0
00 00 c4 c7 e8 46 b0 c7 00 29 09 c0 20 c2 c0 c7 00 00 00 00 00 00 00 00 
MS card status: 0
# ./sdms 
00 00 07 c0 88 c3 06 c0 00 50 25 c4 00 00 00 00 00 00 00 00 00 00 00 00 
SD card status: 0
00 00 ab c7 e8 46 b0 c7 00 29 09 c0 20 c2 c0 c7 00 00 00 00 00 00 00 00 
MS card status: 0

mounting does not seem to change these numbers

*/

