/* 
    Interface to broadsheet E-ink display via ioctls.
    
    Written for and tested on the PRS600. Might work on something else, but
    may need changes.

    IMPORTANT: do not invoke updates on a sleeping screen or the system will
        freeze.

    by Rafal Kolanski (xaph.net) 2010
*/
#ifndef EINK_H
#define EINK_H

#include <linux/fb.h>

/* Headers from broadsheet.h */
#define FBIO_EINK_GET_TEMPERATURE       0x46A1  //Returns temperature in degree Celsius
#define FBIO_EINK_INIT              0x46A3  //Initializes the controller
#define FBIO_EINK_GET_STATUS            0x46A6  //Gets controller status
#define FBIO_EINK_GET_VEROFCONT         0x46B0  //Gets controller hardware version
#define FBIO_EINK_GET_DISPSTATUS        0x46B4  //Gets display status (BUSY=1, NOTBUSY=0)
#define FBIO_EINK_SET_ORIENTATION       0x46F2  //Sets picture orientation angle (0 for 0, 1 for 90, 2 for 180, 3 for 270 degrees)
#define FBIO_EINK_GET_ORIENTATION       0x46F3  //Gets picture orientation angle (0 for 0, 1 for 90, 2 for 180, 3 for 270 degrees)
#define FBIO_EINK_SET_POWER_MODE                0x46F6  //Sets broadsheet power mode (1:normal 2:sleep 3:standby)
#define FBIO_EINK_GET_POWER_MODE        0x46F7  //Gets broadsheet power mode
#define FBIO_EINK_UPDATE_PIC            0x4700  //Displays picture
#define FBIO_EINK_SEND_PIC          0x4701  //Send screen image
#define FBIO_EINK_UPDATE_SCREEN         0x4702  //Updater screen
#define FBIO_EINK_SHUTDOWN          0xFE06

#define POWER_MODE_NORMAL  1
#define POWER_MODE_SLEEP   2
#define POWER_MODE_STANDBY 3

struct eink_update {
    unsigned int upmode;
    unsigned int orientation;
    unsigned int x;
    unsigned int y;
    unsigned int w;
    unsigned int h;
};
/* end headers from broadsheet.h */

typedef struct eink eink_t;

// should mmap as well
eink_t* eink_open(void);    // NULL on error
void eink_close(eink_t*);

unsigned eink_width(eink_t*);
unsigned eink_height(eink_t*);

int eink_get_orientation(eink_t*, int); // < 0 on error, second arg is force check
int eink_set_orientation(eink_t*, int); // 0 on success

int eink_get_power_mode(eink_t*);
int eink_is_awake(eink_t*);
int eink_sleep(eink_t*);        // 0 on success
int eink_wakeup(eink_t*);       // 0 on success

int eink_get_temperature(eink_t*);  // < 0 on error

unsigned char* eink_buffer(eink_t*);

int eink_update(eink_t*, struct eink_update*); // < 0 on error
int eink_update_full(eink_t*, int mode); // < 0 on error

#endif /* EINK_H */

