/*
    Test script for PRS600 to interact with the screen via /dev/fb0
    by forcing it to update and draw as many rectangles as possible, to see 
    what happens.

    result: update ioctl blocks until next update is possible, a silly pattern
        is drawn.
    unexpected result: once, after a flood of draw requests while not
        listening to the subcpu at all, it got to a stage where it 
        only responds with a flood of 0x0. Happened once, couldn't reproduce.
    
    by Rafal Kolanski (xaph.net) 2010
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "eink.h"

/* E-ink screen */
static eink_t* eink;

/* keep track of last rect of pixel change */
struct eink_update last_damage;

/* Drawing */

void draw_rect(int x, int y, int sx, int sy, int color) {
    /* yes, hardly optimal, I just want it to work */
    int w = eink_width(eink);
    int h = eink_height(eink);
    unsigned char* buf = eink_buffer(eink);
    for (int i = x ; i < x + sx ; ++i) {
        for (int j = y ; j < y + sy ; ++j) {
            if (i < 0 || i > w || j < 0 || j > h) continue;
            if (color == -1) {
                // use xor pattern
                buf[j * w + i] = i ^ j;
                continue;
            }
            buf[j * w + i] = color;
        }
    }
    last_damage.x = x;
    last_damage.y = y;
    last_damage.w = sx;
    last_damage.h = sy;
}

int update_rect(int x, int y, int sx, int sy, int mode) {
    struct eink_update damage;
    /* yes, hardly optimal, I just want it to work */
    damage.x = x;
    damage.y = y;
    damage.w = sx;
    damage.h = sy;
    damage.upmode = mode;
    damage.orientation = eink_get_orientation(eink, 0);
    return eink_update(eink, &damage);
}

int update_last(int mode) {
    last_damage.upmode = mode;
    last_damage.orientation = eink_get_orientation(eink, 0);
    return eink_update(eink, &last_damage);
}

int main(int argc, char* argv[]) {
    eink = eink_open();
    if (!eink) {
        printf("Could not initialise e-ink display.\n");
        return 1;
    }
    if (eink_wakeup(eink) || eink_set_orientation(eink, 3)) {
        printf("E-ink setup failed\n");
        return 1;
    }

    for (int i = 0 ; i < 10000 ; i++) {
        int x = random() % 600;
        int y = random() % 800;
        int sx = random() % (600-x);
        int sy = random() % (800-y);
        int c = random() % (256-32) + 32;
        draw_rect(x,y,sx,sy,c);
        update_last(2);
        printf("rect %d %d (%d x %d) %d\n", x,y,sx,sy,c);
    }

    eink_sleep(eink);

    eink_close(eink);
    printf("\n");
    return 0;
}

