/*
 * Decompiled with CFR 0.152.
 */
import common.utils.FileUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;

public class FixProgressFiles {
    private static void makeProgressFilePortable(File progress_file) {
        String line;
        ArrayList<String> lines = new ArrayList<String>();
        try {
            BufferedReader br = new BufferedReader(new FileReader(progress_file));
            while ((line = br.readLine()) != null) {
                if (line.isEmpty()) continue;
                lines.add(line);
            }
            br.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int i = 0;
        while (i < lines.size()) {
            line = (String)lines.remove(i);
            File line_file = new File(line);
            lines.add(i, line_file.getName());
            ++i;
        }
        try {
            progress_file.delete();
            progress_file.createNewFile();
            BufferedWriter bw = new BufferedWriter(new FileWriter(progress_file));
            int i2 = 0;
            while (i2 < lines.size()) {
                bw.write(String.valueOf((String)lines.get(i2)) + "\n");
                ++i2;
            }
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void outputUsage() {
        System.out.println("\nFixProgressFiles");
        System.out.println("Author: Andrew Mantel");
        System.out.println("Purpose: Fix progress files to make them portable (so that you can move output_folder to another location or OS).");
        System.out.println("Usage: java -jar FixProgressFiles.jar [folder path]");
        System.out.println("Example: java -jar FixProgressFiles.jar C:\\\\Manga\\\\SchoolRumble\\\\");
        System.out.println("If the path contains spaces, then put double-quotes around the path. For example: java -jar FixProgressFiles.jar \"C:\\\\Manga\\\\School Rumble\\\\\"");
        System.out.println("Windows users: Use double back-spaces \\\\ instead of single back-spaces \\ in the path.");
        System.out.println("This program will search all subdirectories within the given [folder path] for progress files.");
        System.out.println("Note: You must run this program on the same operating system as the progress files were originally created.");
        System.out.println("");
        System.exit(0);
    }

    public static void main(String[] args) throws IOException {
        String folder_path;
        File folder_file;
        if (args.length != 1) {
            FixProgressFiles.outputUsage();
        }
        if (!(folder_file = new File(folder_path = args[0])).exists()) {
            System.out.println("ERROR: Couldn't find folder: " + folder_file.getAbsolutePath());
            FixProgressFiles.outputUsage();
        }
        System.out.println("Searching for progress files...");
        ArrayList<File> progress_file_list = FileUtils.getFilenameInstancesRecursive(folder_file, "progress.txt");
        if (progress_file_list.size() == 0) {
            System.out.println("Didn't find any progress files within " + folder_file.getAbsolutePath() + ", so quitting.");
            System.exit(0);
        } else {
            System.out.println("Found " + progress_file_list.size() + " progress file(s), updating to make them portable...");
        }
        int i = 0;
        while (i < progress_file_list.size()) {
            File cur_progress_file = progress_file_list.get(i);
            System.out.println("  Currently updating " + cur_progress_file.getAbsolutePath() + "...");
            FixProgressFiles.makeProgressFilePortable(cur_progress_file);
            ++i;
        }
        System.out.println("\nFinished.");
    }
}

