#!/bin/sh
#
# $Id: install.sh 6682 2010-08-30 00:32:30Z NiLuJe $
#
# diff OTA patch script

_FUNCTIONS=/etc/rc.d/functions
[ -f ${_FUNCTIONS} ] && . ${_FUNCTIONS}


MSG_SLLVL_D="debug"
MSG_SLLVL_I="info"
MSG_SLLVL_W="warn"
MSG_SLLVL_E="err"
MSG_SLLVL_C="crit"
MSG_SLNUM_D=0
MSG_SLNUM_I=1
MSG_SLNUM_W=2
MSG_SLNUM_E=3
MSG_SLNUM_C=4
MSG_CUR_LVL=/var/local/system/syslog_level

logmsg()
{
    local _NVPAIRS
    local _FREETEXT
    local _MSG_SLLVL
    local _MSG_SLNUM

    _MSG_LEVEL=$1
    _MSG_COMP=$2

    { [ $# -ge 4 ] && _NVPAIRS=$3 && shift ; }

    _FREETEXT=$3

    eval _MSG_SLLVL=\${MSG_SLLVL_$_MSG_LEVEL}
    eval _MSG_SLNUM=\${MSG_SLNUM_$_MSG_LEVEL}

    local _CURLVL

    { [ -f $MSG_CUR_LVL ] && _CURLVL=`cat $MSG_CUR_LVL` ; } || _CURLVL=1

    if [ $_MSG_SLNUM -ge $_CURLVL ]; then
        /usr/bin/logger -p local4.$_MSG_SLLVL -t "ota_install" "$_MSG_LEVEL def:$_MSG_COMP:$_NVPAIRS:$_FREETEXT"
    fi

    [ "$_MSG_LEVEL" != "D" ] && echo "ota_install: $_MSG_LEVEL def:$_MSG_COMP:$_NVPAIRS:$_FREETEXT"
}

if [ -z "${_PERCENT_COMPLETE}" ]; then
    export _PERCENT_COMPLETE=0
fi

update_percent_complete()
{
    _PERCENT_COMPLETE=$((${_PERCENT_COMPLETE} + $1))
    update_progressbar ${_PERCENT_COMPLETE}
}

# Hack specific config (name and when to start/stop)
HACKNAME="hotkeys"
SLEVEL="75"
#KLEVEL="09"

update_percent_complete 2

# Remove our deprecated content
# Nothing to do here

update_progressbar 3

# Install our hack's custom content
# But keep the user's custom content...
if [ -d /mnt/us/${HACKNAME} ] ; then
    logmsg "I" "update" "our custom directory already exists, checking if we have custom content to preserve"
    # Bundled custom hotkeys
    # Loop through all of our bundled custom hotkeys
    for bundled_hotkey in 0 1 2 3 4 5 6 7 8 9 SLASH DOT ; do
        current_hotkey="SHIFT-${bundled_hotkey}.sh"
        # Select the correct expected md5sum for our current hotkey script
        case "${current_hotkey}" in
            "SHIFT-0.sh" )
                hotkey_expected_md5=38d691e2637aa28e11187ef28d67eb7f
            ;;
            "SHIFT-1.sh" )
                hotkey_expected_md5=03ce003c3787c3c046e58faa8a59ef34
            ;;
            "SHIFT-2.sh" )
                hotkey_expected_md5=deef80db78e3933cd9392aac70f2680a
            ;;
            "SHIFT-3.sh" )
                hotkey_expected_md5=2ef818c7fe5d15a4a0b0b697028cc7cc
            ;;
            "SHIFT-4.sh" )
                hotkey_expected_md5=83ab8c051a2e95f8b780f6c0c893b923
            ;;
            "SHIFT-5.sh" )
                hotkey_expected_md5=cbd5c4d46472259b734eb3e0cd58b7d8
            ;;
            "SHIFT-6.sh" )
                hotkey_expected_md5=f2450e17122a8eeff69403980b8a4dbe
            ;;
            "SHIFT-7.sh" )
                hotkey_expected_md5=4feafeace4567a23ff5f9f0d985fe010
            ;;
            "SHIFT-8.sh" )
                hotkey_expected_md5=2f18c2b4199f7d6861832c5510226597
            ;;
            "SHIFT-9.sh" )
                hotkey_expected_md5=702b1c1ede3b681602894c34316e6fa8
            ;;
            "SHIFT-DOT.sh" )
                hotkey_expected_md5=4b4d014640c3c22e81bfe9b9960f164f
            ;;
            "SHIFT-SLASH.sh" )
                hotkey_expected_md5=6c035fa5b86972989b135709627873de
            ;;
            * )
                logmsg "I" "update" "huh. unknown custom hotkey for md5 checks. that shouldn't happen"
            ;;
        esac
        # And perform the actual check
        if [ -f /mnt/us/${HACKNAME}/${current_hotkey} ] ; then
            hotkey_current_md5=$( md5sum /mnt/us/${HACKNAME}/${current_hotkey} | awk '{ print $1; }' )
            if [ ! "${hotkey_current_md5}" = "${hotkey_expected_md5}" ] ; then
                HACK_EXCLUDE="${HACK_EXCLUDE} ${HACKNAME}/${current_hotkey}"
                logmsg "I" "update" "found custom hotkey script ${current_hotkey}, excluding from archive"
            fi
        fi
    done
fi

update_progressbar 20

# Okay, now we can extract it. Since busybox's tar is very limited, we have to use a tmp directory to perform our filtering
logmsg "I" "update" "installing custom directory"
tar -xvzf ${HACKNAME}.tar.gz

# That's very much inspired from official update scripts ;)
cd src
# And now we filter the content to preserve user's custom content
for custom_file in ${HACK_EXCLUDE} ; do
    if [ -f "./${custom_file}" ] ; then
        logmsg "I" "update" "preserving custom content (${custom_file})"
        rm -f "./${custom_file}"
    fi
done
# Finally, re-tape our filtered dir and unleash it on the live userstore
tar cf - . | (cd /mnt/us ; tar xvf -)
_RET=$?
if [ ${_RET} -ne 0 ] ; then
    logmsg "C" "update" "code=${_RET}" "failure to update userstore with custom directory"
    return 1
fi
cd - >/dev/null
rm -rf src

update_progressbar 40

# Install our hack's init script
logmsg "I" "update" "installing init script"
cp -f ${HACKNAME}-init /etc/init.d/${HACKNAME}

update_progressbar 60

# Make it executable
logmsg "I" "update" "chmoding init script"
[ -x /etc/init.d/${HACKNAME} ] || chmod +x /etc/init.d/${HACKNAME}

update_progressbar 80

# Make it start at early at boot (rcS), after the userstore
logmsg "I" "update" "creating early boot runlevel symlink"
[ -h /etc/rcS.d/S${SLEVEL}${HACKNAME} ] || ln -fs /etc/init.d/${HACKNAME} /etc/rcS.d/S${SLEVEL}${HACKNAME}

update_progressbar 90

# Cleanup
logmsg "I" "update" "cleaning up"
rm -f ${HACKNAME}-init ${HACKNAME}.tar.gz

update_progressbar 99

logmsg "I" "update" "done"
update_progressbar 100

return 0
