#include <inkview.h>
#include <stdio.h>
#include <unistd.h>


FILE * LogFile;

char* defaultNetConnection()
{
  iconfig * config;
  config = OpenConfig(NETWORKCONFIGFILE, NULL);
  return ReadString(config, "preferred", "default");
}


int main_handler(int type, int par1, int par2)
{
  int i, dl;
  char filename[FILENAME_MAX] = "/mnt/ext1/games/test.png";
  char url[FILENAME_MAX] = "http://b.tile.openstreetmap.org/16/34652/%d.png";
  char url1[FILENAME_MAX];
  int net_session, info;

  switch (type) {
    case EVT_INIT:
      if (!((QueryNetwork() & NET_WIFIREADY) || (QueryNetwork() & NET_BTREADY))) // TODO check for NET_WIFIREADY etc.
      {
        info = NetConnect(defaultNetConnection());
      }

      net_session = NewSession();
      for (i=0; i<20000; i++)
      {
        snprintf(url1, FILENAME_MAX, url, i);
        dl = DownloadTo(net_session, url1, 0, filename, -1);
        usleep(100000);
        fprintf(LogFile, "Download Nr: %d\n", i);
        while (1)
        {
          dl = GetSessionStatus(net_session);
          if (dl == NET_OK)
          {
            break;
          }
          else if (dl < 0)
          {
            break;
          }
          usleep(10000);
        }
        if (dl < 0)
        {
          fprintf(LogFile, "session error: %d\n", dl);
          break;
        }
      }
      CloseApp();
      break;
  }
  return 0;
}


int main(int argc, char **argv) {
  LogFile = fopen("/mnt/ext1/games/dl.log", "w");
  
  InkViewMain(main_handler);
  
  fclose(LogFile);
  return 0;
}
