/*
 ============================================================================
 Name        : main.c
 Author      : Christian Hoff
 Version     : 0.1
 Copyright   : (c) 2009 Christian Hoff
 ============================================================================
 */

#include <stdio.h>
#include <stdlib.h>
#include "dumpfile.h"

int main(int argc, const char* argv[]) {
	if (argc != 2) {
		fprintf(stderr, "Syntax: U-BootMemoryDumpParser [path to dump file]\n");
		return 1;
	}

	FILE *file = fopen(argv[1], "r");
	if (file == NULL) {
		perror("Could not open file");
		return 2;
	}

	dumpfile_t *dumpfile = dumpfile_new(file);
	if (dumpfile == NULL) {
		fprintf(stderr, "File %s is not a valid U-Boot memory dump", argv[1]);
		fclose(file);
		return 3;
	}

	unsigned char data[100];
	int n_bytes_read = 0;
	unsigned long long n_lines_read = 0;
	unsigned long long n_bytes_total = 0;
	while (dumpfile_read_line(dumpfile, data, &n_bytes_read)) {
		n_lines_read++;
		n_bytes_total += n_bytes_read;
		int byte_idx;
		// Write bytes to stdout
		for (byte_idx = 0; byte_idx < n_bytes_read; byte_idx++) {
			//printf("%c", data[byte_idx]);
			putchar(data[byte_idx]);
		}

		if (feof(dumpfile->file)) {
			fprintf (stderr, "%llu bytes read\n", n_bytes_total);
			fprintf (stderr, "*** Operation completed successfully ***\n");
			fclose(file);
			return EXIT_SUCCESS;
		}
	}

	fprintf (stderr, "ERROR in file %s (line %llu)\n", argv[1], (n_lines_read + 1));
	fclose(file);
	return 4;
}
