#!/bin/sh

cd /media/mmcblk0p1/Programs/_mackxpatch

# Adapt gconf to enable the new views
export GCONF_CONFIG_SOURCE=`gconftool-2 --get-default-source`
# Install schemas for standard icons on Home-View
/bin/cp -f ./schemas/standard.schemas /etc/gconf/schemas/standard.schemas
gconftool-2 --makefile-install-rule /etc/gconf/schemas/standard.schemas

# Application View
/bin/cp -f ./schemas/applications.schemas /etc/gconf/schemas/applications.schemas
gconftool-2 --makefile-install-rule /etc/gconf/schemas/applications.schemas

# Installers View
/bin/cp -f ./schemas/installers.schemas /etc/gconf/schemas/installers.schemas
gconftool-2 --makefile-install-rule /etc/gconf/schemas/installers.schemas
# copy the icons
/bin/cp -f ./icons/icon-download-medium.png /usr/share/ctb/icon-download-medium.png
/bin/cp -f ./icons/icon-download-small.png /usr/share/ctb/icon-download-small.png
/bin/chmod a-x /usr/share/ctb/icon-download-*

# Favourites View
/bin/cp -f ./schemas/favourites.schemas /etc/gconf/schemas/favourites.schemas
gconftool-2 --makefile-install-rule /etc/gconf/schemas/favourites.schemas

# Recently Read View
/bin/cp -f ./schemas/recently_read.schemas /etc/gconf/schemas/recently_read.schemas
gconftool-2 --makefile-install-rule /etc/gconf/schemas/recently_read.schemas

# Xournal View
/bin/cp -f ./schemas/xournal.schemas /etc/gconf/schemas/xournal.schemas
gconftool-2 --makefile-install-rule /etc/gconf/schemas/xournal.schemas

# Disable build-in views
# gconftool-2 --type string --set /apps/er/patch/ctb/views/recent/mode "disabled"

# Enable the appropriate views
gconftool-2 --type string --set /apps/er/patch/ctb/views/application/mode "enabled"
gconftool-2 --type string --set /apps/er/patch/ctb/views/installer/mode "enabled"
gconftool-2 --type string --set /apps/er/patch/ctb/views/favourite/mode "enabled"
gconftool-2 --type string --set /apps/er/patch/ctb/views/recentlyread/mode "enabled"
gconftool-2 --type string --set /apps/er/patch/ctb/views/xournal/mode "enabled"

# Create Backup of dr.ini
/bin/cp -f /media/mmcblk0p1/System/dr.ini /media/mmcblk0p1/System/dr.patch.ini
# and save the (just modified) settings to disk
/usr/bin/erconftool -e /apps/er

# Save originals ONLY if they do not exists
if [ ! -e /media/mmcblk0p1/Programs/_mackxpatch/ctb_original ]
then
    /bin/cp -f /usr/bin/ctb /media/mmcblk0p1/Programs/_mackxpatch/ctb_original
fi

if [ ! -e /media/mmcblk0p1/Programs/_mackxpatch/libermetadb_original ]
then
    /bin/cp -f /usr/lib/libermetadb.so.0.0.0 /media/mmcblk0p1/Programs/_mackxpatch/libermetadb_original
fi

if [ ! -e /media/mmcblk0p1/Programs/_mackxpatch/globaldb_original ]
then
    /bin/cp -f /usr/share/ctb/settings/global.db /media/mmcblk0p1/Programs/_mackxpatch/globaldb_original
fi

# copy new files
/bin/cp -f /media/mmcblk0p1/Programs/_mackxpatch/bin/ctb /usr/bin/
/bin/cp -f /media/mmcblk0p1/Programs/_mackxpatch/lib/libermetadb.so.0.0.0 /usr/lib/

/bin/cp -f /media/mmcblk0p1/Programs/_mackxpatch/share/ctb/settings/global.db /usr/share/ctb/settings/
/bin/cp -f /media/mmcblk0p1/Programs/_mackxpatch/share/ctb/settings/mackx_patch.desktop /usr/share/ctb/settings/

#/bin/cp -f /media/mmcblk0p1/Programs/_mackxpatch/mxp_version /etc/

# For the new version to be used, a reset is needed
/sbin/reboot
sleep 31
