/*
 * File Name: screen_utils.c
 */

/*
 * This file is part of hello-world-settings.
 *
 * hello-world is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * hello-world is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Copyright (C) 2009 iRex Technologies B.V.
 * All rights reserved.
 */

//----------------------------------------------------------------------------
// Include Files
//----------------------------------------------------------------------------

#include "config.h"

// system include files, between < >
#include <glib.h>
#include <gtk/gtk.h>
#include <signal.h>
#include <string.h>
#include <stdlib.h>
#include <sys/types.h>
#include <unistd.h>

// ereader include files, between < >
#include <libergtk/ergtk.h>

// local include files, between " "
#include "log.h"
#include "i18n.h"
#include "screen_utils.h"


//----------------------------------------------------------------------------
// Type Declarations
//----------------------------------------------------------------------------


//----------------------------------------------------------------------------
// Constants
//----------------------------------------------------------------------------

// screen layout
#define TITLE_SEPARATOR_HEIGHT          20
#define TITLE_SEPARATOR_V_SPACING       10
#define ITEM_SEPARATOR_HEIGHT           10


//----------------------------------------------------------------------------
// Static Variables
//----------------------------------------------------------------------------


//============================================================================
// Local Function Definitions
//============================================================================

// signal handlers

//============================================================================
// Functions Implementation
//============================================================================

// create main screen title
GtkWidget *create_screen_title (GtkWidget **p_title)
{
    GtkWidget   *background = NULL;     // return value
    GtkWidget   *widget;
    GtkWidget   **p_widget;
    GtkBox      *vbox;

    LOGPRINTF("entry");

    // object hierarchy:
    //     background (vbox)
    //       |
    widget = gtk_vbox_new(FALSE, 0);
    gtk_widget_show(widget);
    vbox = GTK_BOX(widget);
    background = widget;
    //       |
    //       |-- title (label)
    //       |
    p_widget = p_title;
    widget = gtk_label_new(NULL);
    gtk_widget_set_name(widget, "irex-hello-title");
    gtk_box_pack_start(vbox, widget, FALSE, FALSE, 0);
    gtk_misc_set_alignment(GTK_MISC(widget), 0.0, 0.5);
    if (p_widget)
    {
        g_signal_connect(widget, "destroy", G_CALLBACK(gtk_widget_destroyed), p_widget);
        gtk_widget_show(widget);
        g_assert(*p_widget == NULL);
        *p_widget = widget;
    }
    //       |
    //       |-- separator (event box)
    //       |
    widget = gtk_event_box_new();
    gtk_widget_set_name(widget, "irex-hello-title-separator");
    gtk_widget_set_size_request(widget, -1, TITLE_SEPARATOR_HEIGHT);
    gtk_box_pack_start(vbox, widget, FALSE, FALSE, TITLE_SEPARATOR_V_SPACING);
    gtk_widget_show(widget);
    
    return background;
}


// create separator between entry fields
GtkWidget* create_separator (void)
{
    GtkWidget   *widget = NULL;    // return value

    LOGPRINTF("entry");

    widget = gtk_event_box_new();
    gtk_widget_set_name(widget, "irex-hello-item-separator");
    gtk_widget_set_size_request(widget, -1, ITEM_SEPARATOR_HEIGHT);
    gtk_widget_show(widget);

    return widget;
}

