/*
 * File Name: main.c
 */

/*
 * This file is part of mtag.
 *
 * mtag is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * mtag is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Copyright (C) 2010 Marcel Hendrickx
 * All rights reserved.
 */
 
#include <glib-object.h>
#include <gtk/gtk.h>

#include "db.h"

int main (int argc, char *argv[])
{
	int rc = 0;
	
    gtk_init(&argc, &argv);
    g_type_init();

    if (argc != 5) {
        fprintf(stderr, "Usage: mtag [file] [title] [author] [tag]\n");
        return 1;
    }
	
	printf ("Processing: [file:%s] [title:%s] [author:%s] [tag:%s]\n", argv[1], argv[2], argv[3], argv[4]);
	rc = add_file_to_metadata(argv[1], argv[2], argv[3], argv[4]);

    return rc;
}

