#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include "db.h"

#include <string.h>
#include <gtk/gtk.h>
#include <sys/stat.h>
#include <unistd.h> // sysconf
#include <locale.h>
#include <liberutils/er_error.h>
#include <libermetadb/ermetadb.h>

#define MOUNTPOINT_CARD   "/media/mmcblk0p1"

static int db_query_get_tag(erMetadb global_db,
							const gchar* filename,
                            const gchar* dirpath,
                            metadata_table **values)
{
    metadata_table *query = metadata_table_new();

    int rc = metadata_table_add_column(query, "tag");
    if (rc == ER_OK) rc = ermetadb_global_get_file( global_db,
                                                    dirpath,
                                                    filename,
                                                    query,
                                                    values);
    metadata_table_free(query);
    return rc;
}


int
add_file_to_metadata(char *filename, char *title, char *author, char *tag)
{
	// code from notes_filestore.cpp
	gchar* dir = 0;
	gchar* file = 0;
    int ret;

	dir = g_path_get_dirname(filename);
	file = g_path_get_basename(filename);

	// add new file to global
	//const char* mountpoint = ipc_get_mountpoint();
	erMetadb global_db = ermetadb_global_open(MOUNTPOINT_CARD, FALSE);
	if (global_db == 0) {
		printf("failed to open globaldb.");
		return -1;
	}

	// date and size attributes
	struct stat statbuf;
	gchar* fname = g_strdup_printf("%s/%s", dir, file); 
	stat(fname, &statbuf);
	gint64 size = statbuf.st_size;
	gint64 mtime = statbuf.st_mtime;
	//printf("%s size %lld, mtime %lld", fname, size, mtime);
	g_free(fname);
	
	// Using a trick to check if file is already in database, there must be a better trick ...
    metadata_table *values = NULL;
	ret = db_query_get_tag(global_db, file, dir, &values);
	if (values) metadata_table_free(values); // we do not care about values, only about return value
	if (ret == ER_OK) // already exists
	{
	    // file could not be added, assume it already exists
		metadata_table *query = metadata_table_new();

		int ret = metadata_table_add_column(query, "tag");
		ret = metadata_table_add_column(query, "title");
		ret = metadata_table_add_column(query, "author");
		if (ret == ER_OK) ret = metadata_table_set_text(query, 0, tag);
		if (ret == ER_OK) ret = metadata_table_set_text(query, 1, title);
		if (ret == ER_OK) ret = metadata_table_set_text(query, 2, author);
		if (ret == ER_OK) ret = ermetadb_global_change_file(global_db,
														    dir,
														    file,
														    query);
		metadata_table_free(query);
	}
	else
	{
		// add to global database
		ret = ermetadb_global_add_file(global_db, dir, file, size, mtime, title, author, tag);
	}

	ermetadb_close(global_db);
	
	g_free(dir);
	g_free(file);
	
	return ret;
}


