#ifndef __VIEWS_H__
#define __VIEWS_H__

/**
 * File Name  : views.h
 *
 * Description: Content browser views specific utilities
 */

/*
 * This file is part of ctb.
 *
 * ctb is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * ctb is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Copyright (C) 2010 Marcel Hendrickx
 * All rights reserved.
 */


//----------------------------------------------------------------------------
// Include Files
//----------------------------------------------------------------------------

#include <gdk/gdk.h>
#include <glib.h>

#include "filemodel.h"

G_BEGIN_DECLS

//----------------------------------------------------------------------------
// Type Declarations
//----------------------------------------------------------------------------

typedef struct
    {
        const char* title;
        int mode;
        int position;
        int number;   // number of the view
        ViewMode style; // style on which this viewmode is based
        const char* tag_filter; // used in style TAG
        ctb_sort_order_t order;
        gboolean fixed_order;
        const char* filename;
        const char* filename_icon;
        const char* subtitle;
        const char* path;
    } ViewModeInfoExt;

//----------------------------------------------------------------------------
// Macro Definitions
//---------------------------------------------------------------------------- 

// start the numbering of user views with 20
#define VIEWMODE_USER_OFFSET 20

//============================================================================
// Public Functions
//============================================================================


void views_init(void);
void views_prepare_views(void);
int view_get_mode(const gchar *filename);
ViewModeInfoExt* view_find_info_with_name (const gchar *filename );
ViewModeInfoExt* view_find_info_with_number (int number );
ViewModeInfoExt* view_find_info_on_index (unsigned int index );


G_END_DECLS

#endif // __VIEWS_H__
