#ifndef __CTB_ACTIONS_H__
#define __CTB_ACTIONS_H__

/**
 * File Name  : ctb_actions.h
 *
 * Description: Content browser actions on selected file(s) or directory(ies)
 */

/*
 * This file is part of ctb.
 *
 * ctb is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * ctb is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Copyright (C) 2008 iRex Technologies B.V.
 * All rights reserved.
 */

#include <glib.h>

#include "filemodel.h"

G_BEGIN_DECLS

/**---------------------------------------------------------------------------
 *
 * Name :  activate_item
 *
 * @brief  activate: launch viewer, goto directory, ...
 *
 * @param  [in] fileinfo - details of the item
 *
 * @return ER_OK or error code
 *
 *--------------------------------------------------------------------------*/
int activate_item (const filelist_entry_t  *fileinfo);


/**---------------------------------------------------------------------------
 *
 * Name :  delete_item
 *
 * @brief  delete: delete file or directory
 *
 * @param  [in] fileinfo - details of the item
 *
 * @return ER_OK or error code
 *
 *--------------------------------------------------------------------------*/
int delete_item (const filelist_entry_t  *fileinfo);


/**---------------------------------------------------------------------------
 *
 * Name :  create_shortcut_item
 *
 * @brief  shortcut: create shortcut on desktop for file or directory
 *
 * @param  [in] fileinfo - details of the item
 *
 * @return ER_OK or error code
 *
 *--------------------------------------------------------------------------*/
int create_shortcut_item (const filelist_entry_t  *fileinfo);

int edit_properties_item (const filelist_entry_t *fileinfo);

G_END_DECLS

#endif

