var currentPage = 1;
var currentBody = "";
var currentExploreCatId = null;
var currentExploreCatName = "";
var lastBody = "";
var pagesize = 4;

var sessionKey = CookieUtils.read("sessionKey");
var username = CookieUtils.read("userName");
if (username == null || username.length == 0) username = "";
var name = CookieUtils.read("name");
var userid = CookieUtils.read("userId");
var notFirstTime = CookieUtils.read("notFirstTime");

ScribdApp = new Object();
ScribdAuth = new Object();

// public
ScribdApp.CloseWelcomeMessage = function()
{
   CookieUtils.create("notFirstTime", "Y", 300);
   ScribdApp.Nav('featured');
}
ScribdApp.Search = function(searchElem, page)
{
   Keyboard.Close();
   if (!searchElem) searchElem = $('txtSearch');
   var query = searchElem.value;	
   ScribdApp.ShowBody('search');
   ScribdApp._setLoadingStatus('search', 'Searching');
   page = ScribdApp._processPage(page);
   offset = page * pagesize;
	ScribdApi.search(query, ScSearchLocation.All, pagesize, offset, function(resp)
	{
      ScribdApp._processDocResults('search', resp);
      ScribdApp._updatePagers('Search', resp);
	});
}
ScribdApp.Nav = function(name)
{
   ScribdApp.ShowBody(name);
   if (name == "featured") ScribdApp.Featured(1);
   if (name == "mydocs") ScribdApp.MyDocs(1);
   if (name == "exploreCats") ScribdApp.ExploreCats();
}
ScribdApp.Featured = function(page)
{
   ScribdApp.ShowBody('featured');
   ScribdApp._setLoadingStatus('featured', 'Loading');
   page = ScribdApp._processPage(page);
   offset = page * pagesize;
	ScribdApi.featured(ScFeaturedScope.Hot, pagesize, offset, function(resp)
	{
      ScribdApp._processDocResults('featured', resp);
      ScribdApp._updatePagers('Featured', resp);
	});
}
ScribdApp.MyDocs = function(page)
{
   if (userid == null || userid == "")
   {
      $('mydocsLoggedOff').style.display = 'block';
      $('btnMyDocsNext').style.display = 'none';
      $('btnMyDocsPrev').style.display = 'none';
   } 
   else 
   {
      $('mydocsLoggedOff').style.display = 'none';
      ScribdApp.ShowBody('mydocs');
      ScribdApp._setLoadingStatus('mydocs', 'Loading');
      page = ScribdApp._processPage(page);
      offset = page * pagesize;
      ScribdApi.mydocs(pagesize, offset, function(resp)
      {
         ScribdApp._processDocResults('mydocs', resp, 'You have no documents. To upload documents or <br />start a reading collection, visit Scribd.com today.');
         ScribdApp._updatePagers('MyDocs', resp);
      });
   }
}
ScribdApp.ShowBody = function(name)
{   
   $('loginform').style.display = 'none';
   $('signupform').style.display = 'none';
   $('welcomeBody').style.display = 'none';
   $('mydocsBody').style.display = 'none';
   $('mydocsNav').className = '';
   $('mydocsNav').disabled = false;
   $('featuredBody').style.display = 'none';
   $('featuredNav').className = '';
   $('featuredNav').disabled = false;
   $('exploreCatsBody').style.display = 'none';
   $('exploreBody').style.display = 'none';
   $('exploreCatsNav').className = '';
   $('exploreCatsNav').disabled = false;
   $('docBody').style.display = 'none';
   $('searchBody').style.display = 'none';

   if (name == null || name.length == 0) return;

   $(name + 'Body').style.display = 'block';
   if ($(name + 'Nav') != null)
   {
      $(name + 'Nav').className = 'active';
      $(name + 'Nav').disabled = true;
   } else if (name == "explore")
   {
      $(name + 'CatsNav').className = 'active';
   }

   lastBody = currentBody;
   currentBody = name;
   if (lastBody != currentBody)
      currentPage = 1;
}
ScribdApp.OnKeyUp = function(ev)
{
   switch(ev.keyCode)
   {
      case 9: // tab
         break;
      case 13: // enter
         break;
      case 33: // page up
         if (currentBody == "search") ScribdApp.Search($('txtSearch'), currentPage-1);
         if (currentBody == "featured") ScribdApp.Featured(currentPage-1);
         break;
      case 34: // page down
         if (currentBody == "search") ScribdApp.Search($('txtSearch'), currentPage+1);
         if (currentBody == "featured") ScribdApp.Featured(currentPage+1);
         break;
      case 27: // escape
         if (lastBody != null && lastBody.length > 0)
            ScribdApp.ShowBody(lastBody);
         break;
      case 37: // left
         break;
      case 38: // up
         break;
      case 39: // right
         break;
      case 40: // down
         break;
   }
}
ScribdApp.OpenDoc = function(elem)
{
   var str = elem.value;
   var arr = str.split('~');
   var docId = arr[0];
   var docTitle = arr[1];
   ScribdApi.getDownloadUrl(docId, function(url)
   {
      if (docHandler == null)
      {
         document.location = url;
      } else 
      {
         var saveAs = docId;
         if (docTitle != "") saveAs = docTitle;
         //if (saveAs.length > 30) saveAs = saveAs.substr(0, 30);
         docHandler.Download("/media/sd/scribd-books/", url, saveAs, "pdf");
         alert("This ebook has been downloaded to your SD card. Enjoy.");
      }
   });
}
ScribdApp.ExploreCats = function()
{
   ScribdApp.ShowBody('exploreCats');
   ScribdApp._setLoadingStatus('exploreCats', 'Loading categories');
	ScribdApi.categories(null, function(resp)
	{
      ScribdApp._processCatResults('exploreCats', resp);
	});
}
ScribdApp.Explore = function(page, sort, catId, catName)
{
   if (!sort) sort = ScSort.Popular;
   if (!catId) catId = currentExploreCatId;
   if (!catName) catName = currentExploreCatName;
   $('exploreHeader').innerHTML = "Browsing " + catName + ":";
   currentExploreCatId = catId;
   currentExploreCatName = catName;
   ScribdApp.ShowBody('explore');
   ScribdApp._setLoadingStatus('explore', 'Loading');
   page = ScribdApp._processPage(page);
   offset = page * pagesize;
	ScribdApi.browse(sort, catId, pagesize, offset, function(resp)
	{
      ScribdApp._processDocResults('explore', resp);
      ScribdApp._updatePagers('Explore', resp);
	});

}
ScribdAuth.Signup = function(formElem, usernameElem, passwdElem, passwdElem2, emailElem)
{
   Keyboard.Close();
	var username = usernameElem.value;
   var email = emailElem.value;
	var password = passwdElem.value;
	var password2 = passwdElem2.value;
   if (password == password2)
   {
      $('signupError').style.display = 'none';
      ScribdApi.signup(username, password, email, function(resp)
      {
         CookieUtils.create("sessionKey", resp.SessionKey, 30);
         CookieUtils.create("userName", resp.UserName, 30);
         CookieUtils.create("userId", resp.UserId, 30);
         CookieUtils.create("name", resp.Name, 30);
         userid = resp.UserId;
         var usrn = resp.UserName;
         if (usrn.length > 19) usrn = usrn.substr(0, 19);
         $('username').innerHTML = usrn;
         formElem.style.display = 'none';
         $('btnLogin').style.display = 'none';
         $('btnSignup').style.display = 'none';
         $('btnLogout').style.display = 'inline';
         $('mydocsNav').disabled = false;
         $('txtPassword').value = '';
         ScribdApp.Nav('featured');
      },
      function(resp)
      {
         $('signupError').style.display = 'block';
         $('signupError').innerHTML = resp.Message;
      });
   } else 
   {
      $('signupError').style.display = 'block';
      $('signupError').innerHTML = "Passwords don't match";
   }
}
ScribdAuth.Login = function(formElem, usernameElem, passwdElem)
{
   Keyboard.Close();
   if (formElem == null)
      formElem = $('loginform');
   if (usernameElem == null)
      usernameElem = $('txtUsername');
   if (passwdElem == null)
      passwdElem = $('txtPassword');
	var username = usernameElem.value;
	var password = passwdElem.value;
   $('loginError').style.display = 'none';
	ScribdApi.login(username, password, function(resp)
	{
      CookieUtils.create("sessionKey", resp.SessionKey, 30);
      CookieUtils.create("userName", resp.UserName, 30);
      CookieUtils.create("userId", resp.UserId, 30);
      CookieUtils.create("name", resp.Name, 30);
      userid = resp.UserId;
      var usrn = resp.UserName;
      if (usrn.length > 19) usrn = usrn.substr(0, 19);
      $('username').innerHTML = usrn;
      formElem.style.display = 'none';
      $('btnLogin').style.display = 'none';
      $('btnSignup').style.display = 'none';
      $('btnLogout').style.display = 'inline';
      $('txtPassword').value = '';
      ScribdApp.Nav('featured');
	},
   function(resp)
   {
      $('loginError').style.display = 'block';
      $('loginError').innerHTML = resp.Message;
   });
}
ScribdAuth.Logout = function()
{
   CookieUtils.erase("sessionKey");
   CookieUtils.erase("userName");
   CookieUtils.erase("name");
   CookieUtils.erase("userId");
   $('btnLogin').style.display = 'inline';
   $('btnSignup').style.display = 'inline';
   $('btnLogout').style.display = 'none';
   username = '';
   userid = null;
   sessionKey = null;
   $('username').innerHTML = username;
   ScribdApp.Nav('featured');
}
ScribdAuth.ShowLogin = function(formElem)
{
   ScribdApp.ShowBody('');
   formElem.style.display = 'block';
}
ScribdAuth.ShowSignup = function(formElem)
{
   ScribdApp.ShowBody('');
   formElem.style.display = 'block';
}

// private
ScribdApp._updatePagers = function(name, resp)
{
   if (resp.length == 0) 
   {
      $('btn' + name + 'Prev').disabled = true;
      $('btn' + name + 'Next').disabled = true;
      $('btn' + name + 'Prev').style.display = 'none';
      $('btn' + name + 'Next').style.display = 'none';
   } else 
   {
      $('btn' + name + 'Prev').disabled = (currentPage == 1);
      $('btn' + name + 'Next').disabled = false;
      $('btn' + name + 'Prev').style.display = 'inline';
      $('btn' + name + 'Next').style.display = 'inline';
   }
}
ScribdApp._processPage = function(page)
{
   if (!page) page = 1;

   if (page < 1) page = 1;
   if (currentPage < 1) currentPage = 1;

   currentPage = page;

   page -= 1;
   return page;
}
ScribdApp._setLoadingStatus = function(name, text)
{
   $(name + 'Results').innerHTML = '<center><br /><br /><i><h2>' + text + ' ...</h2></i></center>';
}
ScribdApp._createDocButton = function(i, respDoc)
{
   var button = document.createElement('button');
   button.className = "doc";
   button.id = "result-" + i;
   button.value = respDoc.DocumentId + "~" + respDoc.Title;
   button.onclick = new Function("ScribdApp.OpenDoc(this)");
   var html = '<table cellpadding="0" cellspacing="0" border="0"><tr><td class="thumbnail">';
   html += '<center>';
   html += '<img src="' + respDoc.ThumbnailUrl + '" />';
   //if (respDoc.PageCount != null)
   //   html += '<span class="pagecount">' + respDoc.PageCount + 'p</span>';
   html += '</center>';
   html += '</td><td class="metadata">';
   html += '<span class="title">' + respDoc.Title + '</span>';
   if (respDoc.Description != null)
   {
      var max = 200;
      if (respDoc.Description.length < max) max = respDoc.Description.length;
      var str = respDoc.Description.substr(0, max);
      if (max < respDoc.Description.length) str += " ...";
      html += '<span class="description">' + str + '</span>';
   }
   if (respDoc.Author != null && respDoc.Author.length > 0)
      html += '<span class="author">by ' + respDoc.Author + '</span>';
   if (respDoc.WhenPublished != null && respDoc.WhenPublished.length > 0)
      html += '<span class="publishdate"> on ' + respDoc.WhenPublished + '</span>';
   if (respDoc.Tags != null && respDoc.Tags.length > 0)
   {
      var tags = respDoc.Tags.replace(/,/g,", ");
      var max = 200;
      if (tags.length < max) max = tags.length;
      var str = tags.substr(0, max);
      if (max < tags.length) str += " ...";
      if (str.length > 0)
         html += '<span class="tags">tags: ' + str + '</span>';
   }
   html += '</td></tr></table>';
   button.innerHTML = html;
   var div = document.createElement('div');
   div.className = "result";
   div.appendChild(button);
   return div;
}
ScribdApp._createCatButton = function(i, respCat)
{
   var button = document.createElement('button');
   button.className = "exploreCat";
   button.id = "result-" + i;
   button.value = respCat.Id + "|" + respCat.Name;
   button.onclick = new Function("ScribdApp.Explore(1, ScSort.Popular, '"+respCat.Id+"', '"+respCat.Name+"')");
   button.innerHTML = respCat.Name;
   var div = document.createElement('div');
   div.className = "result";
   div.appendChild(button);
   return div;
}
ScribdApp._processCatResults = function(name, resp)
{
   $(name + 'Results').innerHTML = '';
   if (resp.length == 0)
   {
      $(name + 'Results').innerHTML = '<center><br /><br /><br /><i>No results</i></center>';
   } else {
      $(name + 'Results').innerHTML = '<br />';
      for(var i=0;i<resp.length;i++)
      {         
         $(name + 'Results').appendChild(ScribdApp._createCatButton(i, resp[i]));
      }
      $('result-0').focus();
   }
}
ScribdApp._processDocResults = function(name, resp, noResultsMessage)
{
   $(name + 'Results').innerHTML = '';
   if (resp.length == 0)
   {
      $(name + 'Results').innerHTML = '<center><br /><br /><br /><i>' + noResultsMessage + '</i></center>';
   } else {
      for(var i=0;i<resp.length;i++)
      {         
         $(name + 'Results').appendChild(ScribdApp._createDocButton(i, resp[i]));
      }
      $('result-0').focus();
   }
}


document.onkeyup = ScribdApp.OnKeyUp;
