XmlUtils = new Object();
CookieUtils = new Object();
ScribdApi = new Object();
ScribdApi.ApiKey = "4hu8122g3pl3jczhvtgp2";
//ScribdApi.BaseUrl = "http://www.benmcmillan.com/onyx/proxy.php?url=" + escape("http://api.scribd.com/api");
ScribdApi.BaseUrl = "http://api.scribd.com/api";

String.prototype.trim = function ()
{
       return this.replace(/^\s*/, "").replace(/\s*$/, "");
}

XmlUtils.getFirst = function(doc, name)
{
   var elems = doc.getElementsByTagName(name);
   if (elems == null) return "";
   var child1 = elems[0];
   if (child1 == null) return "";
   var child2 = child1.firstChild;
   if (child2 == null) 
   {
      if (child1.nodeValue != null) 
      {
         return child1.nodeValue;
      }
      else return "";      
   } 
   else if (child2.wholeText != null)
   {
      return child2.wholeText.trim();
   } else if (child2.data != null)
   {
      return child2.data.trim();
   }
	return child2.nodeValue;
}

XmlUtils.getFirstAttribute = function(doc, name, attr)
{
   var elems = doc.getElementsByTagName(name);
   if (elems == null) return "";
   var child1 = elems[0];
   if (child1 == null) return "";
   if (child1.getAttribute(attr) != null)
   {
      return child1.getAttribute(attr);
   } else {
      var child2 = child1.firstChild;
      if (child2 == null) return "";
      return child2.getAttribute(attr);
   }
}

CookieUtils.create = function(name,value,days) 
{
	if (days) {
		var date = new Date();
		date.setTime(date.getTime()+(days*24*60*60*1000));
		var expires = "; expires="+date.toGMTString();
	}
	else var expires = "";
//	document.cookie = name+"="+value+expires+"; path=/";
}

CookieUtils.read = function(name) 
{
	var nameEQ = name + "=";
/*	var ca = document.cookie.split(';');
	for(var i=0;i < ca.length;i++) {
		var c = ca[i];
		while (c.charAt(0)==' ') c = c.substring(1,c.length);
		if (c.indexOf(nameEQ) == 0) return c.substring(nameEQ.length,c.length);
	}*/
	return null;
}

CookieUtils.erase = function(name)
{
	//CookieUtils.create(name,"",-1);
}

var ScSearchLocation = { "All" : "all", "User" : "user", "Account" : "account" };
var ScSort = { "Popular" : "popular", "Views" : "views", "Newest" : "newest" };
var ScFeaturedScope = { "Hot" : "hot", "New" : "new" };

ScribdApi.requestOrig = function(method, args, successCallback)
{	
	var params = $H({
			"method" : method,
			"api_key" : ScribdApi.ApiKey	
		}).merge(args);	
	if (sessionKey != null)
		params = params.merge({ "session_key": sessionKey });
   var url = ScribdApi.BaseUrl + "%3F" + escape(params.toQueryString());
	new Ajax.Request(url, {	
		method: 'get',
      // requestHeaders: [ 'User-Agent', 'Mozilla/5.0 (iPhone; U; CPU like Mac OS X; en) AppleWebKit/420+ (KHTML, like Gecko) Version/3.0 Mobile/1A543a Safari/419.3' ], 
		onFailure: function(transport)
		{
			alert("Failed: " + transport.statusText);
		},
		onSuccess: function(transport)
		{
			successCallback(transport);
		}
	});
}

ScribdApi.request = function(method, args, successCallback)
{
   if (ajaxHandler == null) 
   {
      ScribdApi.requestOrig(method, args, successCallback);
   } 
   else
   {
      var params = $H({
            "method" : method,
            "api_key" : ScribdApi.ApiKey	
         }).merge(args);	
      if (sessionKey != null)
         params = params.merge({ "session_key": sessionKey });
      var url = ScribdApi.BaseUrl + "?" + params.toQueryString();     
      var xmlstr = ajaxHandler.downloadFromUrl(url);   
      var xml = (new DOMParser()).parseFromString(xmlstr, "text/xml");   
      successCallback({ "responseXML" : { "documentElement" : xml }, "responseText" : xmlstr });
   }
}

ScribdApi.login = function(username, password, callback, callbackError)
{
	 ScribdApi.request("user.login", {
		 	"username": username,
		 	"password": password
		 },
	 	function(transport) {
         if (transport.responseText.match("<error") == null)
         {            
            var resp = ScribdApi.parseLoginResponse(transport.responseXML.documentElement);
            callback(resp);
         } else {            
            var code = XmlUtils.getFirstAttribute(transport.responseXML.documentElement, "error", "code");
            var message = XmlUtils.getFirstAttribute(transport.responseXML.documentElement, "error", "message");
            callbackError( { "Code" : code, "Message" : message } );
         }
		});
}

ScribdApi.signup = function(username, password, email, callback, callbackError)
{
	ScribdApi.request("user.signup", {
			"username": username,
			"password": password,
			"email": email
		},
	 	function(transport) {
         if (transport.responseText.match("<error") == null)
         {
            var resp = ScribdApi.parseLoginResponse(transport.responseXML.documentElement);
            callback(resp);
         } else {
            var code = XmlUtils.getFirstAttribute(transport.responseXML.documentElement, "error", "code");
            var message = XmlUtils.getFirstAttribute(transport.responseXML.documentElement, "error", "message");
            callbackError( { "Code" : code, "Message" : message } );
         }
		});
}

ScribdApi.mydocs = function(limit, offset, callback)
{
	ScribdApi.request("docs.getList", {
			"limit": limit,
			"offset": offset
		},
	 	function(transport) {
			var resp = ScribdApi.parseDocResults(transport.responseXML.documentElement);
			callback(resp);
		});
}

ScribdApi.search = function(query, scope, limit, offset, callback)
{		
	ScribdApi.request("docs.search", {
			"query": query,
			"scope": scope,
			"num_results": limit,
			"num_start": offset
		},
	 	function(transport) {
			var resp = ScribdApi.parseDocResults(transport.responseXML.documentElement);
			callback(resp);
		});
}

ScribdApi.browse = function(sort, category, limit, offset, callback)
{
	ScribdApi.request("docs.browse", { 
			"sort" : sort, 
			"category_id" : category, 
			"limit" : limit, 
			"offset" : offset 
		},
	 	function(transport) {
			var resp = ScribdApi.parseDocResults(transport.responseXML.documentElement);
			callback(resp);
		});
}

ScribdApi.categories = function(parentCatId, callback)
{
	ScribdApi.request("docs.getCategories", {
			//"category_id": parentCatId
		},
	 	function(transport) {
			var results = [];
			var resRaw = transport.responseXML.documentElement.getElementsByTagName("result");
			for (var i = 0; i < resRaw.length; i++) 
			{
				results[i] = {
					"Id": XmlUtils.getFirst(resRaw[i], "id"),
					"Name": XmlUtils.getFirst(resRaw[i], "name"),
				}
			}
			callback(results);
		});
}

ScribdApi.featured = function(scope, limit, offset, callback)
{
	ScribdApi.request("docs.featured", {
			"scope": scope,
			"limit": limit,
			"offset": offset
		},
	 	function(transport) {
			var resp = ScribdApi.parseDocResults(transport.responseXML.documentElement);
			callback(resp);
		});
}

ScribdApi.getSettings = function(docid, callback)
{
	ScribdApi.request("docs.getSettings", {
			"doc_id": docid
		},
	 	function(transport) {
			var resp = ScribdApi.parseDoc(transport.responseXML.documentElement);
			callback(resp);
		});
}

ScribdApi.getDownloadUrl = function(docid, callback)
{
/*	ScribdApi.request("docs.getDownloadUrl", {
			"doc_id": docid,
         "doc_type": "original"
		},
	 	function(transport) {
         alert(transport.responseText);
			var resp = XmlUtils.getFirst(transport.responseXML.documentElement, "download_link");
         if (resp != null && resp.length > 0)
   			callback(resp);
		}); */
   callback("http://www.scribd.com/mobile/documents/"+docid+"/download?commit=Download+Now");//http://www.scribd.com/document_downloads/"+docid+"?extension=pdf&skip_interstitial=true");
}

ScribdApi.parseSignupResponse = function(doc)
{
	return {
		"Name": XmlUtils.getFirst(doc, "name"),
		"UserName": XmlUtils.getFirst(doc, "username"),
		"UserId": XmlUtils.getFirst(doc, "user_id"),
		"SessionKey": XmlUtils.getFirst(doc, "session_key")
	};
}

ScribdApi.parseLoginResponse = function(doc)
{
	return {
		"Name": XmlUtils.getFirst(doc, "name"),
		"UserName": XmlUtils.getFirst(doc, "username"),
		"UserId": XmlUtils.getFirst(doc, "user_id"),
		"SessionKey": XmlUtils.getFirst(doc, "session_key")
	};
}

ScribdApi.parseDoc = function(doc)
{
	return {
		"AccessKey" : XmlUtils.getFirst(doc, "access_key"),
		"Access" : XmlUtils.getFirst(doc, "access"),
		"DownloadFormats" : XmlUtils.getFirst(doc, "download_formats"),
		"Author" : XmlUtils.getFirst(doc, "author"),
		"Publisher" : XmlUtils.getFirst(doc, "publisher"),
		"WhenPublished" : XmlUtils.getFirst(doc, "when_publishd"),
		"Edition" : XmlUtils.getFirst(doc, "edition"),
		"Description" : XmlUtils.getFirst(doc, "description"),
		"DocumentId" : XmlUtils.getFirst(doc, "doc_id"),
		"Tags" : XmlUtils.getFirst(doc, "tags"),
		"License" : XmlUtils.getFirst(doc, "license"),
		"ThumbnailUrl" : XmlUtils.getFirst(doc, "thumbnail_url"),
		"Isbn" : XmlUtils.getFirst(doc, "isbn"),
		"PageCount" : XmlUtils.getFirst(doc, "page_count"),
		"Title" : XmlUtils.getFirst(doc, "title"),
	};
}

ScribdApi.parseDocResults = function(doc)
{
	var resRaw = doc.getElementsByTagName("result");
   var results = [];
	for (var i = 0; i < resRaw.length; i++) 
	{
		results[i] = ScribdApi.parseDoc(resRaw[i]);		
	}
   return results;
}

