Keyboard = new Object();

var caps = false;
var shifted = false;
var lastTextbox;
var closeCallback;

Keyboard.OnButtonPressed = function(elem)
{
   if (lastTextbox != null)
   {
      lastTextbox.value = lastTextbox.value + elem.value;
      if (shifted == true) 
      {
         shifted = false;
         makeEverythingLowerCase();
      }
   }
}

Keyboard.OnDeleteButtonPressed = function(elem)
{
   if (lastTextbox != null)
   {
      lastTextbox.value = lastTextbox.value.substr(0,lastTextbox.value.length - 1);
   }
}

Keyboard.OnTabButtonPressed = function(elem)
{
}

Keyboard.OnEnterButtonPressed = function(elem)
{
   Keyboard.Close();
   if (closeCallback != null) closeCallback();
   closeCallback = null;
}

Keyboard.OnCapsLockButtonPressed = function(elem)
{
   if (caps)
   {
      makeEverythingLowerCase();
      caps = false;
   } else 
   {
      makeEverythingUpperCase();
      caps = true;
   }
   if (lastTextbox != null)
   {
      lastTextbox.focus();
   }
}

Keyboard.OnShiftButtonPressed = function(elem)
{
   if (shifted)
   {
      makeEverythingLowerCase();
      shifted = false;
   } else 
   {
      makeEverythingUpperCase();
      shifted = true;
   }
   if (lastTextbox != null)
   {
      lastTextbox.focus();
   }
}

Keyboard._makeEverythingUpperCase = function()
{
   var buttons = $('keyboard').getElementsByTagName('button');
   for(var i = 0; i < buttons.length; i++)
   {
      var butt = buttons[i];
         switch(butt.value)
         {
            case "1": butt.innerHTML = "!"; butt.value = "!"; break;
            case "2": butt.innerHTML = "@"; butt.value = "@"; break;
            case "3": butt.innerHTML = "#"; butt.value = "#"; break;
            case "4": butt.innerHTML = "$"; butt.value = "$"; break;
            case "5": butt.innerHTML = "%"; butt.value = "%"; break;
            case "6": butt.innerHTML = "^"; butt.value = "^"; break;
            case "7": butt.innerHTML = "&amp;"; butt.value = "&"; break;
            case "8": butt.innerHTML = "*"; butt.value = "*"; break;
            case "9": butt.innerHTML = "("; butt.value = "("; break;
            case "0": butt.innerHTML = ")"; butt.value = ")"; break;
            case "~": butt.innerHTML = "`"; butt.value = "`"; break;
            case ",": butt.innerHTML = "<"; butt.value = "<"; break;
            case ".": butt.innerHTML = ">"; butt.value = ">"; break;
            case "'": butt.innerHTML = "\""; butt.value = "\""; break;
            case ";": butt.innerHTML = ":"; butt.value = ":"; break;
            case "|": butt.innerHTML = "\\"; butt.value ="\\"; break;
            case "/": butt.innerHTML = "?"; butt.value ="?"; break;
            case "[": butt.innerHTML = "{"; butt.value = "{"; break;
            case "]": butt.innerHTML = "}"; butt.value = "}"; break;
            case "\"": butt.innerHTML ="'"; butt.value = "'"; break;
            case "\\": butt.innerHTML ="|"; butt.value = "|"; break;
            case "-":
                     butt.value = "_"; butt.innerHTML = "_";
                     break;
            case "=":
                     butt.value = "+"; butt.innerHTML = "+";
                     break;
            default:
                  if (butt.innerHTML != "shift" && 
                      butt.innerHTML != "space" &&
                      butt.innerHTML != "close" &&
                      butt.innerHTML != "caps" &&
                      butt.innerHTML != "tab" &&
                      butt.innerHTML != "back")
                  {
                     butt.value = butt.value.toUpperCase();
                     butt.innerHTML = butt.innerHTML.toUpperCase();
                  }
         }
   }
}

Keyboard._makeEverythingLowerCase = function()
{
   var buttons = $('keyboard').getElementsByTagName('button');
   for(var i = 0; i < buttons.length; i++)
   {
      var butt = buttons[i];
         switch(butt.value)
         {
            case "!": butt.innerHTML = "1"; butt.value = "1"; break;
            case "@": butt.innerHTML = "2"; butt.value = "2"; break;
            case "#": butt.innerHTML = "3"; butt.value = "3"; break;
            case "$": butt.innerHTML = "4"; butt.value = "4"; break;
            case "%": butt.innerHTML = "5"; butt.value = "5"; break;
            case "^": butt.innerHTML = "6"; butt.value = "6"; break;
            case "&": butt.innerHTML = "7"; butt.value = "7"; break;
            case "*": butt.innerHTML = "8"; butt.value = "8"; break;
            case "(": butt.innerHTML = "9"; butt.value = "9"; break;
            case ")": butt.innerHTML = "0"; butt.value = "0"; break;
            case "`": butt.innerHTML = "~"; butt.value = "~"; break;
            case "<": butt.innerHTML = ","; butt.value = ","; break;
            case ">": butt.innerHTML = "."; butt.value = "."; break;
            case "?": butt.innerHTML = "/"; butt.value = "/"; break;
            case ":": butt.innerHTML = ";"; butt.value = ";"; break;
            case "\"": butt.innerHTML = "'"; butt.value = "'"; break;
            case "{": butt.innerHTML = "["; butt.value = "["; break;
            case "}": butt.innerHTML = "]"; butt.value = "]"; break;
            case "|": butt.innerHTML = "\\"; butt.value = "\\"; break;
            case "_":
                  butt.value = "-"; butt.innerHTML = "-";
                  break;
            case "+": 
            case "|": butt.innerHTML = "\\"; butt.value ="\\"; break;
                  butt.value = "="; butt.innerHTML = "=";
                  break;
            default: 
                  if (butt.innerHTML != "shift" && 
                      butt.innerHTML != "space" &&
                      butt.innerHTML != "close" &&
                      butt.innerHTML != "tab" &&
                      butt.innerHTML != "caps" &&
                      butt.innerHTML != "back")
                  {
                     butt.value = butt.value.toLowerCase();
                     butt.innerHTML = butt.innerHTML.toLowerCase();
                  }
         }
   }
}

Keyboard.Open = function(elem, closeCb)
{
   lastTextbox = elem;
   closeCallback = closeCb;
   $('keyboard').style.display = 'block';
}

Keyboard.Close = function()
{
   $('keyboard').style.display = 'none';
}
