#!/bin/sh
#
# $Id: install.sh 6630 2010-08-10 22:38:22Z NiLuJe $
#
# diff OTA patch script

_FUNCTIONS=/etc/rc.d/functions
[ -f ${_FUNCTIONS} ] && . ${_FUNCTIONS}


MSG_SLLVL_D="debug"
MSG_SLLVL_I="info"
MSG_SLLVL_W="warn"
MSG_SLLVL_E="err"
MSG_SLLVL_C="crit"
MSG_SLNUM_D=0
MSG_SLNUM_I=1
MSG_SLNUM_W=2
MSG_SLNUM_E=3
MSG_SLNUM_C=4
MSG_CUR_LVL=/var/local/system/syslog_level

logmsg()
{
    local _NVPAIRS
    local _FREETEXT
    local _MSG_SLLVL
    local _MSG_SLNUM

    _MSG_LEVEL=$1
    _MSG_COMP=$2

    { [ $# -ge 4 ] && _NVPAIRS=$3 && shift ; }

    _FREETEXT=$3

    eval _MSG_SLLVL=\${MSG_SLLVL_$_MSG_LEVEL}
    eval _MSG_SLNUM=\${MSG_SLNUM_$_MSG_LEVEL}

    local _CURLVL

    { [ -f $MSG_CUR_LVL ] && _CURLVL=`cat $MSG_CUR_LVL` ; } || _CURLVL=1

    if [ $_MSG_SLNUM -ge $_CURLVL ]; then
        /usr/bin/logger -p local4.$_MSG_SLLVL -t "ota_install" "$_MSG_LEVEL def:$_MSG_COMP:$_NVPAIRS:$_FREETEXT"
    fi

    [ "$_MSG_LEVEL" != "D" ] && echo "ota_install: $_MSG_LEVEL def:$_MSG_COMP:$_NVPAIRS:$_FREETEXT"
}

if [ -z "${_PERCENT_COMPLETE}" ]; then
    export _PERCENT_COMPLETE=0
fi

update_percent_complete()
{
    _PERCENT_COMPLETE=$((${_PERCENT_COMPLETE} + $1))
    update_progressbar ${_PERCENT_COMPLETE}
}

# Hack specific config
HACKLOG="/mnt/us/prettyversion_cleanup.log"

update_percent_complete 2

# The goal here is to check that we're really in a vanilla state, to make sure official updates will install successfully, and not horribly die on a checksum failure on prettyversion.txt ;)
echo "** prettyversion.txt cleanup **" > ${HACKLOG}
echo "" >> ${HACKLOG}

update_progressbar 20

# Print the current prettyversion
echo "** PrettyVersion (Before):" >> ${HACKLOG}
cat /etc/prettyversion.txt >> ${HACKLOG} 2>&1
md5sum /etc/prettyversion.txt >> ${HACKLOG} 2>&1
echo "" >> ${HACKLOG}

update_progressbar 40

# Remove any extra tags
echo "** Cleaninp up..." >> ${HACKLOG}
sed -e 's/\(Kindle [[:digit:]]\.[[:digit:]]\.\?[[:digit:]]\?\)\( (~~otaVersion~~)\)\(.*\?\)/\1\2/' -i /etc/prettyversion.txt >> ${HACKLOG} 2>&1
HACK_CMD_RET=$?
echo "** Return code: ${HACK_CMD_RET}" >> ${HACKLOG}

update_progressbar 60

# And then we print the (hopefully) fixed prettyversion
echo "** PrettyVersion (After):" >> ${HACKLOG}
cat /etc/prettyversion.txt >> ${HACKLOG} 2>&1
md5sum /etc/prettyversion.txt >> ${HACKLOG} 2>&1
echo "" >> ${HACKLOG}

update_progressbar 80

# Just to make sure, print the expected md5sum of the stock prettyversion
echo "** Expected md5sum of prettyversion:" >> ${HACKLOG}
grep /etc/prettyversion.txt /test/diags/factory/rootfs_md5_list >> ${HACKLOG} 2>&1
echo "" >> ${HACKLOG}

update_progressbar 90

# Done!
echo "Done!" >> ${HACKLOG}

update_progressbar 100

return 0
