#!/bin/sh

# diff OTA patch script 

_FUNCTIONS=/etc/rc.d/functions
[ -f ${_FUNCTIONS} ] && . ${_FUNCTIONS}


MSG_SLLVL_D="debug"
MSG_SLLVL_I="info"
MSG_SLLVL_W="warn"
MSG_SLLVL_E="err"
MSG_SLLVL_C="crit"
MSG_SLNUM_D=0
MSG_SLNUM_I=1
MSG_SLNUM_W=2
MSG_SLNUM_E=3
MSG_SLNUM_C=4
MSG_CUR_LVL=/var/local/system/syslog_level

logmsg()
{
    local _NVPAIRS
    local _FREETEXT
    local _MSG_SLLVL
    local _MSG_SLNUM

    _MSG_LEVEL=$1
    _MSG_COMP=$2

    { [ $# -ge 4 ] && _NVPAIRS=$3 && shift ; }

    _FREETEXT=$3

    eval _MSG_SLLVL=\${MSG_SLLVL_$_MSG_LEVEL}
    eval _MSG_SLNUM=\${MSG_SLNUM_$_MSG_LEVEL}

    local _CURLVL

    { [ -f $MSG_CUR_LVL ] && _CURLVL=`cat $MSG_CUR_LVL` ; } || _CURLVL=1

    if [ $_MSG_SLNUM -ge $_CURLVL ]; then
        /usr/bin/logger -p local4.$_MSG_SLLVL -t "ota_install" "$_MSG_LEVEL def:$_MSG_COMP:$_NVPAIRS:$_FREETEXT"
    fi

    [ "$_MSG_LEVEL" != "D" ] && echo "ota_install: $_MSG_LEVEL def:$_MSG_COMP:$_NVPAIRS:$_FREETEXT"
}

if [ -z "${_COMPLETE_COUNT}" ]; then
    export _COMPLETE_COUNT=0
fi

_CUR_PERCENT_COMPLETE=-1

update_percent_complete()
{
    _COMPLETE_COUNT=$((${_COMPLETE_COUNT} + $1))

    local _PROGRESS_PERCENT=$(($((${_COMPLETE_COUNT} * 100)) / 144))

    if [ ${_CUR_PERCENT_COMPLETE} -ne ${_PROGRESS_PERCENT} ]; then
        update_progressbar ${_PROGRESS_PERCENT}

        _CUR_PERCENT_COMPLETE=${_PROGRESS_PERCENT}
    fi
}

update_percent_complete_unscaled()
{
	update_percent_complete $(($1 * 1))
}

update_percent_complete_unscaled 1

perform_patches()
{
  logmsg "I" "patch" "patchinfo=\"/bin/busybox\"" "patching file"

  mkdir -p patch/bin/
  bspatch /bin/busybox patch/bin/busybox 000.busybox.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/bin/busybox\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/bin/busybox | awk '{ print $1; }'`
  _EXPECTED_MD5=fabfb560617897e272e0ed672658fcff
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/bin/busybox\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /bin/busybox | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 6755 patch/bin/busybox
  rm -f 000.busybox.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/etc/crontab/root\"" "patching file"

  mkdir -p patch/etc/crontab/
  bspatch /etc/crontab/root patch/etc/crontab/root 001.root.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/etc/crontab/root\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/etc/crontab/root | awk '{ print $1; }'`
  _EXPECTED_MD5=a069711c0a820acfde5e20d6969101c3
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/etc/crontab/root\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /etc/crontab/root | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 644 patch/etc/crontab/root
  rm -f 001.root.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/etc/hosts\"" "patching file"

  mkdir -p patch/etc/
  bspatch /etc/hosts patch/etc/hosts 002.hosts.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/etc/hosts\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/etc/hosts | awk '{ print $1; }'`
  _EXPECTED_MD5=0e26ba4655c7c2fbdf39321d0ce76a30
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/etc/hosts\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /etc/hosts | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 644 patch/etc/hosts
  rm -f 002.hosts.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/etc/init.d/boot_finished\"" "patching file"

  mkdir -p patch/etc/init.d/
  bspatch /etc/init.d/boot_finished patch/etc/init.d/boot_finished 003.boot_finished.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/etc/init.d/boot_finished\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/etc/init.d/boot_finished | awk '{ print $1; }'`
  _EXPECTED_MD5=734ac55b9be0ffa26de7d20d2bdacac7
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/etc/init.d/boot_finished\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /etc/init.d/boot_finished | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 755 patch/etc/init.d/boot_finished
  rm -f 003.boot_finished.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/etc/init.d/filesystems\"" "patching file"

  mkdir -p patch/etc/init.d/
  bspatch /etc/init.d/filesystems patch/etc/init.d/filesystems 004.filesystems.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/etc/init.d/filesystems\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/etc/init.d/filesystems | awk '{ print $1; }'`
  _EXPECTED_MD5=eb6dce88a772cbe8cfa719a2269f78fc
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/etc/init.d/filesystems\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /etc/init.d/filesystems | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 755 patch/etc/init.d/filesystems
  rm -f 004.filesystems.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/etc/init.d/framework\"" "patching file"

  mkdir -p patch/etc/init.d/
  bspatch /etc/init.d/framework patch/etc/init.d/framework 005.framework.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/etc/init.d/framework\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/etc/init.d/framework | awk '{ print $1; }'`
  _EXPECTED_MD5=9291aa6e9098207b55fbe559f33dce96
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/etc/init.d/framework\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /etc/init.d/framework | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 755 patch/etc/init.d/framework
  rm -f 005.framework.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/etc/init.d/syslog-ng\"" "patching file"

  mkdir -p patch/etc/init.d/
  bspatch /etc/init.d/syslog-ng patch/etc/init.d/syslog-ng 006.syslog-ng.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/etc/init.d/syslog-ng\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/etc/init.d/syslog-ng | awk '{ print $1; }'`
  _EXPECTED_MD5=5f4c4e2030764c73f9f6c05a78d1f661
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/etc/init.d/syslog-ng\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /etc/init.d/syslog-ng | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 755 patch/etc/init.d/syslog-ng
  rm -f 006.syslog-ng.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/etc/init.d/tweaks\"" "patching file"

  mkdir -p patch/etc/init.d/
  bspatch /etc/init.d/tweaks patch/etc/init.d/tweaks 007.tweaks.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/etc/init.d/tweaks\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/etc/init.d/tweaks | awk '{ print $1; }'`
  _EXPECTED_MD5=19ad06b9e82da1226c06cf157ed5d839
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/etc/init.d/tweaks\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /etc/init.d/tweaks | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 755 patch/etc/init.d/tweaks
  rm -f 007.tweaks.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/etc/init.d/updater\"" "patching file"

  mkdir -p patch/etc/init.d/
  bspatch /etc/init.d/updater patch/etc/init.d/updater 008.updater.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/etc/init.d/updater\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/etc/init.d/updater | awk '{ print $1; }'`
  _EXPECTED_MD5=b229ae0cc7f7ee518a31bae163b2e13c
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/etc/init.d/updater\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /etc/init.d/updater | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 755 patch/etc/init.d/updater
  rm -f 008.updater.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/etc/init.d/userstore\"" "patching file"

  mkdir -p patch/etc/init.d/
  bspatch /etc/init.d/userstore patch/etc/init.d/userstore 009.userstore.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/etc/init.d/userstore\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/etc/init.d/userstore | awk '{ print $1; }'`
  _EXPECTED_MD5=f897c2a36ca9ef0cfc4b9ac5b59c76b6
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/etc/init.d/userstore\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /etc/init.d/userstore | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 755 patch/etc/init.d/userstore
  rm -f 009.userstore.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/etc/init.d/video\"" "patching file"

  mkdir -p patch/etc/init.d/
  bspatch /etc/init.d/video patch/etc/init.d/video 010.video.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/etc/init.d/video\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/etc/init.d/video | awk '{ print $1; }'`
  _EXPECTED_MD5=5dccdb8e0e7065933b729fcd8d1cbe88
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/etc/init.d/video\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /etc/init.d/video | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 755 patch/etc/init.d/video
  rm -f 010.video.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/etc/lipc-daemon-events.conf\"" "patching file"

  mkdir -p patch/etc/
  bspatch /etc/lipc-daemon-events.conf patch/etc/lipc-daemon-events.conf 011.lipc-daemon-events.conf.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/etc/lipc-daemon-events.conf\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/etc/lipc-daemon-events.conf | awk '{ print $1; }'`
  _EXPECTED_MD5=7367e19f61abb887b2b5348947ed4f7a
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/etc/lipc-daemon-events.conf\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /etc/lipc-daemon-events.conf | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 644 patch/etc/lipc-daemon-events.conf
  rm -f 011.lipc-daemon-events.conf.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/etc/lipc-daemon-props.conf\"" "patching file"

  mkdir -p patch/etc/
  bspatch /etc/lipc-daemon-props.conf patch/etc/lipc-daemon-props.conf 012.lipc-daemon-props.conf.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/etc/lipc-daemon-props.conf\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/etc/lipc-daemon-props.conf | awk '{ print $1; }'`
  _EXPECTED_MD5=6d9d9a6b18590263024a5a0ac3024b49
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/etc/lipc-daemon-props.conf\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /etc/lipc-daemon-props.conf | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 644 patch/etc/lipc-daemon-props.conf
  rm -f 012.lipc-daemon-props.conf.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/etc/pmond/netwatchd.conf\"" "patching file"

  mkdir -p patch/etc/pmond/
  bspatch /etc/pmond/netwatchd.conf patch/etc/pmond/netwatchd.conf 013.netwatchd.conf.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/etc/pmond/netwatchd.conf\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/etc/pmond/netwatchd.conf | awk '{ print $1; }'`
  _EXPECTED_MD5=8188c8daa2cbd56472ad07baafcb02c4
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/etc/pmond/netwatchd.conf\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /etc/pmond/netwatchd.conf | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 644 patch/etc/pmond/netwatchd.conf
  rm -f 013.netwatchd.conf.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/etc/powerd.conf.n\"" "patching file"

  mkdir -p patch/etc/
  bspatch /etc/powerd.conf.n patch/etc/powerd.conf.n 014.powerd.conf.n.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/etc/powerd.conf.n\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/etc/powerd.conf.n | awk '{ print $1; }'`
  _EXPECTED_MD5=56033a4fc1aaf06d23676d6cd02f68b0
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/etc/powerd.conf.n\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /etc/powerd.conf.n | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 644 patch/etc/powerd.conf.n
  rm -f 014.powerd.conf.n.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/etc/powerd.conf.t\"" "patching file"

  mkdir -p patch/etc/
  bspatch /etc/powerd.conf.t patch/etc/powerd.conf.t 015.powerd.conf.t.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/etc/powerd.conf.t\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/etc/powerd.conf.t | awk '{ print $1; }'`
  _EXPECTED_MD5=c3d063b35d5dc87bd81528f6e995d1e3
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/etc/powerd.conf.t\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /etc/powerd.conf.t | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 644 patch/etc/powerd.conf.t
  rm -f 015.powerd.conf.t.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/etc/ppp/peers/peer-1\"" "patching file"

  mkdir -p patch/etc/ppp/peers/
  bspatch /etc/ppp/peers/peer-1 patch/etc/ppp/peers/peer-1 016.peer-1.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/etc/ppp/peers/peer-1\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/etc/ppp/peers/peer-1 | awk '{ print $1; }'`
  _EXPECTED_MD5=8366bae3a55ed26cb2bbc0d831c3cc56
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/etc/ppp/peers/peer-1\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /etc/ppp/peers/peer-1 | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 644 patch/etc/ppp/peers/peer-1
  rm -f 016.peer-1.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/etc/ppp/peers/peer-2\"" "patching file"

  mkdir -p patch/etc/ppp/peers/
  bspatch /etc/ppp/peers/peer-2 patch/etc/ppp/peers/peer-2 017.peer-2.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/etc/ppp/peers/peer-2\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/etc/ppp/peers/peer-2 | awk '{ print $1; }'`
  _EXPECTED_MD5=1fc85708ed038746635a29fe8609581a
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/etc/ppp/peers/peer-2\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /etc/ppp/peers/peer-2 | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 644 patch/etc/ppp/peers/peer-2
  rm -f 017.peer-2.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/etc/ppp/peers/peer-3\"" "patching file"

  mkdir -p patch/etc/ppp/peers/
  bspatch /etc/ppp/peers/peer-3 patch/etc/ppp/peers/peer-3 018.peer-3.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/etc/ppp/peers/peer-3\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/etc/ppp/peers/peer-3 | awk '{ print $1; }'`
  _EXPECTED_MD5=bb8e8520a5f2915f70c72d3dc192c998
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/etc/ppp/peers/peer-3\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /etc/ppp/peers/peer-3 | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 644 patch/etc/ppp/peers/peer-3
  rm -f 018.peer-3.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/etc/prettyversion.txt\"" "patching file"

  mkdir -p patch/etc/
  bspatch /etc/prettyversion.txt patch/etc/prettyversion.txt 019.prettyversion.txt.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/etc/prettyversion.txt\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/etc/prettyversion.txt | awk '{ print $1; }'`
  _EXPECTED_MD5=3b12a4727e81301edf2e06224086e316
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/etc/prettyversion.txt\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /etc/prettyversion.txt | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 755 patch/etc/prettyversion.txt
  rm -f 019.prettyversion.txt.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/etc/rc.d/features\"" "patching file"

  mkdir -p patch/etc/rc.d/
  bspatch /etc/rc.d/features patch/etc/rc.d/features 020.features.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/etc/rc.d/features\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/etc/rc.d/features | awk '{ print $1; }'`
  _EXPECTED_MD5=30050d2664cc172b79a3e182d04385f6
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/etc/rc.d/features\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /etc/rc.d/features | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 644 patch/etc/rc.d/features
  rm -f 020.features.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/etc/rc.d/functions\"" "patching file"

  mkdir -p patch/etc/rc.d/
  bspatch /etc/rc.d/functions patch/etc/rc.d/functions 021.functions.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/etc/rc.d/functions\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/etc/rc.d/functions | awk '{ print $1; }'`
  _EXPECTED_MD5=e89ce98dfbaf50659439a3d6a67cdf2f
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/etc/rc.d/functions\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /etc/rc.d/functions | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 644 patch/etc/rc.d/functions
  rm -f 021.functions.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/etc/version.txt\"" "patching file"

  mkdir -p patch/etc/
  bspatch /etc/version.txt patch/etc/version.txt 022.version.txt.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/etc/version.txt\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/etc/version.txt | awk '{ print $1; }'`
  _EXPECTED_MD5=12038b99538cbfcc3be3872359426ed5
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/etc/version.txt\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /etc/version.txt | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 644 patch/etc/version.txt
  rm -f 022.version.txt.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/lib/modules/2.6.22.19-lab126/kernel/drivers/input/keyboard/mxc_keyb.ko\"" "patching file"

  mkdir -p patch/lib/modules/2.6.22.19-lab126/kernel/drivers/input/keyboard/
  bspatch /lib/modules/2.6.22.19-lab126/kernel/drivers/input/keyboard/mxc_keyb.ko patch/lib/modules/2.6.22.19-lab126/kernel/drivers/input/keyboard/mxc_keyb.ko 023.mxc_keyb.ko.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/lib/modules/2.6.22.19-lab126/kernel/drivers/input/keyboard/mxc_keyb.ko\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/lib/modules/2.6.22.19-lab126/kernel/drivers/input/keyboard/mxc_keyb.ko | awk '{ print $1; }'`
  _EXPECTED_MD5=fc272a58c6ea71af1541e6588145f84c
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/lib/modules/2.6.22.19-lab126/kernel/drivers/input/keyboard/mxc_keyb.ko\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /lib/modules/2.6.22.19-lab126/kernel/drivers/input/keyboard/mxc_keyb.ko | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 644 patch/lib/modules/2.6.22.19-lab126/kernel/drivers/input/keyboard/mxc_keyb.ko
  rm -f 023.mxc_keyb.ko.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/lib/modules/2.6.22.19-lab126/kernel/drivers/mxc/charger/charger.ko\"" "patching file"

  mkdir -p patch/lib/modules/2.6.22.19-lab126/kernel/drivers/mxc/charger/
  bspatch /lib/modules/2.6.22.19-lab126/kernel/drivers/mxc/charger/charger.ko patch/lib/modules/2.6.22.19-lab126/kernel/drivers/mxc/charger/charger.ko 024.charger.ko.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/lib/modules/2.6.22.19-lab126/kernel/drivers/mxc/charger/charger.ko\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/lib/modules/2.6.22.19-lab126/kernel/drivers/mxc/charger/charger.ko | awk '{ print $1; }'`
  _EXPECTED_MD5=9f2242143327aaec642078f268226053
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/lib/modules/2.6.22.19-lab126/kernel/drivers/mxc/charger/charger.ko\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /lib/modules/2.6.22.19-lab126/kernel/drivers/mxc/charger/charger.ko | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 644 patch/lib/modules/2.6.22.19-lab126/kernel/drivers/mxc/charger/charger.ko
  rm -f 024.charger.ko.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/lib/modules/2.6.22.19-lab126/kernel/drivers/usb/core/usbcore.ko\"" "patching file"

  mkdir -p patch/lib/modules/2.6.22.19-lab126/kernel/drivers/usb/core/
  bspatch /lib/modules/2.6.22.19-lab126/kernel/drivers/usb/core/usbcore.ko patch/lib/modules/2.6.22.19-lab126/kernel/drivers/usb/core/usbcore.ko 025.usbcore.ko.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/lib/modules/2.6.22.19-lab126/kernel/drivers/usb/core/usbcore.ko\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/lib/modules/2.6.22.19-lab126/kernel/drivers/usb/core/usbcore.ko | awk '{ print $1; }'`
  _EXPECTED_MD5=41d0cb7d56e5b0ec9f40aa739df6205b
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/lib/modules/2.6.22.19-lab126/kernel/drivers/usb/core/usbcore.ko\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /lib/modules/2.6.22.19-lab126/kernel/drivers/usb/core/usbcore.ko | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 644 patch/lib/modules/2.6.22.19-lab126/kernel/drivers/usb/core/usbcore.ko
  rm -f 025.usbcore.ko.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/lib/modules/2.6.22.19-lab126/kernel/drivers/usb/gadget/arcotg_udc.ko\"" "patching file"

  mkdir -p patch/lib/modules/2.6.22.19-lab126/kernel/drivers/usb/gadget/
  bspatch /lib/modules/2.6.22.19-lab126/kernel/drivers/usb/gadget/arcotg_udc.ko patch/lib/modules/2.6.22.19-lab126/kernel/drivers/usb/gadget/arcotg_udc.ko 026.arcotg_udc.ko.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/lib/modules/2.6.22.19-lab126/kernel/drivers/usb/gadget/arcotg_udc.ko\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/lib/modules/2.6.22.19-lab126/kernel/drivers/usb/gadget/arcotg_udc.ko | awk '{ print $1; }'`
  _EXPECTED_MD5=d5d0304a673f58c0633199f632ec72ae
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/lib/modules/2.6.22.19-lab126/kernel/drivers/usb/gadget/arcotg_udc.ko\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /lib/modules/2.6.22.19-lab126/kernel/drivers/usb/gadget/arcotg_udc.ko | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 644 patch/lib/modules/2.6.22.19-lab126/kernel/drivers/usb/gadget/arcotg_udc.ko
  rm -f 026.arcotg_udc.ko.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/lib/modules/2.6.22.19-lab126/kernel/drivers/usb/gadget/g_file_storage.ko\"" "patching file"

  mkdir -p patch/lib/modules/2.6.22.19-lab126/kernel/drivers/usb/gadget/
  bspatch /lib/modules/2.6.22.19-lab126/kernel/drivers/usb/gadget/g_file_storage.ko patch/lib/modules/2.6.22.19-lab126/kernel/drivers/usb/gadget/g_file_storage.ko 027.g_file_storage.ko.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/lib/modules/2.6.22.19-lab126/kernel/drivers/usb/gadget/g_file_storage.ko\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/lib/modules/2.6.22.19-lab126/kernel/drivers/usb/gadget/g_file_storage.ko | awk '{ print $1; }'`
  _EXPECTED_MD5=ffee26ae38df4262500af2a3a5d8285f
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/lib/modules/2.6.22.19-lab126/kernel/drivers/usb/gadget/g_file_storage.ko\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /lib/modules/2.6.22.19-lab126/kernel/drivers/usb/gadget/g_file_storage.ko | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 644 patch/lib/modules/2.6.22.19-lab126/kernel/drivers/usb/gadget/g_file_storage.ko
  rm -f 027.g_file_storage.ko.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/lib/modules/2.6.22.19-lab126/kernel/drivers/video/eink/hal/eink_fb_hal_broads.ko\"" "patching file"

  mkdir -p patch/lib/modules/2.6.22.19-lab126/kernel/drivers/video/eink/hal/
  bspatch /lib/modules/2.6.22.19-lab126/kernel/drivers/video/eink/hal/eink_fb_hal_broads.ko patch/lib/modules/2.6.22.19-lab126/kernel/drivers/video/eink/hal/eink_fb_hal_broads.ko 028.eink_fb_hal_broads.ko.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/lib/modules/2.6.22.19-lab126/kernel/drivers/video/eink/hal/eink_fb_hal_broads.ko\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/lib/modules/2.6.22.19-lab126/kernel/drivers/video/eink/hal/eink_fb_hal_broads.ko | awk '{ print $1; }'`
  _EXPECTED_MD5=d1f8d2c33982a2d0d3b2010cfa819c68
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/lib/modules/2.6.22.19-lab126/kernel/drivers/video/eink/hal/eink_fb_hal_broads.ko\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /lib/modules/2.6.22.19-lab126/kernel/drivers/video/eink/hal/eink_fb_hal_broads.ko | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 644 patch/lib/modules/2.6.22.19-lab126/kernel/drivers/video/eink/hal/eink_fb_hal_broads.ko
  rm -f 028.eink_fb_hal_broads.ko.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/lib/modules/2.6.22.19-lab126/kernel/drivers/video/eink/hal/eink_fb_hal_emu.ko\"" "patching file"

  mkdir -p patch/lib/modules/2.6.22.19-lab126/kernel/drivers/video/eink/hal/
  bspatch /lib/modules/2.6.22.19-lab126/kernel/drivers/video/eink/hal/eink_fb_hal_emu.ko patch/lib/modules/2.6.22.19-lab126/kernel/drivers/video/eink/hal/eink_fb_hal_emu.ko 029.eink_fb_hal_emu.ko.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/lib/modules/2.6.22.19-lab126/kernel/drivers/video/eink/hal/eink_fb_hal_emu.ko\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/lib/modules/2.6.22.19-lab126/kernel/drivers/video/eink/hal/eink_fb_hal_emu.ko | awk '{ print $1; }'`
  _EXPECTED_MD5=b7cfc9037cececd164972a8495e7ddad
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/lib/modules/2.6.22.19-lab126/kernel/drivers/video/eink/hal/eink_fb_hal_emu.ko\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /lib/modules/2.6.22.19-lab126/kernel/drivers/video/eink/hal/eink_fb_hal_emu.ko | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 644 patch/lib/modules/2.6.22.19-lab126/kernel/drivers/video/eink/hal/eink_fb_hal_emu.ko
  rm -f 029.eink_fb_hal_emu.ko.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/lib/modules/2.6.22.19-lab126/kernel/drivers/video/eink/hal/eink_fb_hal.ko\"" "patching file"

  mkdir -p patch/lib/modules/2.6.22.19-lab126/kernel/drivers/video/eink/hal/
  bspatch /lib/modules/2.6.22.19-lab126/kernel/drivers/video/eink/hal/eink_fb_hal.ko patch/lib/modules/2.6.22.19-lab126/kernel/drivers/video/eink/hal/eink_fb_hal.ko 030.eink_fb_hal.ko.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/lib/modules/2.6.22.19-lab126/kernel/drivers/video/eink/hal/eink_fb_hal.ko\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/lib/modules/2.6.22.19-lab126/kernel/drivers/video/eink/hal/eink_fb_hal.ko | awk '{ print $1; }'`
  _EXPECTED_MD5=65859e8b83f63ec90f0a81b245bcc3ea
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/lib/modules/2.6.22.19-lab126/kernel/drivers/video/eink/hal/eink_fb_hal.ko\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /lib/modules/2.6.22.19-lab126/kernel/drivers/video/eink/hal/eink_fb_hal.ko | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 644 patch/lib/modules/2.6.22.19-lab126/kernel/drivers/video/eink/hal/eink_fb_hal.ko
  rm -f 030.eink_fb_hal.ko.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/lib/modules/2.6.22.19-lab126/kernel/drivers/video/eink/legacy/eink_fb_shim.ko\"" "patching file"

  mkdir -p patch/lib/modules/2.6.22.19-lab126/kernel/drivers/video/eink/legacy/
  bspatch /lib/modules/2.6.22.19-lab126/kernel/drivers/video/eink/legacy/eink_fb_shim.ko patch/lib/modules/2.6.22.19-lab126/kernel/drivers/video/eink/legacy/eink_fb_shim.ko 031.eink_fb_shim.ko.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/lib/modules/2.6.22.19-lab126/kernel/drivers/video/eink/legacy/eink_fb_shim.ko\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/lib/modules/2.6.22.19-lab126/kernel/drivers/video/eink/legacy/eink_fb_shim.ko | awk '{ print $1; }'`
  _EXPECTED_MD5=cf11565edbdf896b6297cd2aaf3abfee
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/lib/modules/2.6.22.19-lab126/kernel/drivers/video/eink/legacy/eink_fb_shim.ko\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /lib/modules/2.6.22.19-lab126/kernel/drivers/video/eink/legacy/eink_fb_shim.ko | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 644 patch/lib/modules/2.6.22.19-lab126/kernel/drivers/video/eink/legacy/eink_fb_shim.ko
  rm -f 031.eink_fb_shim.ko.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/opt/amazon/ebook/bin/start.sh\"" "patching file"

  mkdir -p patch/opt/amazon/ebook/bin/
  bspatch /opt/amazon/ebook/bin/start.sh patch/opt/amazon/ebook/bin/start.sh 032.start.sh.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/opt/amazon/ebook/bin/start.sh\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/opt/amazon/ebook/bin/start.sh | awk '{ print $1; }'`
  _EXPECTED_MD5=9520aa2af9baf4dec101040455a3d471
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/opt/amazon/ebook/bin/start.sh\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /opt/amazon/ebook/bin/start.sh | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 755 patch/opt/amazon/ebook/bin/start.sh
  rm -f 032.start.sh.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/opt/amazon/ebook/booklet/AudiblePlayer.jar\"" "patching file"

  mkdir -p patch/opt/amazon/ebook/booklet/
  bspatch /opt/amazon/ebook/booklet/AudiblePlayer.jar patch/opt/amazon/ebook/booklet/AudiblePlayer.jar 033.AudiblePlayer.jar.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/opt/amazon/ebook/booklet/AudiblePlayer.jar\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/opt/amazon/ebook/booklet/AudiblePlayer.jar | awk '{ print $1; }'`
  _EXPECTED_MD5=1a3a6eef2ecfbf3f8ffb26232e8165c4
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/opt/amazon/ebook/booklet/AudiblePlayer.jar\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /opt/amazon/ebook/booklet/AudiblePlayer.jar | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 644 patch/opt/amazon/ebook/booklet/AudiblePlayer.jar
  rm -f 033.AudiblePlayer.jar.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/opt/amazon/ebook/booklet/AudioPlayer.jar\"" "patching file"

  mkdir -p patch/opt/amazon/ebook/booklet/
  bspatch /opt/amazon/ebook/booklet/AudioPlayer.jar patch/opt/amazon/ebook/booklet/AudioPlayer.jar 034.AudioPlayer.jar.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/opt/amazon/ebook/booklet/AudioPlayer.jar\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/opt/amazon/ebook/booklet/AudioPlayer.jar | awk '{ print $1; }'`
  _EXPECTED_MD5=79d7f17d8e5ef7c9c8c65c93bc40bc28
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/opt/amazon/ebook/booklet/AudioPlayer.jar\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /opt/amazon/ebook/booklet/AudioPlayer.jar | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 644 patch/opt/amazon/ebook/booklet/AudioPlayer.jar
  rm -f 034.AudioPlayer.jar.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/opt/amazon/ebook/booklet/Browser.jar\"" "patching file"

  mkdir -p patch/opt/amazon/ebook/booklet/
  bspatch /opt/amazon/ebook/booklet/Browser.jar patch/opt/amazon/ebook/booklet/Browser.jar 035.Browser.jar.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/opt/amazon/ebook/booklet/Browser.jar\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/opt/amazon/ebook/booklet/Browser.jar | awk '{ print $1; }'`
  _EXPECTED_MD5=2e261d7844016e34aa5c3d4ebf7325b9
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/opt/amazon/ebook/booklet/Browser.jar\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /opt/amazon/ebook/booklet/Browser.jar | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 644 patch/opt/amazon/ebook/booklet/Browser.jar
  rm -f 035.Browser.jar.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/opt/amazon/ebook/booklet/Home.jar\"" "patching file"

  mkdir -p patch/opt/amazon/ebook/booklet/
  bspatch /opt/amazon/ebook/booklet/Home.jar patch/opt/amazon/ebook/booklet/Home.jar 036.Home.jar.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/opt/amazon/ebook/booklet/Home.jar\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/opt/amazon/ebook/booklet/Home.jar | awk '{ print $1; }'`
  _EXPECTED_MD5=e7cbe7fcc869203cbb0f31e14d518d88
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/opt/amazon/ebook/booklet/Home.jar\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /opt/amazon/ebook/booklet/Home.jar | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 644 patch/opt/amazon/ebook/booklet/Home.jar
  rm -f 036.Home.jar.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/opt/amazon/ebook/booklet/MobiReader.jar\"" "patching file"

  mkdir -p patch/opt/amazon/ebook/booklet/
  bspatch /opt/amazon/ebook/booklet/MobiReader.jar patch/opt/amazon/ebook/booklet/MobiReader.jar 037.MobiReader.jar.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/opt/amazon/ebook/booklet/MobiReader.jar\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/opt/amazon/ebook/booklet/MobiReader.jar | awk '{ print $1; }'`
  _EXPECTED_MD5=8d3b4648860ec3f549fa8879fc805df7
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/opt/amazon/ebook/booklet/MobiReader.jar\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /opt/amazon/ebook/booklet/MobiReader.jar | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 644 patch/opt/amazon/ebook/booklet/MobiReader.jar
  rm -f 037.MobiReader.jar.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/opt/amazon/ebook/booklet/msp.jar\"" "patching file"

  mkdir -p patch/opt/amazon/ebook/booklet/
  bspatch /opt/amazon/ebook/booklet/msp.jar patch/opt/amazon/ebook/booklet/msp.jar 038.msp.jar.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/opt/amazon/ebook/booklet/msp.jar\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/opt/amazon/ebook/booklet/msp.jar | awk '{ print $1; }'`
  _EXPECTED_MD5=b62552d8ec0cd5e5ab3d7eec2ed1b3ed
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/opt/amazon/ebook/booklet/msp.jar\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /opt/amazon/ebook/booklet/msp.jar | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 644 patch/opt/amazon/ebook/booklet/msp.jar
  rm -f 038.msp.jar.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/opt/amazon/ebook/booklet/PictureViewer.jar\"" "patching file"

  mkdir -p patch/opt/amazon/ebook/booklet/
  bspatch /opt/amazon/ebook/booklet/PictureViewer.jar patch/opt/amazon/ebook/booklet/PictureViewer.jar 039.PictureViewer.jar.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/opt/amazon/ebook/booklet/PictureViewer.jar\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/opt/amazon/ebook/booklet/PictureViewer.jar | awk '{ print $1; }'`
  _EXPECTED_MD5=0fdbbdd8a42a6ce1b02b7bbccc60be36
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/opt/amazon/ebook/booklet/PictureViewer.jar\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /opt/amazon/ebook/booklet/PictureViewer.jar | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 644 patch/opt/amazon/ebook/booklet/PictureViewer.jar
  rm -f 039.PictureViewer.jar.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/opt/amazon/ebook/booklet/Search.jar\"" "patching file"

  mkdir -p patch/opt/amazon/ebook/booklet/
  bspatch /opt/amazon/ebook/booklet/Search.jar patch/opt/amazon/ebook/booklet/Search.jar 040.Search.jar.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/opt/amazon/ebook/booklet/Search.jar\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/opt/amazon/ebook/booklet/Search.jar | awk '{ print $1; }'`
  _EXPECTED_MD5=8950b8441c522869500660181949e01c
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/opt/amazon/ebook/booklet/Search.jar\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /opt/amazon/ebook/booklet/Search.jar | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 644 patch/opt/amazon/ebook/booklet/Search.jar
  rm -f 040.Search.jar.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/opt/amazon/ebook/booklet/XymlBooklet.jar\"" "patching file"

  mkdir -p patch/opt/amazon/ebook/booklet/
  bspatch /opt/amazon/ebook/booklet/XymlBooklet.jar patch/opt/amazon/ebook/booklet/XymlBooklet.jar 041.XymlBooklet.jar.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/opt/amazon/ebook/booklet/XymlBooklet.jar\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/opt/amazon/ebook/booklet/XymlBooklet.jar | awk '{ print $1; }'`
  _EXPECTED_MD5=0aaa89a8325ed7fb8030158ea453f5d3
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/opt/amazon/ebook/booklet/XymlBooklet.jar\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /opt/amazon/ebook/booklet/XymlBooklet.jar | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 644 patch/opt/amazon/ebook/booklet/XymlBooklet.jar
  rm -f 041.XymlBooklet.jar.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/opt/amazon/ebook/config/browser_prefs\"" "patching file"

  mkdir -p patch/opt/amazon/ebook/config/
  bspatch /opt/amazon/ebook/config/browser_prefs patch/opt/amazon/ebook/config/browser_prefs 042.browser_prefs.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/opt/amazon/ebook/config/browser_prefs\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/opt/amazon/ebook/config/browser_prefs | awk '{ print $1; }'`
  _EXPECTED_MD5=bbfcdda6010aefe03ceafcbfcc1a41da
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/opt/amazon/ebook/config/browser_prefs\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /opt/amazon/ebook/config/browser_prefs | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 644 patch/opt/amazon/ebook/config/browser_prefs
  rm -f 042.browser_prefs.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/opt/amazon/ebook/config/framework.fiona.conf\"" "patching file"

  mkdir -p patch/opt/amazon/ebook/config/
  bspatch /opt/amazon/ebook/config/framework.fiona.conf patch/opt/amazon/ebook/config/framework.fiona.conf 043.framework.fiona.conf.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/opt/amazon/ebook/config/framework.fiona.conf\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/opt/amazon/ebook/config/framework.fiona.conf | awk '{ print $1; }'`
  _EXPECTED_MD5=2537a895245ded09494199bfb17e6fab
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/opt/amazon/ebook/config/framework.fiona.conf\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /opt/amazon/ebook/config/framework.fiona.conf | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 644 patch/opt/amazon/ebook/config/framework.fiona.conf
  rm -f 043.framework.fiona.conf.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/opt/amazon/ebook/config/framework.mario.conf\"" "patching file"

  mkdir -p patch/opt/amazon/ebook/config/
  bspatch /opt/amazon/ebook/config/framework.mario.conf patch/opt/amazon/ebook/config/framework.mario.conf 044.framework.mario.conf.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/opt/amazon/ebook/config/framework.mario.conf\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/opt/amazon/ebook/config/framework.mario.conf | awk '{ print $1; }'`
  _EXPECTED_MD5=4e0e386401fe76120f5058343ae2254d
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/opt/amazon/ebook/config/framework.mario.conf\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /opt/amazon/ebook/config/framework.mario.conf | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 644 patch/opt/amazon/ebook/config/framework.mario.conf
  rm -f 044.framework.mario.conf.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/opt/amazon/ebook/config/internal.conf\"" "patching file"

  mkdir -p patch/opt/amazon/ebook/config/
  bspatch /opt/amazon/ebook/config/internal.conf patch/opt/amazon/ebook/config/internal.conf 045.internal.conf.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/opt/amazon/ebook/config/internal.conf\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/opt/amazon/ebook/config/internal.conf | awk '{ print $1; }'`
  _EXPECTED_MD5=0278eae97df4de77275946e54bcf84e5
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/opt/amazon/ebook/config/internal.conf\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /opt/amazon/ebook/config/internal.conf | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 644 patch/opt/amazon/ebook/config/internal.conf
  rm -f 045.internal.conf.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/opt/amazon/ebook/config/netfront.ini\"" "patching file"

  mkdir -p patch/opt/amazon/ebook/config/
  bspatch /opt/amazon/ebook/config/netfront.ini patch/opt/amazon/ebook/config/netfront.ini 046.netfront.ini.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/opt/amazon/ebook/config/netfront.ini\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/opt/amazon/ebook/config/netfront.ini | awk '{ print $1; }'`
  _EXPECTED_MD5=1c02ca97a1f1718a621ee72f3586b878
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/opt/amazon/ebook/config/netfront.ini\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /opt/amazon/ebook/config/netfront.ini | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 644 patch/opt/amazon/ebook/config/netfront.ini
  rm -f 046.netfront.ini.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/opt/amazon/ebook/config/reader.conf\"" "patching file"

  mkdir -p patch/opt/amazon/ebook/config/
  bspatch /opt/amazon/ebook/config/reader.conf patch/opt/amazon/ebook/config/reader.conf 047.reader.conf.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/opt/amazon/ebook/config/reader.conf\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/opt/amazon/ebook/config/reader.conf | awk '{ print $1; }'`
  _EXPECTED_MD5=90e85edb44f9d9b4c8dd01e2778b17ef
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/opt/amazon/ebook/config/reader.conf\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /opt/amazon/ebook/config/reader.conf | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 644 patch/opt/amazon/ebook/config/reader.conf
  rm -f 047.reader.conf.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/opt/amazon/ebook/lib/backport-util-concurrent-3.1.jar\"" "patching file"

  mkdir -p patch/opt/amazon/ebook/lib/
  bspatch /opt/amazon/ebook/lib/backport-util-concurrent-3.1.jar patch/opt/amazon/ebook/lib/backport-util-concurrent-3.1.jar 048.backport-util-concurrent-3.1.jar.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/opt/amazon/ebook/lib/backport-util-concurrent-3.1.jar\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/opt/amazon/ebook/lib/backport-util-concurrent-3.1.jar | awk '{ print $1; }'`
  _EXPECTED_MD5=dce6889c579ecec00b12e635f8ea6720
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/opt/amazon/ebook/lib/backport-util-concurrent-3.1.jar\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /opt/amazon/ebook/lib/backport-util-concurrent-3.1.jar | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 644 patch/opt/amazon/ebook/lib/backport-util-concurrent-3.1.jar
  rm -f 048.backport-util-concurrent-3.1.jar.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/opt/amazon/ebook/lib/booklet.jar\"" "patching file"

  mkdir -p patch/opt/amazon/ebook/lib/
  bspatch /opt/amazon/ebook/lib/booklet.jar patch/opt/amazon/ebook/lib/booklet.jar 049.booklet.jar.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/opt/amazon/ebook/lib/booklet.jar\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/opt/amazon/ebook/lib/booklet.jar | awk '{ print $1; }'`
  _EXPECTED_MD5=537e7b28a1d552d6e80f7151e2b43851
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/opt/amazon/ebook/lib/booklet.jar\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /opt/amazon/ebook/lib/booklet.jar | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 644 patch/opt/amazon/ebook/lib/booklet.jar
  rm -f 049.booklet.jar.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/opt/amazon/ebook/lib/framework-api.jar\"" "patching file"

  mkdir -p patch/opt/amazon/ebook/lib/
  bspatch /opt/amazon/ebook/lib/framework-api.jar patch/opt/amazon/ebook/lib/framework-api.jar 050.framework-api.jar.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/opt/amazon/ebook/lib/framework-api.jar\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/opt/amazon/ebook/lib/framework-api.jar | awk '{ print $1; }'`
  _EXPECTED_MD5=9a9b0462a4d0c2fd02fcff970546c72b
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/opt/amazon/ebook/lib/framework-api.jar\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /opt/amazon/ebook/lib/framework-api.jar | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 644 patch/opt/amazon/ebook/lib/framework-api.jar
  rm -f 050.framework-api.jar.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/opt/amazon/ebook/lib/framework-impl.jar\"" "patching file"

  mkdir -p patch/opt/amazon/ebook/lib/
  bspatch /opt/amazon/ebook/lib/framework-impl.jar patch/opt/amazon/ebook/lib/framework-impl.jar 051.framework-impl.jar.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/opt/amazon/ebook/lib/framework-impl.jar\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/opt/amazon/ebook/lib/framework-impl.jar | awk '{ print $1; }'`
  _EXPECTED_MD5=225d7ea2b91e2f4066916058c1890d0a
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/opt/amazon/ebook/lib/framework-impl.jar\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /opt/amazon/ebook/lib/framework-impl.jar | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 644 patch/opt/amazon/ebook/lib/framework-impl.jar
  rm -f 051.framework-impl.jar.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/opt/amazon/ebook/lib/jdbm.jar\"" "patching file"

  mkdir -p patch/opt/amazon/ebook/lib/
  bspatch /opt/amazon/ebook/lib/jdbm.jar patch/opt/amazon/ebook/lib/jdbm.jar 052.jdbm.jar.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/opt/amazon/ebook/lib/jdbm.jar\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/opt/amazon/ebook/lib/jdbm.jar | awk '{ print $1; }'`
  _EXPECTED_MD5=6934818c165eea98df2ff5e2fec13c8d
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/opt/amazon/ebook/lib/jdbm.jar\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /opt/amazon/ebook/lib/jdbm.jar | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 644 patch/opt/amazon/ebook/lib/jdbm.jar
  rm -f 052.jdbm.jar.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/opt/amazon/ebook/lib/json.jar\"" "patching file"

  mkdir -p patch/opt/amazon/ebook/lib/
  bspatch /opt/amazon/ebook/lib/json.jar patch/opt/amazon/ebook/lib/json.jar 053.json.jar.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/opt/amazon/ebook/lib/json.jar\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/opt/amazon/ebook/lib/json.jar | awk '{ print $1; }'`
  _EXPECTED_MD5=effbc2e8a1181c6aa85e3c17a397143d
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/opt/amazon/ebook/lib/json.jar\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /opt/amazon/ebook/lib/json.jar | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 644 patch/opt/amazon/ebook/lib/json.jar
  rm -f 053.json.jar.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/opt/amazon/ebook/lib/kxml2.jar\"" "patching file"

  mkdir -p patch/opt/amazon/ebook/lib/
  bspatch /opt/amazon/ebook/lib/kxml2.jar patch/opt/amazon/ebook/lib/kxml2.jar 054.kxml2.jar.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/opt/amazon/ebook/lib/kxml2.jar\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/opt/amazon/ebook/lib/kxml2.jar | awk '{ print $1; }'`
  _EXPECTED_MD5=e938231bf9b8d289ca783a2581f85786
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/opt/amazon/ebook/lib/kxml2.jar\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /opt/amazon/ebook/lib/kxml2.jar | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 644 patch/opt/amazon/ebook/lib/kxml2.jar
  rm -f 054.kxml2.jar.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/opt/amazon/ebook/lib/MobiCore-impl.jar\"" "patching file"

  mkdir -p patch/opt/amazon/ebook/lib/
  bspatch /opt/amazon/ebook/lib/MobiCore-impl.jar patch/opt/amazon/ebook/lib/MobiCore-impl.jar 055.MobiCore-impl.jar.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/opt/amazon/ebook/lib/MobiCore-impl.jar\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/opt/amazon/ebook/lib/MobiCore-impl.jar | awk '{ print $1; }'`
  _EXPECTED_MD5=820f16ab401ff95cea27de2f029969b9
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/opt/amazon/ebook/lib/MobiCore-impl.jar\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /opt/amazon/ebook/lib/MobiCore-impl.jar | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 644 patch/opt/amazon/ebook/lib/MobiCore-impl.jar
  rm -f 055.MobiCore-impl.jar.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/opt/amazon/ebook/lib/MobipocketCoreReader.jar\"" "patching file"

  mkdir -p patch/opt/amazon/ebook/lib/
  bspatch /opt/amazon/ebook/lib/MobipocketCoreReader.jar patch/opt/amazon/ebook/lib/MobipocketCoreReader.jar 056.MobipocketCoreReader.jar.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/opt/amazon/ebook/lib/MobipocketCoreReader.jar\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/opt/amazon/ebook/lib/MobipocketCoreReader.jar | awk '{ print $1; }'`
  _EXPECTED_MD5=f4b1657267996d775ec1774fa1d00b92
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/opt/amazon/ebook/lib/MobipocketCoreReader.jar\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /opt/amazon/ebook/lib/MobipocketCoreReader.jar | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 644 patch/opt/amazon/ebook/lib/MobipocketCoreReader.jar
  rm -f 056.MobipocketCoreReader.jar.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/opt/amazon/ebook/lib/PDFReader-impl.jar\"" "patching file"

  mkdir -p patch/opt/amazon/ebook/lib/
  bspatch /opt/amazon/ebook/lib/PDFReader-impl.jar patch/opt/amazon/ebook/lib/PDFReader-impl.jar 057.PDFReader-impl.jar.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/opt/amazon/ebook/lib/PDFReader-impl.jar\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/opt/amazon/ebook/lib/PDFReader-impl.jar | awk '{ print $1; }'`
  _EXPECTED_MD5=f1fa3746e2b9ebcd529a74c18f496019
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/opt/amazon/ebook/lib/PDFReader-impl.jar\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /opt/amazon/ebook/lib/PDFReader-impl.jar | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 644 patch/opt/amazon/ebook/lib/PDFReader-impl.jar
  rm -f 057.PDFReader-impl.jar.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/opt/amazon/ebook/lib/portability-impl.jar\"" "patching file"

  mkdir -p patch/opt/amazon/ebook/lib/
  bspatch /opt/amazon/ebook/lib/portability-impl.jar patch/opt/amazon/ebook/lib/portability-impl.jar 058.portability-impl.jar.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/opt/amazon/ebook/lib/portability-impl.jar\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/opt/amazon/ebook/lib/portability-impl.jar | awk '{ print $1; }'`
  _EXPECTED_MD5=0a2b6b2b4d1c99bdddba24f9b7a96456
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/opt/amazon/ebook/lib/portability-impl.jar\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /opt/amazon/ebook/lib/portability-impl.jar | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 644 patch/opt/amazon/ebook/lib/portability-impl.jar
  rm -f 058.portability-impl.jar.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/opt/amazon/ebook/lib/portability.jar\"" "patching file"

  mkdir -p patch/opt/amazon/ebook/lib/
  bspatch /opt/amazon/ebook/lib/portability.jar patch/opt/amazon/ebook/lib/portability.jar 059.portability.jar.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/opt/amazon/ebook/lib/portability.jar\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/opt/amazon/ebook/lib/portability.jar | awk '{ print $1; }'`
  _EXPECTED_MD5=197094d56d50efe0565d58ff437fb1fe
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/opt/amazon/ebook/lib/portability.jar\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /opt/amazon/ebook/lib/portability.jar | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 644 patch/opt/amazon/ebook/lib/portability.jar
  rm -f 059.portability.jar.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/opt/amazon/ebook/lib/ReaderSDK.jar\"" "patching file"

  mkdir -p patch/opt/amazon/ebook/lib/
  bspatch /opt/amazon/ebook/lib/ReaderSDK.jar patch/opt/amazon/ebook/lib/ReaderSDK.jar 060.ReaderSDK.jar.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/opt/amazon/ebook/lib/ReaderSDK.jar\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/opt/amazon/ebook/lib/ReaderSDK.jar | awk '{ print $1; }'`
  _EXPECTED_MD5=b30af25b112188d11a6dd41fe76b021d
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/opt/amazon/ebook/lib/ReaderSDK.jar\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /opt/amazon/ebook/lib/ReaderSDK.jar | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 644 patch/opt/amazon/ebook/lib/ReaderSDK.jar
  rm -f 060.ReaderSDK.jar.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/opt/amazon/ebook/lib/SearchSDK.jar\"" "patching file"

  mkdir -p patch/opt/amazon/ebook/lib/
  bspatch /opt/amazon/ebook/lib/SearchSDK.jar patch/opt/amazon/ebook/lib/SearchSDK.jar 061.SearchSDK.jar.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/opt/amazon/ebook/lib/SearchSDK.jar\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/opt/amazon/ebook/lib/SearchSDK.jar | awk '{ print $1; }'`
  _EXPECTED_MD5=f104131fa1aef44808a6b0026fb35222
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/opt/amazon/ebook/lib/SearchSDK.jar\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /opt/amazon/ebook/lib/SearchSDK.jar | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 644 patch/opt/amazon/ebook/lib/SearchSDK.jar
  rm -f 061.SearchSDK.jar.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/opt/amazon/ebook/lib/utilities.jar\"" "patching file"

  mkdir -p patch/opt/amazon/ebook/lib/
  bspatch /opt/amazon/ebook/lib/utilities.jar patch/opt/amazon/ebook/lib/utilities.jar 062.utilities.jar.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/opt/amazon/ebook/lib/utilities.jar\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/opt/amazon/ebook/lib/utilities.jar | awk '{ print $1; }'`
  _EXPECTED_MD5=bfc993645ef7ffd3734097f95be96c7e
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/opt/amazon/ebook/lib/utilities.jar\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /opt/amazon/ebook/lib/utilities.jar | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 644 patch/opt/amazon/ebook/lib/utilities.jar
  rm -f 062.utilities.jar.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/opt/amazon/ebook/lib/xyml.jar\"" "patching file"

  mkdir -p patch/opt/amazon/ebook/lib/
  bspatch /opt/amazon/ebook/lib/xyml.jar patch/opt/amazon/ebook/lib/xyml.jar 063.xyml.jar.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/opt/amazon/ebook/lib/xyml.jar\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/opt/amazon/ebook/lib/xyml.jar | awk '{ print $1; }'`
  _EXPECTED_MD5=ff93c8402e2de2b967fd5252de90b719
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/opt/amazon/ebook/lib/xyml.jar\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /opt/amazon/ebook/lib/xyml.jar | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 644 patch/opt/amazon/ebook/lib/xyml.jar
  rm -f 063.xyml.jar.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/opt/amazon/ebook/prefs/about.txt\"" "patching file"

  mkdir -p patch/opt/amazon/ebook/prefs/
  bspatch /opt/amazon/ebook/prefs/about.txt patch/opt/amazon/ebook/prefs/about.txt 064.about.txt.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/opt/amazon/ebook/prefs/about.txt\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/opt/amazon/ebook/prefs/about.txt | awk '{ print $1; }'`
  _EXPECTED_MD5=405af05386807f8e586fe20c7e5f716a
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/opt/amazon/ebook/prefs/about.txt\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /opt/amazon/ebook/prefs/about.txt | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 644 patch/opt/amazon/ebook/prefs/about.txt
  rm -f 064.about.txt.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/opt/amazon/ebook/prefs/com.amazon.ebook.booklet.reader/reader.pref.default\"" "patching file"

  mkdir -p patch/opt/amazon/ebook/prefs/com.amazon.ebook.booklet.reader/
  bspatch /opt/amazon/ebook/prefs/com.amazon.ebook.booklet.reader/reader.pref.default patch/opt/amazon/ebook/prefs/com.amazon.ebook.booklet.reader/reader.pref.default 065.reader.pref.default.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/opt/amazon/ebook/prefs/com.amazon.ebook.booklet.reader/reader.pref.default\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/opt/amazon/ebook/prefs/com.amazon.ebook.booklet.reader/reader.pref.default | awk '{ print $1; }'`
  _EXPECTED_MD5=6eb29467cb5158907f64f0f590fb0243
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/opt/amazon/ebook/prefs/com.amazon.ebook.booklet.reader/reader.pref.default\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /opt/amazon/ebook/prefs/com.amazon.ebook.booklet.reader/reader.pref.default | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 644 patch/opt/amazon/ebook/prefs/com.amazon.ebook.booklet.reader/reader.pref.default
  rm -f 065.reader.pref.default.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/opt/amazon/ebook/tests/FrameworkTests.runtest\"" "patching file"

  mkdir -p patch/opt/amazon/ebook/tests/
  bspatch /opt/amazon/ebook/tests/FrameworkTests.runtest patch/opt/amazon/ebook/tests/FrameworkTests.runtest 066.FrameworkTests.runtest.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/opt/amazon/ebook/tests/FrameworkTests.runtest\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/opt/amazon/ebook/tests/FrameworkTests.runtest | awk '{ print $1; }'`
  _EXPECTED_MD5=bd10d6a049fbb685550a03205587a2c9
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/opt/amazon/ebook/tests/FrameworkTests.runtest\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /opt/amazon/ebook/tests/FrameworkTests.runtest | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 644 patch/opt/amazon/ebook/tests/FrameworkTests.runtest
  rm -f 066.FrameworkTests.runtest.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/opt/amazon/kug/assets/KUG_9.azw\"" "patching file"

  mkdir -p patch/opt/amazon/kug/assets/
  bspatch /opt/amazon/kug/assets/KUG_9.azw patch/opt/amazon/kug/assets/KUG_9.azw 067.KUG_9.azw.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/opt/amazon/kug/assets/KUG_9.azw\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/opt/amazon/kug/assets/KUG_9.azw | awk '{ print $1; }'`
  _EXPECTED_MD5=ce16dc7f539228feebe87f0d429b853f
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/opt/amazon/kug/assets/KUG_9.azw\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /opt/amazon/kug/assets/KUG_9.azw | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 644 patch/opt/amazon/kug/assets/KUG_9.azw
  rm -f 067.KUG_9.azw.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/opt/amazon/kug/assets/KUG_9.mbp\"" "patching file"

  mkdir -p patch/opt/amazon/kug/assets/
  bspatch /opt/amazon/kug/assets/KUG_9.mbp patch/opt/amazon/kug/assets/KUG_9.mbp 068.KUG_9.mbp.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/opt/amazon/kug/assets/KUG_9.mbp\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/opt/amazon/kug/assets/KUG_9.mbp | awk '{ print $1; }'`
  _EXPECTED_MD5=73b63144b417851bcfa190e0b4e41fc2
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/opt/amazon/kug/assets/KUG_9.mbp\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /opt/amazon/kug/assets/KUG_9.mbp | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 644 patch/opt/amazon/kug/assets/KUG_9.mbp
  rm -f 068.KUG_9.mbp.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/opt/eink/scripts/diags\"" "patching file"

  mkdir -p patch/opt/eink/scripts/
  bspatch /opt/eink/scripts/diags patch/opt/eink/scripts/diags 069.diags.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/opt/eink/scripts/diags\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/opt/eink/scripts/diags | awk '{ print $1; }'`
  _EXPECTED_MD5=6d0a19a5b2ebb1cbb6d7c47afebe4c4c
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/opt/eink/scripts/diags\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /opt/eink/scripts/diags | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 755 patch/opt/eink/scripts/diags
  rm -f 069.diags.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/opt/eink/scripts/page_turn\"" "patching file"

  mkdir -p patch/opt/eink/scripts/
  bspatch /opt/eink/scripts/page_turn patch/opt/eink/scripts/page_turn 070.page_turn.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/opt/eink/scripts/page_turn\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/opt/eink/scripts/page_turn | awk '{ print $1; }'`
  _EXPECTED_MD5=e2946370228ed7a8080ce22d9a9975fd
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/opt/eink/scripts/page_turn\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /opt/eink/scripts/page_turn | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 755 patch/opt/eink/scripts/page_turn
  rm -f 070.page_turn.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/opt/eink/scripts/pvi_barcode_table.txt\"" "patching file"

  mkdir -p patch/opt/eink/scripts/
  bspatch /opt/eink/scripts/pvi_barcode_table.txt patch/opt/eink/scripts/pvi_barcode_table.txt 071.pvi_barcode_table.txt.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/opt/eink/scripts/pvi_barcode_table.txt\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/opt/eink/scripts/pvi_barcode_table.txt | awk '{ print $1; }'`
  _EXPECTED_MD5=6db91606d7e3346e691757b59c29ec01
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/opt/eink/scripts/pvi_barcode_table.txt\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /opt/eink/scripts/pvi_barcode_table.txt | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 644 patch/opt/eink/scripts/pvi_barcode_table.txt
  rm -f 071.pvi_barcode_table.txt.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/opt/eink/scripts/waveform_text_test\"" "patching file"

  mkdir -p patch/opt/eink/scripts/
  bspatch /opt/eink/scripts/waveform_text_test patch/opt/eink/scripts/waveform_text_test 072.waveform_text_test.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/opt/eink/scripts/waveform_text_test\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/opt/eink/scripts/waveform_text_test | awk '{ print $1; }'`
  _EXPECTED_MD5=246892273e14fd5b9dd9a2906d850b08
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/opt/eink/scripts/waveform_text_test\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /opt/eink/scripts/waveform_text_test | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 755 patch/opt/eink/scripts/waveform_text_test
  rm -f 072.waveform_text_test.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/opt/wan/firmware/mt-3/firmware.md5\"" "patching file"

  mkdir -p patch/opt/wan/firmware/mt-3/
  bspatch /opt/wan/firmware/mt-3/firmware.md5 patch/opt/wan/firmware/mt-3/firmware.md5 073.firmware.md5.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/opt/wan/firmware/mt-3/firmware.md5\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/opt/wan/firmware/mt-3/firmware.md5 | awk '{ print $1; }'`
  _EXPECTED_MD5=6739f07d4526e3068e4f379f114a1f4a
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/opt/wan/firmware/mt-3/firmware.md5\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /opt/wan/firmware/mt-3/firmware.md5 | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 644 patch/opt/wan/firmware/mt-3/firmware.md5
  rm -f 073.firmware.md5.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/opt/wan/firmware/mt-3/flash\"" "patching file"

  mkdir -p patch/opt/wan/firmware/mt-3/
  bspatch /opt/wan/firmware/mt-3/flash patch/opt/wan/firmware/mt-3/flash 074.flash.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/opt/wan/firmware/mt-3/flash\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/opt/wan/firmware/mt-3/flash | awk '{ print $1; }'`
  _EXPECTED_MD5=c235a9b1341dce3e070a6081b2c55258
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/opt/wan/firmware/mt-3/flash\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /opt/wan/firmware/mt-3/flash | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 755 patch/opt/wan/firmware/mt-3/flash
  rm -f 074.flash.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/usr/bin/audioServer\"" "patching file"

  mkdir -p patch/usr/bin/
  bspatch /usr/bin/audioServer patch/usr/bin/audioServer 075.audioServer.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/bin/audioServer\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/usr/bin/audioServer | awk '{ print $1; }'`
  _EXPECTED_MD5=e0500d389ab663a27bc37363d80c930b
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/bin/audioServer\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /usr/bin/audioServer | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 755 patch/usr/bin/audioServer
  rm -f 075.audioServer.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/usr/bin/lipc-daemon\"" "patching file"

  mkdir -p patch/usr/bin/
  bspatch /usr/bin/lipc-daemon patch/usr/bin/lipc-daemon 076.lipc-daemon.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/bin/lipc-daemon\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/usr/bin/lipc-daemon | awk '{ print $1; }'`
  _EXPECTED_MD5=0437e03911507d7b02ff31384ac9dca4
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/bin/lipc-daemon\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /usr/bin/lipc-daemon | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 755 patch/usr/bin/lipc-daemon
  rm -f 076.lipc-daemon.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/usr/bin/lipc-get-prop\"" "patching file"

  mkdir -p patch/usr/bin/
  bspatch /usr/bin/lipc-get-prop patch/usr/bin/lipc-get-prop 077.lipc-get-prop.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/bin/lipc-get-prop\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/usr/bin/lipc-get-prop | awk '{ print $1; }'`
  _EXPECTED_MD5=0f6f8eaf595c3b34260654cc2c2803e0
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/bin/lipc-get-prop\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /usr/bin/lipc-get-prop | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 755 patch/usr/bin/lipc-get-prop
  rm -f 077.lipc-get-prop.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/usr/bin/lipc-probe\"" "patching file"

  mkdir -p patch/usr/bin/
  bspatch /usr/bin/lipc-probe patch/usr/bin/lipc-probe 078.lipc-probe.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/bin/lipc-probe\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/usr/bin/lipc-probe | awk '{ print $1; }'`
  _EXPECTED_MD5=19dc133560498840749f305236575d15
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/bin/lipc-probe\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /usr/bin/lipc-probe | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 755 patch/usr/bin/lipc-probe
  rm -f 078.lipc-probe.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/usr/bin/lipc-send-event\"" "patching file"

  mkdir -p patch/usr/bin/
  bspatch /usr/bin/lipc-send-event patch/usr/bin/lipc-send-event 079.lipc-send-event.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/bin/lipc-send-event\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/usr/bin/lipc-send-event | awk '{ print $1; }'`
  _EXPECTED_MD5=86a4b44c4115f9d01cf929b5f09271e8
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/bin/lipc-send-event\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /usr/bin/lipc-send-event | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 755 patch/usr/bin/lipc-send-event
  rm -f 079.lipc-send-event.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/usr/bin/lipc-set-prop\"" "patching file"

  mkdir -p patch/usr/bin/
  bspatch /usr/bin/lipc-set-prop patch/usr/bin/lipc-set-prop 080.lipc-set-prop.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/bin/lipc-set-prop\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/usr/bin/lipc-set-prop | awk '{ print $1; }'`
  _EXPECTED_MD5=2b39664f8314ab37b1a40846df5d4e26
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/bin/lipc-set-prop\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /usr/bin/lipc-set-prop | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 755 patch/usr/bin/lipc-set-prop
  rm -f 080.lipc-set-prop.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/usr/bin/lipc-test\"" "patching file"

  mkdir -p patch/usr/bin/
  bspatch /usr/bin/lipc-test patch/usr/bin/lipc-test 081.lipc-test.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/bin/lipc-test\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/usr/bin/lipc-test | awk '{ print $1; }'`
  _EXPECTED_MD5=cc19ab92308cdba6146b50787a82f2a8
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/bin/lipc-test\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /usr/bin/lipc-test | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 755 patch/usr/bin/lipc-test
  rm -f 081.lipc-test.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/usr/bin/lipc-wait-event\"" "patching file"

  mkdir -p patch/usr/bin/
  bspatch /usr/bin/lipc-wait-event patch/usr/bin/lipc-wait-event 082.lipc-wait-event.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/bin/lipc-wait-event\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/usr/bin/lipc-wait-event | awk '{ print $1; }'`
  _EXPECTED_MD5=7fe8fa101c36d447122b48f67c487ce5
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/bin/lipc-wait-event\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /usr/bin/lipc-wait-event | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 755 patch/usr/bin/lipc-wait-event
  rm -f 082.lipc-wait-event.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/usr/bin/ntpdate\"" "patching file"

  mkdir -p patch/usr/bin/
  bspatch /usr/bin/ntpdate patch/usr/bin/ntpdate 083.ntpdate.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/bin/ntpdate\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/usr/bin/ntpdate | awk '{ print $1; }'`
  _EXPECTED_MD5=2fe088252b2356b3c1238f9ffa3872bd
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/bin/ntpdate\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /usr/bin/ntpdate | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 755 patch/usr/bin/ntpdate
  rm -f 083.ntpdate.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/usr/bin/pmond\"" "patching file"

  mkdir -p patch/usr/bin/
  bspatch /usr/bin/pmond patch/usr/bin/pmond 084.pmond.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/bin/pmond\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/usr/bin/pmond | awk '{ print $1; }'`
  _EXPECTED_MD5=5fa9f716e1d2de0dd0cc08f632b4bb1a
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/bin/pmond\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /usr/bin/pmond | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 755 patch/usr/bin/pmond
  rm -f 084.pmond.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/usr/bin/powerd\"" "patching file"

  mkdir -p patch/usr/bin/
  bspatch /usr/bin/powerd patch/usr/bin/powerd 085.powerd.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/bin/powerd\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/usr/bin/powerd | awk '{ print $1; }'`
  _EXPECTED_MD5=f3a29ada6c1afd855b4cae5ad6f29fbd
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/bin/powerd\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /usr/bin/powerd | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 755 patch/usr/bin/powerd
  rm -f 085.powerd.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/usr/bin/xd\"" "patching file"

  mkdir -p patch/usr/bin/
  bspatch /usr/bin/xd patch/usr/bin/xd 086.xd.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/bin/xd\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/usr/bin/xd | awk '{ print $1; }'`
  _EXPECTED_MD5=7cf56f716ddfa032777bab1f7b7eabd6
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/bin/xd\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /usr/bin/xd | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 755 patch/usr/bin/xd
  rm -f 086.xd.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/usr/java/bin/cvm\"" "patching file"

  mkdir -p patch/usr/java/bin/
  bspatch /usr/java/bin/cvm patch/usr/java/bin/cvm 087.cvm.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/java/bin/cvm\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/usr/java/bin/cvm | awk '{ print $1; }'`
  _EXPECTED_MD5=99532356e04de0fa399ebe5459a0b6ac
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/java/bin/cvm\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /usr/java/bin/cvm | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 755 patch/usr/java/bin/cvm
  rm -f 087.cvm.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/usr/java/lib/basis.jar\"" "patching file"

  mkdir -p patch/usr/java/lib/
  bspatch /usr/java/lib/basis.jar patch/usr/java/lib/basis.jar 088.basis.jar.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/java/lib/basis.jar\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/usr/java/lib/basis.jar | awk '{ print $1; }'`
  _EXPECTED_MD5=8a57b0aa9d2fa4b1a10a7a8893dd75f2
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/java/lib/basis.jar\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /usr/java/lib/basis.jar | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 644 patch/usr/java/lib/basis.jar
  rm -f 088.basis.jar.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/usr/java/lib/charsets.jar\"" "patching file"

  mkdir -p patch/usr/java/lib/
  bspatch /usr/java/lib/charsets.jar patch/usr/java/lib/charsets.jar 089.charsets.jar.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/java/lib/charsets.jar\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/usr/java/lib/charsets.jar | awk '{ print $1; }'`
  _EXPECTED_MD5=3af29c0f5f460502485dc016fffe9052
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/java/lib/charsets.jar\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /usr/java/lib/charsets.jar | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 644 patch/usr/java/lib/charsets.jar
  rm -f 089.charsets.jar.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/usr/java/lib/fonts/Caecilia_LT_65_Medium.ttf\"" "patching file"

  mkdir -p patch/usr/java/lib/fonts/
  bspatch /usr/java/lib/fonts/Caecilia_LT_65_Medium.ttf patch/usr/java/lib/fonts/Caecilia_LT_65_Medium.ttf 090.Caecilia_LT_65_Medium.ttf.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/java/lib/fonts/Caecilia_LT_65_Medium.ttf\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/usr/java/lib/fonts/Caecilia_LT_65_Medium.ttf | awk '{ print $1; }'`
  _EXPECTED_MD5=54dfdd02d944e530e121d12929d8d729
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/java/lib/fonts/Caecilia_LT_65_Medium.ttf\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /usr/java/lib/fonts/Caecilia_LT_65_Medium.ttf | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 755 patch/usr/java/lib/fonts/Caecilia_LT_65_Medium.ttf
  rm -f 090.Caecilia_LT_65_Medium.ttf.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/usr/java/lib/fonts/Caecilia_LT_66_Medium_Italic.ttf\"" "patching file"

  mkdir -p patch/usr/java/lib/fonts/
  bspatch /usr/java/lib/fonts/Caecilia_LT_66_Medium_Italic.ttf patch/usr/java/lib/fonts/Caecilia_LT_66_Medium_Italic.ttf 091.Caecilia_LT_66_Medium_Italic.ttf.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/java/lib/fonts/Caecilia_LT_66_Medium_Italic.ttf\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/usr/java/lib/fonts/Caecilia_LT_66_Medium_Italic.ttf | awk '{ print $1; }'`
  _EXPECTED_MD5=70933535834f76d6739a513a24ebf3ef
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/java/lib/fonts/Caecilia_LT_66_Medium_Italic.ttf\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /usr/java/lib/fonts/Caecilia_LT_66_Medium_Italic.ttf | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 755 patch/usr/java/lib/fonts/Caecilia_LT_66_Medium_Italic.ttf
  rm -f 091.Caecilia_LT_66_Medium_Italic.ttf.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/usr/java/lib/fonts/Caecilia_LT_75_Bold.ttf\"" "patching file"

  mkdir -p patch/usr/java/lib/fonts/
  bspatch /usr/java/lib/fonts/Caecilia_LT_75_Bold.ttf patch/usr/java/lib/fonts/Caecilia_LT_75_Bold.ttf 092.Caecilia_LT_75_Bold.ttf.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/java/lib/fonts/Caecilia_LT_75_Bold.ttf\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/usr/java/lib/fonts/Caecilia_LT_75_Bold.ttf | awk '{ print $1; }'`
  _EXPECTED_MD5=82160c36c1b010e647b18d42bf6294db
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/java/lib/fonts/Caecilia_LT_75_Bold.ttf\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /usr/java/lib/fonts/Caecilia_LT_75_Bold.ttf | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 755 patch/usr/java/lib/fonts/Caecilia_LT_75_Bold.ttf
  rm -f 092.Caecilia_LT_75_Bold.ttf.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/usr/java/lib/fonts/Caecilia_LT_76_Bold_Italic.ttf\"" "patching file"

  mkdir -p patch/usr/java/lib/fonts/
  bspatch /usr/java/lib/fonts/Caecilia_LT_76_Bold_Italic.ttf patch/usr/java/lib/fonts/Caecilia_LT_76_Bold_Italic.ttf 093.Caecilia_LT_76_Bold_Italic.ttf.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/java/lib/fonts/Caecilia_LT_76_Bold_Italic.ttf\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/usr/java/lib/fonts/Caecilia_LT_76_Bold_Italic.ttf | awk '{ print $1; }'`
  _EXPECTED_MD5=ada1de96acda43ebfc8cff6bb5204537
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/java/lib/fonts/Caecilia_LT_76_Bold_Italic.ttf\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /usr/java/lib/fonts/Caecilia_LT_76_Bold_Italic.ttf | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 755 patch/usr/java/lib/fonts/Caecilia_LT_76_Bold_Italic.ttf
  rm -f 093.Caecilia_LT_76_Bold_Italic.ttf.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/usr/java/lib/fonts/Kindle_Symbol.ttf\"" "patching file"

  mkdir -p patch/usr/java/lib/fonts/
  bspatch /usr/java/lib/fonts/Kindle_Symbol.ttf patch/usr/java/lib/fonts/Kindle_Symbol.ttf 094.Kindle_Symbol.ttf.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/java/lib/fonts/Kindle_Symbol.ttf\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/usr/java/lib/fonts/Kindle_Symbol.ttf | awk '{ print $1; }'`
  _EXPECTED_MD5=f466fe7206e8b241c5bc04099a845224
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/java/lib/fonts/Kindle_Symbol.ttf\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /usr/java/lib/fonts/Kindle_Symbol.ttf | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 755 patch/usr/java/lib/fonts/Kindle_Symbol.ttf
  rm -f 094.Kindle_Symbol.ttf.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/usr/java/lib/jaas.jar\"" "patching file"

  mkdir -p patch/usr/java/lib/
  bspatch /usr/java/lib/jaas.jar patch/usr/java/lib/jaas.jar 095.jaas.jar.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/java/lib/jaas.jar\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/usr/java/lib/jaas.jar | awk '{ print $1; }'`
  _EXPECTED_MD5=ec616230cc7dce50919b93acf29321f6
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/java/lib/jaas.jar\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /usr/java/lib/jaas.jar | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 644 patch/usr/java/lib/jaas.jar
  rm -f 095.jaas.jar.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/usr/java/lib/jsse-cdc.jar\"" "patching file"

  mkdir -p patch/usr/java/lib/
  bspatch /usr/java/lib/jsse-cdc.jar patch/usr/java/lib/jsse-cdc.jar 096.jsse-cdc.jar.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/java/lib/jsse-cdc.jar\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/usr/java/lib/jsse-cdc.jar | awk '{ print $1; }'`
  _EXPECTED_MD5=13059cce78ea30d800e35f03c43b35b5
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/java/lib/jsse-cdc.jar\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /usr/java/lib/jsse-cdc.jar | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 755 patch/usr/java/lib/jsse-cdc.jar
  rm -f 096.jsse-cdc.jar.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/usr/java/lib/libAdobePDFReader.so\"" "patching file"

  mkdir -p patch/usr/java/lib/
  bspatch /usr/java/lib/libAdobePDFReader.so patch/usr/java/lib/libAdobePDFReader.so 097.libAdobePDFReader.so.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/java/lib/libAdobePDFReader.so\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/usr/java/lib/libAdobePDFReader.so | awk '{ print $1; }'`
  _EXPECTED_MD5=fd5abefeae6f3fe3a2bcde19f956ce73
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/java/lib/libAdobePDFReader.so\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /usr/java/lib/libAdobePDFReader.so | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 755 patch/usr/java/lib/libAdobePDFReader.so
  rm -f 097.libAdobePDFReader.so.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/usr/java/lib/libawtjpeg.so\"" "patching file"

  mkdir -p patch/usr/java/lib/
  bspatch /usr/java/lib/libawtjpeg.so patch/usr/java/lib/libawtjpeg.so 098.libawtjpeg.so.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/java/lib/libawtjpeg.so\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/usr/java/lib/libawtjpeg.so | awk '{ print $1; }'`
  _EXPECTED_MD5=cc32aa8c98fea8671311790f4df6bada
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/java/lib/libawtjpeg.so\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /usr/java/lib/libawtjpeg.so | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 755 patch/usr/java/lib/libawtjpeg.so
  rm -f 098.libawtjpeg.so.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/usr/java/lib/libdbusjni.so\"" "patching file"

  mkdir -p patch/usr/java/lib/
  bspatch /usr/java/lib/libdbusjni.so patch/usr/java/lib/libdbusjni.so 099.libdbusjni.so.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/java/lib/libdbusjni.so\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/usr/java/lib/libdbusjni.so | awk '{ print $1; }'`
  _EXPECTED_MD5=4fce423c7445da978b54dde795ed1867
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/java/lib/libdbusjni.so\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /usr/java/lib/libdbusjni.so | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 755 patch/usr/java/lib/libdbusjni.so
  rm -f 099.libdbusjni.so.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/usr/java/lib/libjniaudible.so\"" "patching file"

  mkdir -p patch/usr/java/lib/
  bspatch /usr/java/lib/libjniaudible.so patch/usr/java/lib/libjniaudible.so 100.libjniaudible.so.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/java/lib/libjniaudible.so\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/usr/java/lib/libjniaudible.so | awk '{ print $1; }'`
  _EXPECTED_MD5=54da3d76096e8ce2e6a7b8f6542e2485
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/java/lib/libjniaudible.so\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /usr/java/lib/libjniaudible.so | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 755 patch/usr/java/lib/libjniaudible.so
  rm -f 100.libjniaudible.so.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/usr/java/lib/libjniframebuffer.so\"" "patching file"

  mkdir -p patch/usr/java/lib/
  bspatch /usr/java/lib/libjniframebuffer.so patch/usr/java/lib/libjniframebuffer.so 101.libjniframebuffer.so.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/java/lib/libjniframebuffer.so\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/usr/java/lib/libjniframebuffer.so | awk '{ print $1; }'`
  _EXPECTED_MD5=bbf08343dbc0a5eca27d28827752f185
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/java/lib/libjniframebuffer.so\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /usr/java/lib/libjniframebuffer.so | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 755 patch/usr/java/lib/libjniframebuffer.so
  rm -f 101.libjniframebuffer.so.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/usr/java/lib/libmicrowindowsawt.so\"" "patching file"

  mkdir -p patch/usr/java/lib/
  bspatch /usr/java/lib/libmicrowindowsawt.so patch/usr/java/lib/libmicrowindowsawt.so 102.libmicrowindowsawt.so.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/java/lib/libmicrowindowsawt.so\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/usr/java/lib/libmicrowindowsawt.so | awk '{ print $1; }'`
  _EXPECTED_MD5=c8e8c274cc16a9fedcb7a34dc0400aae
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/java/lib/libmicrowindowsawt.so\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /usr/java/lib/libmicrowindowsawt.so | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 755 patch/usr/java/lib/libmicrowindowsawt.so
  rm -f 102.libmicrowindowsawt.so.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/usr/java/lib/libnetfront.so\"" "patching file"

  mkdir -p patch/usr/java/lib/
  bspatch /usr/java/lib/libnetfront.so patch/usr/java/lib/libnetfront.so 103.libnetfront.so.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/java/lib/libnetfront.so\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/usr/java/lib/libnetfront.so | awk '{ print $1; }'`
  _EXPECTED_MD5=1e729019ba1da588300e843dda97a854
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/java/lib/libnetfront.so\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /usr/java/lib/libnetfront.so | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 644 patch/usr/java/lib/libnetfront.so
  rm -f 103.libnetfront.so.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/usr/java/lib/libPDFReader.so\"" "patching file"

  mkdir -p patch/usr/java/lib/
  bspatch /usr/java/lib/libPDFReader.so patch/usr/java/lib/libPDFReader.so 104.libPDFReader.so.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/java/lib/libPDFReader.so\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/usr/java/lib/libPDFReader.so | awk '{ print $1; }'`
  _EXPECTED_MD5=cc95b2a815172e3b2572a6b94a261328
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/java/lib/libPDFReader.so\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /usr/java/lib/libPDFReader.so | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 755 patch/usr/java/lib/libPDFReader.so
  rm -f 104.libPDFReader.so.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/usr/java/lib/libTopaz.so\"" "patching file"

  mkdir -p patch/usr/java/lib/
  bspatch /usr/java/lib/libTopaz.so patch/usr/java/lib/libTopaz.so 105.libTopaz.so.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/java/lib/libTopaz.so\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/usr/java/lib/libTopaz.so | awk '{ print $1; }'`
  _EXPECTED_MD5=75f1720af7aff23474bec3bfa504cfb2
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/java/lib/libTopaz.so\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /usr/java/lib/libTopaz.so | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 755 patch/usr/java/lib/libTopaz.so
  rm -f 105.libTopaz.so.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/usr/java/lib/localedata.jar\"" "patching file"

  mkdir -p patch/usr/java/lib/
  bspatch /usr/java/lib/localedata.jar patch/usr/java/lib/localedata.jar 106.localedata.jar.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/java/lib/localedata.jar\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/usr/java/lib/localedata.jar | awk '{ print $1; }'`
  _EXPECTED_MD5=b72585c6a3864e581d375d03a989239e
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/java/lib/localedata.jar\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /usr/java/lib/localedata.jar | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 644 patch/usr/java/lib/localedata.jar
  rm -f 106.localedata.jar.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/usr/java/lib/security/cacerts\"" "patching file"

  mkdir -p patch/usr/java/lib/security/
  bspatch /usr/java/lib/security/cacerts patch/usr/java/lib/security/cacerts 107.cacerts.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/java/lib/security/cacerts\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/usr/java/lib/security/cacerts | awk '{ print $1; }'`
  _EXPECTED_MD5=96705ab4875dd8584d8f4e7a5f8857bd
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/java/lib/security/cacerts\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /usr/java/lib/security/cacerts | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 755 patch/usr/java/lib/security/cacerts
  rm -f 107.cacerts.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/usr/java/lib/zi/Asia/Novosibirsk\"" "patching file"

  mkdir -p patch/usr/java/lib/zi/Asia/
  bspatch /usr/java/lib/zi/Asia/Novosibirsk patch/usr/java/lib/zi/Asia/Novosibirsk 108.Novosibirsk.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/java/lib/zi/Asia/Novosibirsk\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/usr/java/lib/zi/Asia/Novosibirsk | awk '{ print $1; }'`
  _EXPECTED_MD5=856b93152ad0513b1b85fed0fc94db3c
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/java/lib/zi/Asia/Novosibirsk\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /usr/java/lib/zi/Asia/Novosibirsk | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 644 patch/usr/java/lib/zi/Asia/Novosibirsk
  rm -f 108.Novosibirsk.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/usr/java/lib/zi/ZoneInfoMappings\"" "patching file"

  mkdir -p patch/usr/java/lib/zi/
  bspatch /usr/java/lib/zi/ZoneInfoMappings patch/usr/java/lib/zi/ZoneInfoMappings 109.ZoneInfoMappings.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/java/lib/zi/ZoneInfoMappings\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/usr/java/lib/zi/ZoneInfoMappings | awk '{ print $1; }'`
  _EXPECTED_MD5=34dafe125d89a6d9522cac7479fd9cb5
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/java/lib/zi/ZoneInfoMappings\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /usr/java/lib/zi/ZoneInfoMappings | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 644 patch/usr/java/lib/zi/ZoneInfoMappings
  rm -f 109.ZoneInfoMappings.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/usr/lib/gstreamer-0.10/libgstaudiblesrc.so.0.1\"" "patching file"

  mkdir -p patch/usr/lib/gstreamer-0.10/
  bspatch /usr/lib/gstreamer-0.10/libgstaudiblesrc.so.0.1 patch/usr/lib/gstreamer-0.10/libgstaudiblesrc.so.0.1 110.libgstaudiblesrc.so.0.1.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/lib/gstreamer-0.10/libgstaudiblesrc.so.0.1\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/usr/lib/gstreamer-0.10/libgstaudiblesrc.so.0.1 | awk '{ print $1; }'`
  _EXPECTED_MD5=bc8ab080421809c7295c1fb87cf6318e
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/lib/gstreamer-0.10/libgstaudiblesrc.so.0.1\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /usr/lib/gstreamer-0.10/libgstaudiblesrc.so.0.1 | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 755 patch/usr/lib/gstreamer-0.10/libgstaudiblesrc.so.0.1
  rm -f 110.libgstaudiblesrc.so.0.1.patch

  update_percent_complete 1

 if [ -f /usr/lib/libdtp_module.so.0.1 ]; then
  logmsg "I" "patch" "patchinfo=\"/usr/lib/libdtp_module.so.0.1\"" "patching file"

  mkdir -p patch/usr/lib/
  bspatch /usr/lib/libdtp_module.so.0.1 patch/usr/lib/libdtp_module.so.0.1 111.libdtp_module.so.0.1.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/lib/libdtp_module.so.0.1\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/usr/lib/libdtp_module.so.0.1 | awk '{ print $1; }'`
  _EXPECTED_MD5=52cf7b1c0cebe2d8efa7bb4fa77beb95
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/lib/libdtp_module.so.0.1\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /usr/lib/libdtp_module.so.0.1 | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 755 patch/usr/lib/libdtp_module.so.0.1
  rm -f 111.libdtp_module.so.0.1.patch

  update_percent_complete 1
 fi

  logmsg "I" "patch" "patchinfo=\"/usr/lib/liblipc.so.0.1\"" "patching file"

  mkdir -p patch/usr/lib/
  bspatch /usr/lib/liblipc.so.0.1 patch/usr/lib/liblipc.so.0.1 112.liblipc.so.0.1.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/lib/liblipc.so.0.1\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/usr/lib/liblipc.so.0.1 | awk '{ print $1; }'`
  _EXPECTED_MD5=b11d719408052d1a53f3bf5253ab2418
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/lib/liblipc.so.0.1\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /usr/lib/liblipc.so.0.1 | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 755 patch/usr/lib/liblipc.so.0.1
  rm -f 112.liblipc.so.0.1.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/usr/lib/libtag_c.so.0.0.0\"" "patching file"

  mkdir -p patch/usr/lib/
  bspatch /usr/lib/libtag_c.so.0.0.0 patch/usr/lib/libtag_c.so.0.0.0 113.libtag_c.so.0.0.0.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/lib/libtag_c.so.0.0.0\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/usr/lib/libtag_c.so.0.0.0 | awk '{ print $1; }'`
  _EXPECTED_MD5=98e79abe1ca68811ff31a2b1e2adda14
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/lib/libtag_c.so.0.0.0\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /usr/lib/libtag_c.so.0.0.0 | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 755 patch/usr/lib/libtag_c.so.0.0.0
  rm -f 113.libtag_c.so.0.0.0.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/usr/lib/libtag.so.1.5.0\"" "patching file"

  mkdir -p patch/usr/lib/
  bspatch /usr/lib/libtag.so.1.5.0 patch/usr/lib/libtag.so.1.5.0 114.libtag.so.1.5.0.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/lib/libtag.so.1.5.0\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/usr/lib/libtag.so.1.5.0 | awk '{ print $1; }'`
  _EXPECTED_MD5=af1f8874d729f2a455cf3cdf57c16d02
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/lib/libtag.so.1.5.0\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /usr/lib/libtag.so.1.5.0 | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 755 patch/usr/lib/libtag.so.1.5.0
  rm -f 114.libtag.so.1.5.0.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/usr/sbin/eips\"" "patching file"

  mkdir -p patch/usr/sbin/
  bspatch /usr/sbin/eips patch/usr/sbin/eips 115.eips.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/sbin/eips\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/usr/sbin/eips | awk '{ print $1; }'`
  _EXPECTED_MD5=f274a88e2f1496707149e690ba4cefa9
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/sbin/eips\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /usr/sbin/eips | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 755 patch/usr/sbin/eips
  rm -f 115.eips.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/usr/sbin/eu\"" "patching file"

  mkdir -p patch/usr/sbin/
  bspatch /usr/sbin/eu patch/usr/sbin/eu 116.eu.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/sbin/eu\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/usr/sbin/eu | awk '{ print $1; }'`
  _EXPECTED_MD5=1f08891e61363cc2ff35803fb0dd7d94
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/sbin/eu\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /usr/sbin/eu | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 755 patch/usr/sbin/eu
  rm -f 116.eu.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/usr/sbin/factory_reset\"" "patching file"

  mkdir -p patch/usr/sbin/
  bspatch /usr/sbin/factory_reset patch/usr/sbin/factory_reset 117.factory_reset.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/sbin/factory_reset\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/usr/sbin/factory_reset | awk '{ print $1; }'`
  _EXPECTED_MD5=cc8538a5abf4d04dec3e8a706b488889
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/sbin/factory_reset\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /usr/sbin/factory_reset | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 755 patch/usr/sbin/factory_reset
  rm -f 117.factory_reset.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/usr/sbin/idme\"" "patching file"

  mkdir -p patch/usr/sbin/
  bspatch /usr/sbin/idme patch/usr/sbin/idme 118.idme.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/sbin/idme\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/usr/sbin/idme | awk '{ print $1; }'`
  _EXPECTED_MD5=e22b1d436208a044ee00e6536b4a1d9c
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/sbin/idme\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /usr/sbin/idme | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 755 patch/usr/sbin/idme
  rm -f 118.idme.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/usr/sbin/idme_functions\"" "patching file"

  mkdir -p patch/usr/sbin/
  bspatch /usr/sbin/idme_functions patch/usr/sbin/idme_functions 119.idme_functions.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/sbin/idme_functions\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/usr/sbin/idme_functions | awk '{ print $1; }'`
  _EXPECTED_MD5=25e19ae6fec185681e6e1a6b018358eb
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/sbin/idme_functions\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /usr/sbin/idme_functions | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 644 patch/usr/sbin/idme_functions
  rm -f 119.idme_functions.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/usr/sbin/mcsd\"" "patching file"

  mkdir -p patch/usr/sbin/
  bspatch /usr/sbin/mcsd patch/usr/sbin/mcsd 120.mcsd.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/sbin/mcsd\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/usr/sbin/mcsd | awk '{ print $1; }'`
  _EXPECTED_MD5=7518134bca83b5cb59d0ee3a579eafba
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/sbin/mcsd\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /usr/sbin/mcsd | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 755 patch/usr/sbin/mcsd
  rm -f 120.mcsd.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/usr/sbin/netwatchd\"" "patching file"

  mkdir -p patch/usr/sbin/
  bspatch /usr/sbin/netwatchd patch/usr/sbin/netwatchd 121.netwatchd.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/sbin/netwatchd\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/usr/sbin/netwatchd | awk '{ print $1; }'`
  _EXPECTED_MD5=0ebcab11885782816bf81a61685ad31b
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/sbin/netwatchd\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /usr/sbin/netwatchd | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 755 patch/usr/sbin/netwatchd
  rm -f 121.netwatchd.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/usr/sbin/otaup\"" "patching file"

  mkdir -p patch/usr/sbin/
  bspatch /usr/sbin/otaup patch/usr/sbin/otaup 122.otaup.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/sbin/otaup\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/usr/sbin/otaup | awk '{ print $1; }'`
  _EXPECTED_MD5=3fd71254bcfbefd72240f57a39a88d9d
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/sbin/otaup\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /usr/sbin/otaup | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 755 patch/usr/sbin/otaup
  rm -f 122.otaup.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/usr/sbin/pppd\"" "patching file"

  mkdir -p patch/usr/sbin/
  bspatch /usr/sbin/pppd patch/usr/sbin/pppd 123.pppd.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/sbin/pppd\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/usr/sbin/pppd | awk '{ print $1; }'`
  _EXPECTED_MD5=edfb74758add4a05432bec67e5ffd3d8
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/sbin/pppd\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /usr/sbin/pppd | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 755 patch/usr/sbin/pppd
  rm -f 123.pppd.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/usr/sbin/retryd\"" "patching file"

  mkdir -p patch/usr/sbin/
  bspatch /usr/sbin/retryd patch/usr/sbin/retryd 124.retryd.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/sbin/retryd\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/usr/sbin/retryd | awk '{ print $1; }'`
  _EXPECTED_MD5=39d7a4814e99ca5b9fd1343eb32d872b
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/sbin/retryd\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /usr/sbin/retryd | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 755 patch/usr/sbin/retryd
  rm -f 124.retryd.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/usr/sbin/volumd\"" "patching file"

  mkdir -p patch/usr/sbin/
  bspatch /usr/sbin/volumd patch/usr/sbin/volumd 125.volumd.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/sbin/volumd\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/usr/sbin/volumd | awk '{ print $1; }'`
  _EXPECTED_MD5=086c1f65816e3f0a2ce659e921480e6d
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/sbin/volumd\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /usr/sbin/volumd | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 755 patch/usr/sbin/volumd
  rm -f 125.volumd.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/usr/sbin/wancontrol\"" "patching file"

  mkdir -p patch/usr/sbin/
  bspatch /usr/sbin/wancontrol patch/usr/sbin/wancontrol 126.wancontrol.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/sbin/wancontrol\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/usr/sbin/wancontrol | awk '{ print $1; }'`
  _EXPECTED_MD5=0e948a95c6a4f14607e340c0a98bf6eb
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/sbin/wancontrol\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /usr/sbin/wancontrol | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 755 patch/usr/sbin/wancontrol
  rm -f 126.wancontrol.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/usr/sbin/wand\"" "patching file"

  mkdir -p patch/usr/sbin/
  bspatch /usr/sbin/wand patch/usr/sbin/wand 127.wand.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/sbin/wand\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/usr/sbin/wand | awk '{ print $1; }'`
  _EXPECTED_MD5=7b7f57d92251a53d6d6a7b636367f395
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/sbin/wand\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /usr/sbin/wand | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 755 patch/usr/sbin/wand
  rm -f 127.wand.patch

  update_percent_complete 1

  logmsg "I" "patch" "patchinfo=\"/usr/sbin/waninfo\"" "patching file"

  mkdir -p patch/usr/sbin/
  bspatch /usr/sbin/waninfo patch/usr/sbin/waninfo 128.waninfo.patch
  if [ $? -ne 0 ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/sbin/waninfo\"" "patch failure"
    return 1
  fi

  _PATCH_MD5=`md5sum patch/usr/sbin/waninfo | awk '{ print $1; }'`
  _EXPECTED_MD5=7379fd6ed6294cb38376c785c7e76c76
  if [ ! "${_PATCH_MD5}" = "${_EXPECTED_MD5}" ]; then
    logmsg "C" "patch" "patchinfo=\"/usr/sbin/waninfo\"" "checksum failure"
    
    _CURRENT_MD5=`md5sum /usr/sbin/waninfo | awk '{ print $1; }'`
    logmsg "I" "patch" "current_md5=${_CURRENT_MD5},expected_md5=${_EXPECTED_MD5},patch_md5=${_PATCH_MD5}" "checksum verify"

    return 1
  fi

  chmod 755 patch/usr/sbin/waninfo
  rm -f 128.waninfo.patch

  update_percent_complete 1

  logmsg "I" "update" "updating device with patches"

  cd patch
  tar cf - . | (cd / ; tar xvf -)
  _RET=$?
  if [ ${_RET} -ne 0 ]; then
    logmsg "C" "update0" "code=${_RET}" "failure updating device with patches"
    return 1
  fi
  cd - >/dev/null
  rm -rf patch

  logmsg "I" "update1" "patchinfo=\"/etc/audio/amazon.bdc\"" "removing file"
  rm -f /etc/audio/amazon.bdc
  logmsg "I" "update1" "patchinfo=\"/etc/init.d/watchdogd\"" "removing file"
  rm -f /etc/init.d/watchdogd
  logmsg "I" "update1" "patchinfo=\"/etc/ppp/chat/att-connect\"" "removing file"
  rm -f /etc/ppp/chat/att-connect
  logmsg "I" "update1" "patchinfo=\"/etc/ppp/chat/att-disconnect\"" "removing file"
  rm -f /etc/ppp/chat/att-disconnect
  logmsg "I" "update1" "patchinfo=\"/etc/ppp/chat/sprint-connect\"" "removing file"
  rm -f /etc/ppp/chat/sprint-connect
  logmsg "I" "update1" "patchinfo=\"/etc/ppp/chat/sprint-disconnect\"" "removing file"
  rm -f /etc/ppp/chat/sprint-disconnect
  logmsg "I" "update1" "patchinfo=\"/etc/sysconfig/netwatchd\"" "removing file"
  rm -f /etc/sysconfig/netwatchd
  logmsg "I" "update1" "patchinfo=\"/opt/amazon/ebook/booklet/Journal-update.jar\"" "removing file"
  rm -f /opt/amazon/ebook/booklet/Journal-update.jar
  logmsg "I" "update1" "patchinfo=\"/opt/amazon/ebook/img/ui/Butn_Cancel1.gif\"" "removing file"
  rm -f /opt/amazon/ebook/img/ui/Butn_Cancel1.gif
  logmsg "I" "update1" "patchinfo=\"/opt/amazon/ebook/img/ui/Butn_Cancel2.gif\"" "removing file"
  rm -f /opt/amazon/ebook/img/ui/Butn_Cancel2.gif
  logmsg "I" "update1" "patchinfo=\"/opt/amazon/ebook/img/ui/Butn_Cancel3.gif\"" "removing file"
  rm -f /opt/amazon/ebook/img/ui/Butn_Cancel3.gif
  logmsg "I" "update1" "patchinfo=\"/opt/amazon/ebook/img/ui/Butn_Clear1.gif\"" "removing file"
  rm -f /opt/amazon/ebook/img/ui/Butn_Clear1.gif
  logmsg "I" "update1" "patchinfo=\"/opt/amazon/ebook/img/ui/Butn_Clear2.gif\"" "removing file"
  rm -f /opt/amazon/ebook/img/ui/Butn_Clear2.gif
  logmsg "I" "update1" "patchinfo=\"/opt/amazon/ebook/img/ui/Butn_Clear3.gif\"" "removing file"
  rm -f /opt/amazon/ebook/img/ui/Butn_Clear3.gif
  logmsg "I" "update1" "patchinfo=\"/opt/amazon/ebook/img/ui/Butn_Delete1.gif\"" "removing file"
  rm -f /opt/amazon/ebook/img/ui/Butn_Delete1.gif
  logmsg "I" "update1" "patchinfo=\"/opt/amazon/ebook/img/ui/Butn_Delete2.gif\"" "removing file"
  rm -f /opt/amazon/ebook/img/ui/Butn_Delete2.gif
  logmsg "I" "update1" "patchinfo=\"/opt/amazon/ebook/img/ui/Butn_Delete3.gif\"" "removing file"
  rm -f /opt/amazon/ebook/img/ui/Butn_Delete3.gif
  logmsg "I" "update1" "patchinfo=\"/opt/amazon/ebook/img/ui/Butn_Delete.gif\"" "removing file"
  rm -f /opt/amazon/ebook/img/ui/Butn_Delete.gif
  logmsg "I" "update1" "patchinfo=\"/opt/amazon/ebook/img/ui/Butn_SaveNote1.gif\"" "removing file"
  rm -f /opt/amazon/ebook/img/ui/Butn_SaveNote1.gif
  logmsg "I" "update1" "patchinfo=\"/opt/amazon/ebook/img/ui/Butn_SaveNote2.gif\"" "removing file"
  rm -f /opt/amazon/ebook/img/ui/Butn_SaveNote2.gif
  logmsg "I" "update1" "patchinfo=\"/opt/amazon/ebook/img/ui/checkMark.gif\"" "removing file"
  rm -f /opt/amazon/ebook/img/ui/checkMark.gif
  logmsg "I" "update1" "patchinfo=\"/opt/amazon/ebook/img/ui/Reader_Dialog_HelpText.gif\"" "removing file"
  rm -f /opt/amazon/ebook/img/ui/Reader_Dialog_HelpText.gif
  logmsg "I" "update1" "patchinfo=\"/opt/amazon/ebook/img/ui/Reader_Dialog_ShortDef.gif\"" "removing file"
  rm -f /opt/amazon/ebook/img/ui/Reader_Dialog_ShortDef.gif
  logmsg "I" "update1" "patchinfo=\"/opt/amazon/ebook/img/ui/usbConnect_600x800.gif\"" "removing file"
  rm -f /opt/amazon/ebook/img/ui/usbConnect_600x800.gif
  logmsg "I" "update1" "patchinfo=\"/opt/amazon/ebook/img/ui/usbConnect_824x1200.gif\"" "removing file"
  rm -f /opt/amazon/ebook/img/ui/usbConnect_824x1200.gif
  logmsg "I" "update1" "patchinfo=\"/opt/eink/images/110A_A037_97_WE1814_BTC.wbf\"" "removing file"
  rm -f /opt/eink/images/110A_A037_97_WE1814_BTC.wbf
  logmsg "I" "update1" "patchinfo=\"/opt/eink/images/V110_B006_97_WE1708_BTC.wbf\"" "removing file"
  rm -f /opt/eink/images/V110_B006_97_WE1708_BTC.wbf
  logmsg "I" "update1" "patchinfo=\"/usr/bin/pipelog\"" "removing file"
  rm -f /usr/bin/pipelog
  logmsg "I" "update1" "patchinfo=\"/usr/bin/tts_test\"" "removing file"
  rm -f /usr/bin/tts_test
  logmsg "I" "update1" "patchinfo=\"/usr/java/lib/zi/Asia/Calcutta\"" "removing file"
  rm -f /usr/java/lib/zi/Asia/Calcutta
  logmsg "I" "update1" "patchinfo=\"/usr/lib/gstreamer-0.10/libgstttssrc.so.0.1\"" "removing file"
  rm -f /usr/lib/gstreamer-0.10/libgstttssrc.so.0.1
  logmsg "I" "update1" "patchinfo=\"/usr/lib/libttsDaemon.so.0.1\"" "removing file"
  rm -f /usr/lib/libttsDaemon.so.0.1
  logmsg "I" "update1" "patchinfo=\"/usr/sbin/watchdogd\"" "removing file"
  rm -f /usr/sbin/watchdogd

  logmsg "I" "update" "updating device with symlink deletes"

  rm -f /usr/lib/gstreamer-0.10/libgstttssrc.so
  rm -f /usr/lib/gstreamer-0.10/libgstttssrc.so.0
  rm -f /usr/lib/libttsDaemon.so
  rm -f /usr/lib/libttsDaemon.so.0

  logmsg "I" "update" "updating device with file additions"

  cd base2
  tar cf - . | (cd / ; tar xvf -)
  _RET=$?
  if [ ${_RET} -ne 0 ]; then
    logmsg "C" "update0" "code=${_RET}" "failure updating device with file additions"
    return 1
  fi
  cd - >/dev/null
  rm -rf base2


  logmsg "I" "update" "updating device with symlink changes"

  ln -s /var/local/system/tz /etc/localtime
  ln -s /etc/init.d/ttsd /etc/rc0.d/K17ttsd
  ln -s /etc/init.d/ttsd /etc/rc1.d/K17ttsd
  ln -s /etc/init.d/ttsd /etc/rc2.d/K17ttsd
  ln -s /etc/init.d/ttsd /etc/rc3.d/K17ttsd
  ln -s /etc/init.d/ttsd /etc/rc4.d/S17ttsd
  ln -s /etc/init.d/guidinit /etc/rc5.d/S02guidinit
  ln -s /etc/init.d/ttsd /etc/rc5.d/S87ttsd
  ln -s /etc/init.d/ttsd /etc/rc6.d/K17ttsd
  ln -s /usr/lib/tts/speech/components/common/combrk.so /usr/lib/combrk.so
  ln -s /usr/lib/tts/speech/components/common/comrsrc.so /usr/lib/comrsrc.so
  ln -s /usr/lib/libdtp_module.so.0.1 /usr/lib/libwan_module.0403.so
  ln -s /usr/lib/tts/speech/components/common/rssoloapi.so /usr/lib/rssoloapi.so

    logmsg "I" "update" "updating device with new rootfs_md5_list"

    tar zxvf rootfs_md5_list.tar.gz && rm -f rootfs_md5_list.tar.gz
    cp rootfs_md5_list /test/diags/factory/ && rm -f rootfs_md5_list

  return 0
}

_TMPFS_SIZE=`df -h /var | awk '/mnt/ { print $2 }' | sed 's/\.[0-9]M//g'`
if [ -n "${_TMPFS_SIZE}" ]; then
  if [ ${_TMPFS_SIZE} -lt 32 ]; then
    _TMPFS_SIZE=32
  fi
else
  _TMPFS_SIZE=32
fi

mount -o remount,size=64M /var

[ -f update-patches.tar.gz ] && tar xzvf update-patches.tar.gz && rm -f update-patches.tar.gz
[ -f update-adds.tar.gz ] && tar xzvf update-adds.tar.gz && rm -f update-adds.tar.gz

perform_patches
_RET=$?

mount -o remount,size=${_TMPFS_SIZE}M /var

if [ ${_RET} -ne 0 ]; then
  return ${_RET}
fi


# ---------- kernel update ----------

flash_kernel()
{
    _KERNEL_PARTITION=$1

    logmsg "I" "fl_kl1" "partition=${_KERNEL_PARTITION}" "flashing kernel"

    BLOCK_SIZE=131072

    flash_unlock /dev/mtd/${_KERNEL_PARTITION}

    _RET=1

    _FL_RETRY_PAUSE=2

    _FL_COUNT=0
    _FL_RETRIES=3

    while [ ${_FL_COUNT} -lt ${_FL_RETRIES} ]; do
        echo "flashing via \"dd if=uImage of=/dev/mtdblock/${_KERNEL_PARTITION}\""

        dd if=uImage of=/dev/mtdblock/${_KERNEL_PARTITION} bs=${BLOCK_SIZE}
        _RES=$?

        sleep 1
        sync

        echo "flash status ${_RES}"

        if [ ${_RES} -eq 0 ]; then
            _CHECK_MD5=`dd if=/dev/mtdblock/${_KERNEL_PARTITION} bs=${BLOCK_SIZE} count=15 | md5sum | awk '{ print $1 }'`

            logmsg "I" "fl_kl2" "source_md5=66d67d7d75f1451fc0f283dc46f6b7ee,flash_md5=${_CHECK_MD5}" "flash verify"

            if [ "66d67d7d75f1451fc0f283dc46f6b7ee" = "${_CHECK_MD5}" ]; then

                _RET=0

                _FL_COUNT=${_FL_RETRIES}

            else
                sleep ${_FL_RETRY_PAUSE}

            fi

        else
            sleep ${_FL_RETRY_PAUSE}

        fi

        _FL_COUNT=`expr ${_FL_COUNT} + 1`

    done

    update_percent_complete_unscaled 1

    logmsg "I" "fl_kl3" "status=${_RET}" "kernel update complete"

    return ${_RET}
}


perform_kernel_update()
{
    tar xzvf update-kernel.tar.gz && rm -f update-kernel.tar.gz

    logmsg "I" "fl_kl" "verifying kernel image"

    _CHECK_MD5=`md5sum uImage | awk '{ print $1 }'`
    if ! [ "66d67d7d75f1451fc0f283dc46f6b7ee" = "${_CHECK_MD5}" ]; then
        logmsg "C" "fl_kl0" "source_md5=66d67d7d75f1451fc0f283dc46f6b7ee,bundle_md5=${_CHECK_MD5}" "kernel checksum failure"

        return 1
    fi

    . ./uImage.partitions

    flash_kernel ${KERNEL_PARTITION_1}
    _RET=$?

    if [ ${_RET} -ne 0 ]; then
        return ${_RET}
    fi

    local _MTD_2_SIZE=`awk '/Kernel2/ { print $2 }' /proc/mtd`
    if [ -n "${_MTD_2_SIZE}" ]; then
        if ! [ "${_MTD_2_SIZE}" = "00000000" ]; then
            flash_kernel ${KERNEL_PARTITION_2}
            _RET=$?
        fi
    fi

    rm -f ./uImage*

    return ${_RET}
}

perform_kernel_update
_RET=$?

if [ ${_RET} -ne 0 ]; then
  return ${_RET}
fi


logmsg "I" "done" "id=`basename $0 .ffs`,version=`cat /etc/version.txt | awk /System/\ '{ print $4 }'`" "update complete"

update_progressbar 100

return 0

