/* gtkclock.c */

#include <gtk/gtk.h>
#include <unistd.h>
#include <time.h>
#include <string.h>

#define TAM 80

struct data
{
   gchar buffer[TAM];
   gchar tip[TAM];
   gchar *format;
   GtkWidget *window;
   GtkWidget *label;
   GtkTooltips *tooltips;
};

static void
get_time(gchar *buffer1, gchar *buffer2, gchar *format)
{
   time_t now;
   struct tm * t;

   time(&now);
   t = localtime(&now);
   
   strftime(buffer1, TAM, format, t);
   strftime(buffer2, TAM, "%c", t);
}

static int
clock_update(gpointer dc)
{
   struct data * d = (struct data *) dc;
   get_time(d->buffer, d->tip, d->format);
   gtk_label_set_text((GtkLabel *) d->label, d->buffer);
   gtk_tooltips_set_tip(d->tooltips, d->window, d->tip, NULL);
   return TRUE;
}

static gboolean
key_pressed(GtkWidget *widget, GdkEventKey *event, gpointer user_data)
{
   if ( event->keyval == 'q' || event->keyval == 'Q' )
      gtk_object_destroy((GtkObject *) widget);
}

static void
destroy(GtkWidget *widget, gpointer data)
{
   gtk_main_quit();
}

int
main(int argc, char *argv[])
{
   struct data d;
   int i;
   gchar *font = NULL;
   gchar *fg = NULL;
   gchar *bg = NULL;
   GtkRcStyle *rc_style;

   GOptionEntry entries[] = 
      {
	 { "font", 'F', 0, G_OPTION_ARG_STRING, &font, "font (fontconfig) to be used", "FN" },
	 { "foreground", 'f', 0, G_OPTION_ARG_STRING, &fg, "foreground color", "FG" },
	 { "background", 'b', 0, G_OPTION_ARG_STRING, &bg, "background color", "BG" },
	 { "format", 't', 0, G_OPTION_ARG_STRING, &d.format, "time format (strftime format string)", "FORMAT" },
	 { NULL }
      };

   d.format = NULL;

   gtk_set_locale();

   gtk_init_with_args(&argc, &argv,
		      "- a simple digital clock",
		      entries,
		      NULL, NULL);

   d.window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
   /*d.window = gtk_window_new(GTK_WINDOW_DIALOG);*/
   /*d.window = gtk_window_new(GTK_WINDOW_POPUP);*/
   	/*gtk_window_set_type_hint(d.window, GDK_WINDOW_TYPE_HINT_DIALOG);*/
	gtk_window_set_type_hint(GTK_WINDOW(d.window), GDK_WINDOW_TYPE_HINT_DIALOG);
	/*gtk_window_set_title(GTK_WINDOW(d.window), "clock");*/
	gtk_window_set_decorated(GTK_WINDOW(d.window), FALSE);
	/*gtk_window_set_position(GTK_WINDOW(d.window), GTK_WIN_POS_CENTER);*/
	/*gtk_window_set_position(GTK_WINDOW(d.window), GTK_WIN_POS_MOUSE);*/
	/*gtk_window_set_position(GTK_WINDOW(d.window), GTK_WIN_POS_NONE);*/
	/*GDK_GRAVITY_NORTH_WEST* is default value*/
    /* iLiad's screen size: 768x1024*/
	/* width of hh:mm clock is ~ 60 pixels*/
	gtk_window_move(GTK_WINDOW(d.window), 700, 0); /*top right*/
	/*gtk_window_move(GTK_WINDOW(d.window), 1, 0); /*top left*/
	/*gtk_window_set_gravity(GTK_WINDOW(d.window), GDK_GRAVITY_SOUTH_WEST);*//*Damn, why does setting gravity not work?*/
	/*gtk_window_move(GTK_WINDOW(d.window), 1, 0); /*bottom left*/
	/**/
	g_signal_connect(G_OBJECT (d.window), "destroy",
		    G_CALLBACK (destroy), NULL);

   g_signal_connect(G_OBJECT (d.window), "key_press_event",
		    G_CALLBACK (key_pressed), NULL);
   
   if ( d.format == NULL )
      d.format = "%T";

   get_time(d.buffer, d.tip, d.format);
   d.label = gtk_label_new(d.buffer);

   if ( bg != NULL )
      {
	 GdkColor color;
	 gdk_color_parse(bg, &color);
	 gtk_widget_modify_bg(d.window, GTK_STATE_NORMAL, &color);
      }

   if ( fg != NULL )
      {
	 GdkColor color;
	 gdk_color_parse(fg, &color);
	 gtk_widget_modify_fg(d.label, GTK_STATE_NORMAL, &color);
      }

   if ( font != NULL )
      gtk_widget_modify_font(d.label, pango_font_description_from_string(font));

   d.tooltips = gtk_tooltips_new();
   gtk_tooltips_set_tip(d.tooltips, d.window, "", NULL);
   
   gtk_container_add(GTK_CONTAINER (d.window), d.label);
   
   gtk_widget_show(d.label);
   gtk_widget_show(d.window);
   
   g_timeout_add(1000, (GSourceFunc) clock_update, (gpointer) &d);
   
   gtk_main();
   
   return 0;
}
