/*

 Copyright Mikhail Kostousov

 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include "PDFView.h"
#include "PDFViewerLog.h"
#include "goo/gtypes.h"
#include "controller.h"
#include "PageInfo.h"
#include <gdk/gdkkeysyms.h>

#include <X11/keysym.h>
#include "liberdm/erdm.h"
#include "PDFApp.h"
#include <liberipc/eripcviewer.h>
#include <math.h>
#include "PDFPortraitView.h"
#include "PDFLandscapeView.h"
#include "BookmarksView.h"
#include "GtkAuthDialog.h"


BookmarksView::BookmarksView():view(NULL),bReady(gFalse)
{
	curPage=0;
	selBookmark=0;
}

BookmarksView::~BookmarksView()
{}

void BookmarksView::clear()
{


}


gboolean BookmarksView::buttonPressCbk(GdkEventButton *event)
{
	if (!isReady())
	{
		PV_LOGPRINTF("Not allow to handle mouse event now!");
		return FALSE;
	}
	int x = (int)event->x;
    	int y = (int)event->y;
    	int bookmarkOnThisPage=(view->ctrl->settings.getNumBookmarks()<(curPage+1)*BOOKMARK_ENTRIES_PER_PAGE)?view->ctrl->settings.getNumBookmarks()%BOOKMARK_ENTRIES_PER_PAGE:BOOKMARK_ENTRIES_PER_PAGE;
	
	int ind=(y-BOOKMARK_SPACING)/(BOOKMARK_SPACING+BOOKMARK_HEIGHT);
	int dy=(y-BOOKMARK_SPACING)%(BOOKMARK_SPACING+BOOKMARK_HEIGHT);
	if ((dy>BOOKMARK_SPACING && ind<bookmarkOnThisPage) &&( x > 2* BOOKMARK_SPACING+BOOKMARK_SELECTOR_WIDTH) && ( x < 2* BOOKMARK_SPACING+BOOKMARK_SELECTOR_WIDTH+BOOKMARK_WIDTH))
	{
		moveSelector(ind);
		view->ctrl->settings.setCurrentPage(pages[selBookmark]);
		view->hideBookmarks();
		
	}
	return FALSE;
}          

gboolean BookmarksView::buttonReleaseCbk(GdkEventButton *event)
{
	return TRUE;

}


gboolean BookmarksView::motionNotifyCbk(GdkEventMotion *event)
{

	return TRUE;

}

gboolean BookmarksView::keyPressCbk(GdkEventKey *event)
{
    int bookmarkOnThisPage=(view->ctrl->settings.getNumBookmarks()<(curPage+1)*BOOKMARK_ENTRIES_PER_PAGE)?view->ctrl->settings.getNumBookmarks()%BOOKMARK_ENTRIES_PER_PAGE:BOOKMARK_ENTRIES_PER_PAGE;
    switch (event->keyval)
    {
    case GDK_Home:
	view->hideBookmarks();
        break;
    case GDK_F5:
        view->quit();
        break;  
    case GDK_Page_Up:
    case GDK_Page_Down:
    case GDK_F1: /* iRex: long pageflip forward */
    case GDK_F2: /* iRex: long pageflip backward */
    case GDK_Return: // Short 'dot' button  - toggle scribble visibility

	view->ctrl->settings.setCurrentPage(pages[selBookmark]);
	view->hideBookmarks();
	break;

    case GDK_Up:
 	moveSelector((selBookmark-1+bookmarkOnThisPage)%bookmarkOnThisPage);

        break;
    case GDK_Down:
 	moveSelector((selBookmark+1+bookmarkOnThisPage)%bookmarkOnThisPage);

        break;
    case GDK_F3: // Long press arrow down refreshes the display
    case GDK_F4: /* long up-arrow press: toggle fullscreen mode */
    case GDK_F6: /* long dot press: toggle toolbar */
    default:
        break; // no return: do not bypass keyPressCbk
    }


	return FALSE;

}

gboolean BookmarksView::deleteCbk(GdkEvent *)
{
	return TRUE;
}

void BookmarksView::moveSelector(int newPosition)
{
    int lastSel=selBookmark;
	selBookmark=newPosition;
	view->ctrl->gtkMgr.clearRectangle(BOOKMARK_SPACING,BOOKMARK_SPACING+(BOOKMARK_SPACING+BOOKMARK_HEIGHT)*lastSel,BOOKMARK_SELECTOR_WIDTH,BOOKMARK_HEIGHT);
	redrawSelector();
	XSync(view->ctrl->gtkMgr.display,gTrue);
	view->refreshDeviceScreen(dmQTyping);

}

void BookmarksView::redrawSelector()
{


                view->ctrl->gtkMgr.fillRectangle(BOOKMARK_SPACING,BOOKMARK_SPACING+(BOOKMARK_SPACING+BOOKMARK_HEIGHT)*selBookmark,BOOKMARK_SELECTOR_WIDTH,BOOKMARK_HEIGHT);

}

void BookmarksView::display()
{

	setReady(gFalse);

	// clear background
	if ( view->ctrl->settings.getModeToolbar() == ModeToolbarVisible )
		view->ctrl->gtkMgr.clearBkground();
	else
		view->ctrl->gtkMgr.clearBkgroundFull();
	int j=0;
	char *buf=new char[100];
	for (std::map<int,BookmarkItem>::iterator i=view->ctrl->settings.bookmarks.begin();i!=view->ctrl->settings.bookmarks.end();i++)
	{
		sprintf(buf,"Page %d",i->first);
		pages[j]=i->first;
		view->ctrl->gtkMgr.drawRectangle(2* BOOKMARK_SPACING + BOOKMARK_SELECTOR_WIDTH,BOOKMARK_SPACING+(BOOKMARK_SPACING+BOOKMARK_HEIGHT)*j,BOOKMARK_WIDTH,BOOKMARK_HEIGHT);
		view->ctrl->gtkMgr.drawString(2* BOOKMARK_SPACING + BOOKMARK_SELECTOR_WIDTH+20,BOOKMARK_SPACING+(BOOKMARK_SPACING+BOOKMARK_HEIGHT)*j+50,buf,strlen(buf));
		j++;

	}
	delete [] buf;
	redrawSelector();
	XSync(view->ctrl->gtkMgr.display, gTrue);	

	if (view->ctrl->updateReq <= 0)
	{
		view->refreshDeviceScreen(dmQFull);
		view->ctrl->updateReq = 0;
	}

	setReady();

	view->issueNewRequests();

}

void BookmarksView::ipcCbk(gint * fd,    GdkInputCondition id)
{
	char szBuffer[IPC_BUF_MAX]; 
	int nBuf = IPC_BUF_MAX;
	erIpcCmd_t command;
	erServerChannel_t channel = view->ctrl->channels.erIpcChannel;
	erIpcGetMessage(channel, szBuffer, &nBuf);
	if (vwrParseCommand(szBuffer, &command) >= 0) 
	{
		switch (command.cc) 
		{
			case ccVwrToolbar:
				{
					if (!isReady()) 
					{
						PV_TBPRINTF("Not allow to handle it during rendering!");
						return;
					}
					PV_TBPRINTF("Received toolbar message!");              

					int iconID = atoi(command.arg[0]);
					int state  = atoi(command.arg[1]);
					if (view->ctrl->channels.onReceiveToolbarMsg(iconID, state))
					{
						view->ctrl->channels.setToolbarUpdateType(dmQTyping);
						view->ctrl->channels.redrawToolbar();            
					}
					if (iconID == iconID_sort)
					{
						view->hideBookmarks();
					}


				}
		}

	}
}

