/*

 Copyright Mikhail Kostousov

 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef BOOKMARKSVIEW_H_
#define BOOKMARKSVIEW_H_












#include "PageInfo.h"
#include "LayoutMgr.h"
#include "DisplayList.h"
#include "Settings.h"
#include <gtk/gtk.h>

#include "CPU.h"

// For debug only
#include <iostream>
#include <fstream>


#define BOOKMARK_ENTRIES_PER_PAGE 10

#define BOOKMARK_HEIGHT 70
#define BOOKMARK_WIDTH 700
#define BOOKMARK_SPACING 10
#define BOOKMARK_SELECTOR_WIDTH 20


//////////////////////////////////////////////////////////////////////////
// CPDFPortraitView
// In Portrait View mode, we display page with rotate angle = 0
// The Portrait view could have page mode and continouse mode
//////////////////////////////////////////////////////////////////////////
class CPDFView;
class BookmarksView
{
private:
    CPDFView *      view;
    CLayoutMgr      layout;
    CDisplayList    list;

    int selBookmark;
    int curPage;

    GBool           bReady;         // ready to receive user input

    CPUSpeed        lastSpeed;      // The last set speed

	int pages[BOOKMARK_ENTRIES_PER_PAGE];
   

public:
    BookmarksView(void);
    ~BookmarksView(void);

private:
    void setReady(const GBool b = gTrue) { bReady = b; }
	void moveSelector(int newPosition);
public:
    void setView(CPDFView *p) { view = p; }

//  void init();

    void clear();
	void display();
/*
//    void displayPage(const int pageNumber, const ContinousModeScroll mode = ScrollToPage);
 */   
    void ipcCbk(gint * fd,    GdkInputCondition id);
//   int  hitTest(const int x, const int y, int & ox, int & oy);  

   GBool isReady() const { return bReady; }
	void redrawSelector();

   ////////////////////// gtk event handler /////////////////////////////
    gboolean buttonPressCbk(GdkEventButton *);
    gboolean buttonReleaseCbk(GdkEventButton *);
    gboolean motionNotifyCbk(GdkEventMotion *);
    gboolean keyPressCbk(GdkEventKey *);
    gboolean deleteCbk(GdkEvent *);

};







#endif 
