/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.dpierron.tools;

import com.gmail.dpierron.tools.Helper;
import com.gmail.dpierron.tools.RootTreeNode;
import java.util.Collections;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeNode {
    private Object data;
    private String id;
    private TreeNode parent;
    private List<TreeNode> children;

    public TreeNode(String id) {
        this(id, null);
    }

    public TreeNode(String id, Object data) {
        this.data = data;
        this.id = id;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public boolean isRoot() {
        return this instanceof RootTreeNode;
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public void setParent(TreeNode parent) {
        this.parent = parent;
    }

    public List<TreeNode> getChildren() {
        if (this.children == null) {
            this.children = new Vector<TreeNode>();
        }
        return this.children;
    }

    public void setChildren(List<TreeNode> newChildren) {
        this.children = newChildren;
    }

    public TreeNode getChildWithId(String id) {
        for (TreeNode childNode : this.getChildren()) {
            if (!childNode.getId().equals(id)) continue;
            return childNode;
        }
        return null;
    }

    public void addChild(TreeNode child) {
        if (child == null) {
            return;
        }
        this.getChildren().add(child);
        child.setParent(this);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String value) {
        this.id = value;
    }

    public String getIdToRoot() {
        return this.getIdToRoot("_");
    }

    public String getIdToRoot(String separator) {
        Vector<String> ids = new Vector<String>();
        TreeNode node = this;
        while (node.getParent() != null) {
            ids.add(node.getId());
            node = node.getParent();
        }
        Collections.reverse(ids);
        return Helper.concatenateList(separator, ids);
    }

    public String getGuid() {
        String guid = this.getIdToRoot();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < guid.length(); ++i) {
            char c = guid.charAt(i);
            if (Character.isLetterOrDigit(c)) {
                sb.append(c);
                continue;
            }
            sb.append('_');
        }
        return sb.toString();
    }

    public String toString() {
        String base = this.getIdToRoot("/");
        if (this.getData() == null) {
            return base;
        }
        return base + " (" + this.getData() + ")";
    }
}

