/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.dpierron.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.dgc.VMID;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Helper {
    private static final Logger logger = Logger.getLogger(Helper.class);
    private static final String DEFAULT_PREFIX = "com.gmail.dpierron.";
    static final int DEFAULT_STACK_DEPTH = 5;

    public static final boolean stringEquals(String s1, String s2) {
        return Helper.objectEquals(s1, s2);
    }

    public static final boolean objectEquals(Object o1, Object o2) {
        if (o1 == null || o2 == null) {
            return o1 == null && o2 == null;
        }
        return o1.equals(o2);
    }

    public static String newId() {
        String result = new VMID().toString();
        result = result.replace('0', 'G');
        result = result.replace('1', 'H');
        result = result.replace('2', 'I');
        result = result.replace('3', 'J');
        result = result.replace('4', 'K');
        result = result.replace('5', 'L');
        result = result.replace('6', 'M');
        result = result.replace('7', 'N');
        result = result.replace('8', 'O');
        result = result.replace('9', 'P');
        result = result.replaceAll("-", "");
        result = result.replaceAll(":", "");
        return result;
    }

    public static void logStack(Logger logger) {
        Helper.logStack(logger, 2, 5, DEFAULT_PREFIX);
    }

    public static void logStack(Logger logger, int maxDepth) {
        Helper.logStack(logger, 2, maxDepth, DEFAULT_PREFIX);
    }

    public static void logStack(Logger logger, int skip, int maxDepth) {
        Helper.logStack(logger, skip + 2, maxDepth, DEFAULT_PREFIX);
    }

    public static void logStack(Logger logger, int skip, int maxDepth, String removePrefix) {
        RuntimeException e = new RuntimeException();
        e.fillInStackTrace();
        StackTraceElement[] calls = e.getStackTrace();
        for (int i = skip; i < maxDepth + skip && i < calls.length; ++i) {
            int pos;
            StackTraceElement call = e.getStackTrace()[i];
            String msg = call.toString();
            if (removePrefix != null && (pos = msg.indexOf(removePrefix)) > -1) {
                msg = msg.substring(pos + removePrefix.length());
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("Stack trace [" + (i - skip) + "] -> " + msg));
        }
    }

    public static String concatenateList(Collection toConcatenate) {
        return Helper.concatenateList(null, toConcatenate, (String[])null);
    }

    public static String concatenateList(String separator, Collection toConcatenate) {
        return Helper.concatenateList(separator, toConcatenate, (String[])null);
    }

    public static String concatenateList(Collection toConcatenate, String ... methodName) {
        return Helper.concatenateList(null, toConcatenate, methodName);
    }

    public static String concatenateList(String separator, Collection toConcatenate, String ... methodName) {
        try {
            if (toConcatenate == null || toConcatenate.size() == 0) {
                return "";
            }
            StringBuffer lines = new StringBuffer();
            String theSeparator = separator == null ? ", " : separator;
            for (Object o : toConcatenate) {
                Object result = o;
                if (methodName == null) {
                    result = o.toString();
                } else {
                    for (String theMethodName : methodName) {
                        Method method = null;
                        try {
                            method = result.getClass().getMethod(theMethodName, new Class[0]);
                        }
                        catch (SecurityException e) {
                            logger.warn((Object)e.getMessage(), (Throwable)e);
                        }
                        catch (NoSuchMethodException e) {
                            logger.warn((Object)e.getMessage(), (Throwable)e);
                        }
                        if (method == null) continue;
                        try {
                            result = method.invoke(result, new Object[0]);
                        }
                        catch (IllegalArgumentException e) {
                            logger.warn((Object)e.getMessage(), (Throwable)e);
                        }
                        catch (IllegalAccessException e) {
                            logger.warn((Object)e.getMessage(), (Throwable)e);
                        }
                        catch (InvocationTargetException e) {
                            logger.warn((Object)e.getMessage(), (Throwable)e);
                        }
                    }
                }
                lines.append(result);
                lines.append(theSeparator);
            }
            String sLines = lines.length() >= theSeparator.length() ? lines.substring(0, lines.length() - theSeparator.length()) : "";
            return sLines;
        }
        catch (Exception e) {
            return "";
        }
    }

    public static Collection transformList(Collection toTransform, String ... methodName) {
        Vector<Object> transformed = new Vector<Object>();
        try {
            if (toTransform == null || toTransform.size() == 0) {
                return toTransform;
            }
            for (Object o : toTransform) {
                Object result = o;
                if (methodName == null) {
                    result = o.toString();
                } else {
                    for (String theMethodName : methodName) {
                        Method method = result.getClass().getMethod(theMethodName, new Class[0]);
                        result = method.invoke(result, new Object[0]);
                    }
                }
                transformed.add(result);
            }
            return transformed;
        }
        catch (Exception e) {
            return transformed;
        }
    }

    public static List<String> tokenize(String text, String delim) {
        return Helper.tokenize(text, delim, false);
    }

    public static List<String> tokenize(String text, String delim, boolean trim) {
        Vector<String> result = new Vector<String>();
        if (Helper.isNotNullOrEmpty(text)) {
            String s = text.replaceAll(delim, "\u00c4");
            StringTokenizer tokenizer = new StringTokenizer(s, "\u00c4");
            while (tokenizer.hasMoreElements()) {
                String token = tokenizer.nextToken();
                if (trim) {
                    token = token.trim();
                }
                result.add(token);
            }
        }
        return result;
    }

    public static String deTokenize(Collection<String> list, String delim) {
        if (list.size() > 0) {
            StringBuffer sb = new StringBuffer();
            for (String text : list) {
                if (sb.length() > 0) {
                    sb.append(delim);
                }
                sb.append(text);
            }
            return sb.toString();
        }
        return "";
    }

    public static String pad(String s, char paddingCharacter, int length) {
        if (s.length() >= length) {
            return s;
        }
        StringBuffer sb = new StringBuffer(s);
        for (int i = s.length(); i < length; ++i) {
            sb.append(paddingCharacter);
        }
        return sb.toString();
    }

    public static String getLastNumericComponent(String s) {
        int i;
        for (i = s.length() - 1; i >= 0 && Character.isDigit(s.charAt(i)); --i) {
        }
        if (i < 0) {
            return s;
        }
        if (i == s.length() - 1 && !Character.isDigit(s.charAt(i))) {
            return null;
        }
        return s.substring(i + 1);
    }

    public static String substractString(String s, String toSubstract) {
        if (Helper.isNullOrEmpty(s)) {
            return s;
        }
        if (Helper.isNullOrEmpty(toSubstract)) {
            return s;
        }
        if (!s.startsWith(toSubstract)) {
            return s;
        }
        return s.substring(toSubstract.length());
    }

    public static boolean trueBooleanEquals(Object o1, Object o2) {
        return Helper.trueBoolean(o1) == Helper.trueBoolean(o2);
    }

    public static boolean trueBoolean(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        return new Boolean(o.toString());
    }

    public static Integer parseInteger(String s) {
        if (Helper.isNullOrEmpty(s)) {
            return null;
        }
        try {
            int i = Integer.parseInt(s);
            return new Integer(i);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static boolean trueStringEquals(Object o1, Object o2) {
        return Helper.trueString(o1).equals(Helper.trueString(o2));
    }

    public static int trueStringCompare(Object o1, Object o2) {
        return Helper.trueString(o1).compareTo(Helper.trueString(o2));
    }

    public static String trueString(Object o) {
        if (o == null) {
            return "";
        }
        return o.toString();
    }

    public static Object[] arrayThis(Object[] theArray, Object ... objects) {
        ArrayList result = Helper.listThis(objects);
        return result.toArray(theArray);
    }

    public static ArrayList listThis(Object ... objects) {
        return Helper.listThis(false, objects);
    }

    public static ArrayList listThis(boolean duplicates, Object ... objects) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (objects != null) {
            for (Object object : objects) {
                if (object == null) continue;
                if (object instanceof List) {
                    List list = (List)object;
                    if (duplicates) {
                        result.addAll(list);
                        continue;
                    }
                    if (list == null) continue;
                    for (Object item : list) {
                        if (item == null || result.contains(item)) continue;
                        result.add(item);
                    }
                    continue;
                }
                result.add(object);
            }
        }
        return result;
    }

    public static String wrap(String inString, int wrap_length, String prepend) {
        int offset = 0;
        StringBuffer result = new StringBuffer();
        if (inString == null) {
            return null;
        }
        if (wrap_length < 0) {
            throw new IllegalArgumentException("bad params");
        }
        if (prepend != null) {
            result.append(prepend);
        }
        char[] charAry = inString.toCharArray();
        int marker = 0;
        int p = 0;
        while (marker < charAry.length) {
            int p2;
            while (p < charAry.length && charAry[p] != '\n' && p - marker < wrap_length) {
                ++p;
            }
            if (p == charAry.length) {
                result.append(inString.substring(marker, p));
                return result.toString();
            }
            if (charAry[p] == '\n') {
                result.append(inString.substring(marker, p + 1));
                if (prepend != null) {
                    result.append(prepend);
                }
                p = marker = p + 1;
                continue;
            }
            if (p < charAry.length) {
                if (Helper.isspace(charAry[p])) {
                    offset = 1;
                } else {
                    for (p2 = p - 1; p2 > marker && !Helper.isspace(charAry[p2]); --p2) {
                    }
                    offset = 0;
                }
            }
            if (p2 == marker) {
                p2 = p - 1;
            }
            if (!Helper.isspace(charAry[p2])) {
                result.append(inString.substring(marker, p2 + 1));
            } else {
                result.append(inString.substring(marker, p2));
            }
            if (p < charAry.length) {
                result.append("\n");
                if (prepend != null) {
                    result.append(prepend);
                }
            }
            p = marker = p2 + 1 + offset;
        }
        return result.toString();
    }

    public static String wrap(String inString, int wrap_length) {
        return Helper.wrap(inString, wrap_length, null);
    }

    public static String wrap(String inString) {
        return Helper.wrap(inString, 150, null);
    }

    public static boolean isspace(char c) {
        return c == '\n' || c == ' ' || c == '\t';
    }

    public static boolean contains(Collection c, Object o, Comparator comparator) {
        if (comparator == null) {
            return c.contains(o);
        }
        for (Object o2 : c) {
            if (comparator.compare(o, o2) != 0) continue;
            return true;
        }
        return false;
    }

    public static Collection intersect(Collection c1, Collection c2) {
        return Helper.intersect(c1, c2, null);
    }

    public static Collection intersect(Collection c1, Collection c2, Comparator comparator) {
        Vector result = new Vector();
        if (c1 == null || c2 == null || c1.size() == 0 || c2.size() == 0) {
            return result;
        }
        Collection left = c1;
        Collection right = c2;
        if (left instanceof Set && !(right instanceof Set) || left.size() > right.size()) {
            left = c2;
            right = c1;
        }
        for (Object l : left) {
            if (!Helper.contains(right, l, comparator)) continue;
            result.add(l);
        }
        return result;
    }

    public static final boolean isNotNullOrEmpty(Object object) {
        return !Helper.isNullOrEmpty(object);
    }

    public static final boolean isNotNullOrEmptyOrZero(Object object) {
        return !Helper.isNullOrEmpty(object, true);
    }

    public static final boolean isNullOrEmpty(Object object) {
        return Helper.isNullOrEmpty(object, false);
    }

    public static final boolean isNullOrEmptyOrZero(Object object) {
        return Helper.isNullOrEmpty(object, true);
    }

    private static final boolean isNullOrEmpty(Object object, boolean zeroEqualsEmpty) {
        if (object == null) {
            return true;
        }
        if (object instanceof Collection) {
            return ((Collection)object).size() == 0;
        }
        if (object instanceof Map) {
            return ((Map)object).size() == 0;
        }
        if (object.getClass().isArray()) {
            return ((Object[])object).length == 0;
        }
        if (object instanceof Number && zeroEqualsEmpty) {
            return ((Number)object).longValue() == 0L;
        }
        return object.toString().length() == 0;
    }

    public static List<File> recursivelyGetFiles(String extension, File currentDir) {
        Vector<File> result = new Vector<File>();
        Helper.recursivelyGetFiles(extension, currentDir, result);
        return result;
    }

    private static void recursivelyGetFiles(final String extension, File currentDir, List<File> filesList) {
        String[] files;
        for (String filename : files = currentDir.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                File f = new File(dir, name);
                return f.isDirectory() || name.endsWith(extension);
            }
        })) {
            File f = new File(currentDir, filename);
            if (f.isDirectory()) {
                Helper.recursivelyGetFiles(extension, f, filesList);
                continue;
            }
            filesList.add(f);
        }
    }

    public static String forceCharset(String text, String charset) {
        String result = text;
        try {
            result = new String(text.getBytes(charset));
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public static Object getDelegateOrNull(Object source) {
        return Helper.getDelegateOrNull(source, false);
    }

    public static Object getDelegateOrNull(Object source, boolean digDeep) {
        if (source == null) {
            return null;
        }
        Object result = source;
        try {
            Method method = source.getClass().getMethod("getDelegate", null);
            if (method != null) {
                result = method.invoke(source, (Object[])null);
            }
        }
        catch (SecurityException e) {
        }
        catch (NoSuchMethodException e) {
        }
        catch (IllegalArgumentException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        if (digDeep && result != source) {
            return Helper.getDelegateOrNull(result, digDeep);
        }
        return result;
    }

    public static List filter(List source, List unwantedKeys, String method) {
        if (Helper.isNullOrEmpty(unwantedKeys)) {
            return source;
        }
        if (Helper.isNullOrEmpty(source)) {
            return source;
        }
        Vector result = new Vector();
        for (Object object : source) {
            if (object == null) continue;
            Object key = null;
            try {
                Method keyGetter = object.getClass().getMethod(method, null);
                if (keyGetter != null) {
                    key = keyGetter.invoke(object, (Object[])null);
                }
            }
            catch (SecurityException e) {
            }
            catch (NoSuchMethodException e) {
            }
            catch (IllegalArgumentException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {
                // empty catch block
            }
            if (key == null) {
                key = object.toString();
            }
            if (key == null || unwantedKeys.contains(key)) continue;
            result.add(object);
        }
        return result;
    }

    public static List filter(List source, List<Class> unwantedClasses) {
        if (Helper.isNullOrEmpty(unwantedClasses)) {
            return source;
        }
        if (Helper.isNullOrEmpty(source)) {
            return source;
        }
        Vector result = new Vector();
        for (Object object : source) {
            if (object == null || unwantedClasses.contains(object.getClass())) continue;
            result.add(object);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File putBytesIntoFile(byte[] bytes, File file) throws IOException {
        FileOutputStream out = new FileOutputStream(file);
        try {
            out.write(bytes);
        }
        finally {
            out.close();
        }
        return file;
    }

    public static File getFileFromBytes(byte[] bytes) throws IOException {
        String prefix = new VMID().toString();
        return Helper.getFileFromBytes(bytes, prefix);
    }

    public static File getFileFromBytes(byte[] bytes, String prefix) throws IOException {
        File f = File.createTempFile(prefix, null);
        return Helper.putBytesIntoFile(bytes, f);
    }

    public static byte[] getBytesFromFile(File file) throws IOException {
        int offset;
        FileInputStream is = new FileInputStream(file);
        long length = file.length();
        if (length > Integer.MAX_VALUE) {
            // empty if block
        }
        byte[] bytes = new byte[(int)length];
        int numRead = 0;
        for (offset = 0; offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
        }
        if (offset < bytes.length) {
            throw new IOException("Could not completely read file " + file.getName());
        }
        ((InputStream)is).close();
        return bytes;
    }

    public static String nowAs14CharString() {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
        return format.format(new Date());
    }

    public static String removeLeadingZeroes(String value) {
        return Helper.removeLeadingChars(value, '0');
    }

    public static String removeLeadingChars(String value, char charToRemove) {
        if (Helper.isNotNullOrEmpty(value)) {
            String regex = "^" + charToRemove + "*";
            return value.replaceAll(regex, "");
        }
        return value;
    }

    public static String makeString(String baseString, int number) {
        if (Helper.isNotNullOrEmpty(baseString) && number > 0) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < number; ++i) {
                sb.append(baseString);
            }
            return sb.toString();
        }
        return "";
    }

    public static String getStackTrace(Throwable t) {
        if (t == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (StackTraceElement element : t.getStackTrace()) {
            sb.append(element.toString());
            sb.append('\n');
        }
        return sb.toString();
    }

    public static Stack<Throwable> unwrap(Throwable t) {
        Stack<Throwable> result = new Stack<Throwable>();
        while (t != null) {
            result.add(t);
            t = t.getCause();
        }
        return result;
    }

    public static String shorten(String s, int maxSize) {
        if (Helper.isNullOrEmpty(s)) {
            return s;
        }
        if (s.length() > maxSize) {
            return s.substring(0, maxSize) + "...";
        }
        return s;
    }

    public static void copy(File src, File dst, boolean checkDates) throws IOException {
        if (src == null || dst == null) {
            return;
        }
        if (!src.exists()) {
            return;
        }
        if (src.isDirectory()) {
            if (!dst.exists()) {
                dst.mkdirs();
            } else if (!dst.isDirectory()) {
                return;
            }
        } else {
            boolean copy = false;
            if (!dst.exists()) {
                System.out.println("creating dirs " + dst.getPath());
                dst.mkdirs();
                copy = true;
            }
            boolean bl = copy = copy || !checkDates || src.lastModified() > dst.lastModified();
            if (copy) {
                FileInputStream in = new FileInputStream(src);
                Helper.copy(in, dst);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File src, File dst) throws IOException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(src);
            Helper.copy(in, dst);
        }
        finally {
            if (in != null) {
                ((InputStream)in).close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream in, File dst) throws IOException {
        if (!dst.exists()) {
            dst.getParentFile().mkdirs();
        }
        FileOutputStream out = null;
        try {
            int len;
            out = new FileOutputStream(dst);
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
        }
        finally {
            if (out != null) {
                ((OutputStream)out).close();
            }
        }
    }

    public static void delete(File path) {
        if (path.exists()) {
            boolean result;
            if (path.isDirectory()) {
                File[] files = path.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    Helper.delete(files[i]);
                }
            }
            if (!(result = path.delete())) {
                logger.warn((Object)("couldn't delete " + path.getAbsolutePath()));
            }
        }
    }

    public static long count(File path) {
        int result = 0;
        if (path.exists()) {
            if (path.isDirectory()) {
                File[] files = path.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    result = (int)((long)result + Helper.count(files[i]));
                }
            }
            ++result;
        }
        return result;
    }

    public static int checkedCompare(Comparable o1, Comparable o2) {
        if (o1 == null) {
            if (o2 == null) {
                return 0;
            }
            return 1;
        }
        if (o2 == null) {
            if (o1 == null) {
                return 0;
            }
            return -1;
        }
        return o1.compareTo(o2);
    }

    public static ArrayList<File> listFilesIn(File dir) {
        ArrayList<File> result = new ArrayList<File>();
        if (dir != null || dir.isDirectory()) {
            String[] children;
            for (String childName : children = dir.list()) {
                File child = new File(dir, childName);
                if (child.isDirectory()) {
                    result.addAll(Helper.listFilesIn(child));
                }
                result.add(child);
            }
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ListCopier<T> {
        public List<T> copyList(List<T> original, int pMaxSize) {
            if (original == null) {
                return null;
            }
            int maxSize = pMaxSize;
            if (maxSize < 0) {
                maxSize = original.size();
            }
            if (original.size() <= maxSize) {
                return new Vector<T>(original);
            }
            Vector<T> result = new Vector<T>(maxSize);
            for (int i = 0; i < maxSize; ++i) {
                result.add(original.get(i));
            }
            return result;
        }
    }
}

