/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.dpierron.calibre.datamodel.test;

import com.gmail.dpierron.calibre.datamodel.Author;
import com.gmail.dpierron.calibre.datamodel.Book;
import com.gmail.dpierron.calibre.datamodel.DataModel;
import com.gmail.dpierron.calibre.datamodel.Series;
import com.gmail.dpierron.calibre.datamodel.Tag;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;

public class DataModelTester {
    private static final Logger logger = Logger.getLogger(DataModelTester.class);

    private void skipLine() {
        logger.info((Object)"\r\n");
    }

    public void testDataModel() {
        this.testDataModel(true);
    }

    public void testDataModel(boolean checkFiles) {
        this.skipLine();
        logger.info((Object)"loading books");
        List<Book> books = DataModel.INSTANCE.getListOfBooks();
        logger.info((Object)("Found " + books.size() + " book(s)"));
        this.skipLine();
        if (checkFiles) {
            String filename;
            int i;
            String[] files;
            this.skipLine();
            logger.info((Object)"checking books ePub files");
            Vector<Book> withEpub = new Vector<Book>();
            Vector<Book> withoutEpub = new Vector<Book>();
            for (Book book : books) {
                if (book.doesEpubFileExist()) {
                    withEpub.add(book);
                    continue;
                }
                withoutEpub.add(book);
            }
            this.skipLine();
            this.skipLine();
            logger.info((Object)("list of the " + withEpub.size() + " book(s) with a valid ePub file : "));
            for (Book book : withEpub) {
                logger.info((Object)("book:" + book.toDetailedString()));
                logger.info((Object)("epub:" + book.getEpubFilename()));
            }
            this.skipLine();
            this.skipLine();
            logger.info((Object)("list of the " + withoutEpub.size() + " book(s) without a valid ePub file : "));
            Vector<Book> vector = new Vector<Book>();
            for (Book book : withoutEpub) {
                logger.info((Object)("book:" + book.toDetailedString()));
                logger.info((Object)("epub:" + book.getEpubFilename()));
                if (book.getBookFolder().exists()) {
                    files = book.getBookFolder().list();
                    for (i = 0; i < files.length; ++i) {
                        filename = files[i];
                        logger.info((Object)("file:" + filename));
                        if (!filename.toUpperCase().endsWith(".EPUB")) continue;
                        vector.add(book);
                    }
                    continue;
                }
                logger.info((Object)("file: Book folder does not even exist! " + book.getBookFolder().getAbsolutePath()));
            }
            this.skipLine();
            this.skipLine();
            logger.info((Object)("list of the " + vector.size() + " book(s) with an invalid ePub file : "));
            for (Book book : vector) {
                logger.info((Object)("book:" + book.toDetailedString()));
                logger.info((Object)("epub:" + book.getEpubFilename()));
                if (book.getBookFolder().exists()) {
                    files = book.getBookFolder().list();
                    for (i = 0; i < files.length; ++i) {
                        filename = files[i];
                        if (!filename.toUpperCase().endsWith(".EPUB")) continue;
                        logger.info((Object)("file:" + filename));
                    }
                    continue;
                }
                logger.info((Object)("file: Book folder does not even exist! " + book.getBookFolder().getAbsolutePath()));
            }
            this.skipLine();
        }
        this.skipLine();
        logger.info((Object)"loading tags");
        List<Tag> list = DataModel.INSTANCE.getListOfTags(null);
        logger.info((Object)("there are " + list.size() + " tag(s)"));
        this.skipLine();
        this.skipLine();
        logger.info((Object)"loading books by tag");
        for (Tag tag : DataModel.INSTANCE.getMapOfBooksByTag().keySet()) {
            books = DataModel.INSTANCE.getMapOfBooksByTag().get(tag);
            logger.info((Object)(tag + " has " + books.size() + " book(s)"));
        }
        this.skipLine();
        this.skipLine();
        logger.info((Object)"loading books by author");
        for (Author author : DataModel.INSTANCE.getMapOfBooksByAuthor().keySet()) {
            books = DataModel.INSTANCE.getMapOfBooksByAuthor().get(author);
            logger.info((Object)(author + " has " + books.size() + " book(s)"));
        }
        this.skipLine();
        this.skipLine();
        logger.info((Object)"loading books by serie");
        for (Series series : DataModel.INSTANCE.getMapOfBooksBySerie().keySet()) {
            books = DataModel.INSTANCE.getMapOfBooksBySerie().get(series);
            logger.info((Object)(series + " has " + books.size() + " book(s)"));
        }
        this.skipLine();
    }
}

