/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.dpierron.calibre.datamodel.filter;

import com.gmail.dpierron.calibre.datamodel.Book;
import com.gmail.dpierron.calibre.datamodel.EBookFile;
import com.gmail.dpierron.calibre.datamodel.EBookFormat;
import com.gmail.dpierron.calibre.datamodel.filter.BookFilter;
import com.gmail.dpierron.tools.Helper;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectedEbookFormatsFilter
implements BookFilter {
    List<EBookFormat> includedFormats = new Vector<EBookFormat>();
    boolean includeBooksWithNoFile;

    public SelectedEbookFormatsFilter(String includedFormatsList, boolean includeBooksWithNoFile) {
        if (Helper.isNullOrEmpty((Object)includedFormatsList) || "ALL".equalsIgnoreCase(includedFormatsList)) {
            this.includedFormats = Arrays.asList(EBookFormat.values());
        } else {
            List list = Helper.tokenize((String)includedFormatsList, (String)",", (boolean)true);
            int priority = list.size();
            for (String string : list) {
                EBookFormat format = EBookFormat.fromFormat(string.trim());
                if (format == null) continue;
                format.setPriority(priority--);
                this.includedFormats.add(format);
            }
        }
        this.includeBooksWithNoFile = includeBooksWithNoFile;
    }

    private List<EBookFormat> getIncludedFormats() {
        return this.includedFormats;
    }

    @Override
    public boolean didBookPassThroughFilter(Book book) {
        if (book == null) {
            return false;
        }
        Vector<EBookFile> files = new Vector<EBookFile>(book.getFiles());
        for (EBookFile eBookFile : files) {
            if (this.getIncludedFormats().contains(eBookFile.getFormat())) continue;
            book.removeFile(eBookFile);
        }
        if (book.getFiles().size() == 0) {
            return this.includeBooksWithNoFile;
        }
        Collections.sort(book.getFiles(), new Comparator<EBookFile>(){

            @Override
            public int compare(EBookFile o1, EBookFile o2) {
                if (o1 == null && o2 == null) {
                    return 0;
                }
                if (o1 == null && o2 != null) {
                    return 1;
                }
                if (o1 != null && o2 == null) {
                    return -1;
                }
                return new Integer(o2.getFormat().getPriority()).compareTo(new Integer(o1.getFormat().getPriority()));
            }
        });
        return true;
    }
}

