/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.dpierron.calibre.datamodel.filter;

import com.gmail.dpierron.calibre.datamodel.Book;
import com.gmail.dpierron.calibre.datamodel.Tag;
import com.gmail.dpierron.calibre.datamodel.filter.BookFilter;
import com.gmail.dpierron.tools.Helper;
import java.util.List;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequiredTagsFilter
implements BookFilter {
    List<String> requiredTags;
    boolean includeBooksWithNoTag;

    public RequiredTagsFilter(String requiredTagsList, boolean includeBooksWithNoTag) {
        if (Helper.isNotNullOrEmpty((Object)requiredTagsList)) {
            this.requiredTags = Helper.tokenize((String)requiredTagsList.toUpperCase(Locale.ENGLISH), (String)",", (boolean)true);
        }
        this.includeBooksWithNoTag = includeBooksWithNoTag;
    }

    private List<String> getRequiredTags() {
        return this.requiredTags;
    }

    @Override
    public boolean didBookPassThroughFilter(Book book) {
        if (book == null) {
            return false;
        }
        if (Helper.isNullOrEmpty(this.requiredTags)) {
            return true;
        }
        for (String requiredTagName : this.getRequiredTags()) {
            boolean found = false;
            for (Tag tag : book.getTags()) {
                if (!tag.getName().equalsIgnoreCase(requiredTagName)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }
}

