/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.dpierron.calibre.datamodel.filter;

import com.gmail.dpierron.calibre.datamodel.Book;
import com.gmail.dpierron.calibre.datamodel.Tag;
import com.gmail.dpierron.calibre.datamodel.filter.BookFilter;
import com.gmail.dpierron.tools.Helper;
import java.util.List;
import java.util.Locale;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForbiddenTagsFilter
implements BookFilter {
    List<String> forbiddenTags;
    boolean includeBooksWithNoTag;

    public ForbiddenTagsFilter(String forbiddenTagsList, boolean includeBooksWithNoTag) {
        if (Helper.isNotNullOrEmpty((Object)forbiddenTagsList)) {
            this.forbiddenTags = Helper.tokenize((String)forbiddenTagsList.toUpperCase(Locale.ENGLISH), (String)",", (boolean)true);
        }
        this.includeBooksWithNoTag = includeBooksWithNoTag;
    }

    private List<String> getForbiddenTags() {
        return this.forbiddenTags;
    }

    @Override
    public boolean didBookPassThroughFilter(Book book) {
        if (book == null) {
            return false;
        }
        if (Helper.isNullOrEmpty(this.forbiddenTags)) {
            return true;
        }
        Vector<Tag> tags = new Vector<Tag>(book.getTags());
        for (Tag tag : tags) {
            if (!this.getForbiddenTags().contains(tag.getName().toUpperCase())) continue;
            return false;
        }
        return true;
    }
}

