/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.dpierron.calibre.datamodel.filter;

import com.gmail.dpierron.calibre.datamodel.Author;
import com.gmail.dpierron.calibre.datamodel.Book;
import com.gmail.dpierron.calibre.datamodel.BookRating;
import com.gmail.dpierron.calibre.datamodel.DataModel;
import com.gmail.dpierron.calibre.datamodel.Publisher;
import com.gmail.dpierron.calibre.datamodel.Series;
import com.gmail.dpierron.calibre.datamodel.Tag;
import com.gmail.dpierron.calibre.datamodel.filter.BookFilter;
import com.gmail.dpierron.tools.Helper;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum FilterDataModel {
    INSTANCE;


    public void runOnDataModel(BookFilter filter) {
        Vector<Book> booksCopy = new Vector<Book>(DataModel.INSTANCE.getListOfBooks());
        for (Book book : booksCopy) {
            if (filter.didBookPassThroughFilter(book)) continue;
            for (Tag tag : book.getTags()) {
                List<Book> books = DataModel.INSTANCE.getMapOfBooksByTag().get(tag);
                if (Helper.isNotNullOrEmpty(books)) {
                    books.remove(book);
                }
                if (!Helper.isNullOrEmpty(books)) continue;
                DataModel.INSTANCE.getMapOfBooksByTag().remove(tag);
                DataModel.INSTANCE.getListOfTags(null).remove(tag);
            }
            DataModel.INSTANCE.getMapOfTagsByBookId().remove(book.getId());
            Series serie = book.getSeries();
            List<Book> booksInSerie = DataModel.INSTANCE.getMapOfBooksBySerie().get(serie);
            if (Helper.isNotNullOrEmpty(booksInSerie)) {
                booksInSerie.remove(book);
            }
            if (Helper.isNullOrEmpty(booksInSerie)) {
                DataModel.INSTANCE.getMapOfBooksBySerie().remove(serie);
                DataModel.INSTANCE.getListOfSeries().remove(serie);
            }
            DataModel.INSTANCE.getMapOfSeriesByBookId().remove(book.getId());
            for (Author author : book.getAuthors()) {
                List<Book> booksByAuthor = DataModel.INSTANCE.getMapOfBooksByAuthor().get(author);
                if (Helper.isNotNullOrEmpty(booksByAuthor)) {
                    booksByAuthor.remove(book);
                }
                if (!Helper.isNullOrEmpty(booksByAuthor)) continue;
                DataModel.INSTANCE.getMapOfBooksByAuthor().remove(author);
                DataModel.INSTANCE.getListOfAuthors().remove(author);
            }
            DataModel.INSTANCE.getMapOfAuthorsByBookId().remove(book.getId());
            BookRating rating = book.getRating();
            List<Book> booksInRating = DataModel.INSTANCE.getMapOfBooksByRating().get((Object)rating);
            if (Helper.isNotNullOrEmpty(booksInRating)) {
                booksInRating.remove(book);
            }
            if (Helper.isNullOrEmpty(booksInRating)) {
                DataModel.INSTANCE.getMapOfBooksByRating().remove((Object)rating);
            }
            Publisher publisher = book.getPublisher();
            List<Book> booksByPublisher = DataModel.INSTANCE.getMapOfBooksByPublisher().get(publisher);
            if (Helper.isNotNullOrEmpty(booksByPublisher)) {
                booksByPublisher.remove(book);
            }
            if (Helper.isNullOrEmpty(booksByPublisher)) {
                DataModel.INSTANCE.getMapOfBooksByPublisher().remove(publisher);
                DataModel.INSTANCE.getListOfPublishers().remove(publisher);
            }
            DataModel.INSTANCE.getListOfBooks().remove(book);
            DataModel.INSTANCE.getMapOfBooks().remove(book.getId());
            DataModel.INSTANCE.getMapOfCommentsByBookId().remove(book.getId());
            DataModel.INSTANCE.getMapOfFilesByBookId().remove(book.getId());
        }
        for (Tag tag : new Vector<Tag>(DataModel.INSTANCE.getListOfTags(null))) {
            List<Book> books = DataModel.INSTANCE.getMapOfBooksByTag().get(tag);
            if (!Helper.isNullOrEmpty(books)) continue;
            DataModel.INSTANCE.getMapOfBooksByTag().remove(tag);
            DataModel.INSTANCE.getListOfTags(null).remove(tag);
        }
        for (Series serie : new Vector<Series>(DataModel.INSTANCE.getListOfSeries())) {
            List<Book> booksInSerie = DataModel.INSTANCE.getMapOfBooksBySerie().get(serie);
            if (!Helper.isNullOrEmpty(booksInSerie)) continue;
            DataModel.INSTANCE.getMapOfBooksBySerie().remove(serie);
            DataModel.INSTANCE.getListOfSeries().remove(serie);
        }
        for (Author author : new Vector<Author>(DataModel.INSTANCE.getListOfAuthors())) {
            List<Book> booksByAuthor = DataModel.INSTANCE.getMapOfBooksByAuthor().get(author);
            if (!Helper.isNullOrEmpty(booksByAuthor)) continue;
            DataModel.INSTANCE.getMapOfBooksByAuthor().remove(author);
            DataModel.INSTANCE.getListOfAuthors().remove(author);
        }
    }
}

