/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.dpierron.calibre.datamodel;

import com.gmail.dpierron.calibre.datamodel.SplitableByLetter;
import com.gmail.dpierron.tools.Helper;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tag
implements SplitableByLetter,
Comparable<Tag> {
    private String id;
    private String name;
    private String[] partsOfTag;
    private int[] partsOfTagHash;

    public Tag(String id, String name) {
        this.id = id;
        this.name = name;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public String getTitleToSplitByLetter(Object options) {
        return this.getName();
    }

    public String[] getPartsOfTag(String splitTagsOn) {
        if (this.partsOfTag == null) {
            List parts = Helper.tokenize((String)this.getName(), (String)splitTagsOn);
            this.partsOfTag = new String[parts.size()];
            this.partsOfTagHash = new int[this.partsOfTag.length];
            for (int i = 0; i < parts.size(); ++i) {
                String part;
                this.partsOfTag[i] = part = (String)parts.get(i);
                this.partsOfTagHash[i] = part == null ? -1 : part.hashCode();
            }
        }
        return this.partsOfTag;
    }

    public int[] getPartsOfTagHash(String splitTagsOn) {
        if (this.partsOfTag == null) {
            this.getPartsOfTag(splitTagsOn);
        }
        return this.partsOfTagHash;
    }

    @Override
    public int compareTo(Tag o) {
        if (o == null) {
            return 1;
        }
        return Helper.trueStringCompare((Object)this.getId(), (Object)o.getId());
    }
}

