/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.dpierron.calibre.datamodel;

import com.gmail.dpierron.tools.Helper;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum NoiseWord {
    ENGLISH("EN", "the ", "a ", "an "),
    FRENCH("FR", "le ", "la ", "les ", "l'", "un ", "une ", "du ", "de ", "la ", "des "),
    GERMAN("DE", "der ", "die ", "das ", "ein ", "eine ");

    private List<String> noiseWords;
    private String lang;
    private static Map<String, NoiseWord> map;
    public static NoiseWord DEFAULT;

    private NoiseWord(String lang, String ... words) {
        List<String> temp = Arrays.asList(words);
        this.noiseWords = new Vector<String>(Helper.transformList(temp, (String[])new String[]{"toUpperCase"}));
        this.lang = lang;
        this.addToMap();
    }

    public String getLang() {
        return this.lang;
    }

    private void addToMap() {
        if (map == null) {
            map = new HashMap<String, NoiseWord>();
        }
        map.put(this.lang.toUpperCase(), this);
    }

    public static NoiseWord fromLanguage(String lang) {
        if (lang == null) {
            return DEFAULT;
        }
        NoiseWord result = map.get(lang.toUpperCase());
        if (result == null) {
            result = DEFAULT;
        }
        return result;
    }

    public String removeLeadingNoiseWords(String s) {
        String result = s;
        boolean found = true;
        while (result.length() > 0 && found) {
            found = false;
            for (String noiseWord : this.noiseWords) {
                if (!result.toUpperCase().startsWith(noiseWord)) continue;
                result = result.substring(noiseWord.length());
                found = true;
            }
        }
        return result;
    }

    static {
        DEFAULT = ENGLISH;
    }
}

