/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.dpierron.calibre.datamodel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EBookFormat
implements Comparable<EBookFormat> {
    public static final EBookFormat EPUB = new EBookFormat("EPUB", "application/epub+zip");
    public static final EBookFormat TXT = new EBookFormat("TXT", "text/plain");
    public static final EBookFormat ZIP = new EBookFormat("ZIP", "application/zip");
    public static final EBookFormat PRC = new EBookFormat("PRC");
    public static final EBookFormat PDB = new EBookFormat("PDB", "application/pdb");
    public static final EBookFormat MOBI = new EBookFormat("MOBI", "application/x-mobipocket-ebook");
    public static final EBookFormat LRF = new EBookFormat("LRF");
    public static final EBookFormat LRX = new EBookFormat("LRX");
    public static final EBookFormat FB2 = new EBookFormat("FB2");
    public static final EBookFormat RAR = new EBookFormat("RAR", "application/rar");
    public static final EBookFormat PDF = new EBookFormat("PDF", "application/pdf");
    public static final EBookFormat RTF = new EBookFormat("RTF", "text/rtf");
    public static final EBookFormat LIT = new EBookFormat("LIT");
    public static final EBookFormat DOC = new EBookFormat("DOC");
    private static final EBookFormat[] values = new EBookFormat[]{EPUB, TXT, ZIP, PRC, PDB, MOBI, LRF, LRX, FB2, RAR, PDF, RTF, LIT, DOC};
    private static final String DEFAULTMIME = "application/other";
    private String mime;
    private String name;
    int priority = -1;

    private EBookFormat(String name, String mime) {
        this(name);
        this.mime = mime;
    }

    private EBookFormat(String name) {
        this.name = name;
    }

    private EBookFormat() {
        this(DEFAULTMIME);
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public String getMime() {
        return this.mime;
    }

    public static EBookFormat[] values() {
        return values;
    }

    public static EBookFormat fromFormat(String sFormat) {
        for (EBookFormat format : EBookFormat.values()) {
            if (!format.name.equalsIgnoreCase(sFormat)) continue;
            return format;
        }
        return null;
    }

    @Override
    public int compareTo(EBookFormat o) {
        if (o == null) {
            return -1;
        }
        if (this.getPriority() == o.getPriority()) {
            return 0;
        }
        return this.getPriority() > o.getPriority() ? -1 : 1;
    }

    public String toString() {
        return this.name;
    }
}

