/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.dpierron.calibre.datamodel;

import com.gmail.dpierron.calibre.cache.CachedFile;
import com.gmail.dpierron.calibre.datamodel.Book;
import com.gmail.dpierron.calibre.datamodel.EBookFormat;
import com.gmail.dpierron.tools.Helper;

public class EBookFile {
    EBookFormat format;
    String extension;
    String name;
    Book book;

    public EBookFile(String format, String name) {
        if (Helper.isNotNullOrEmpty((Object)format)) {
            this.format = EBookFormat.fromFormat(format);
            this.extension = "." + format.toLowerCase();
        }
        this.name = name;
    }

    public Book getBook() {
        return this.book;
    }

    public void setBook(Book value) {
        this.book = value;
    }

    public EBookFormat getFormat() {
        return this.format;
    }

    void setFormat(EBookFormat format) {
        this.format = format;
    }

    public String getName() {
        return this.name;
    }

    public String getExtension() {
        return this.extension;
    }

    void setName(String name) {
        this.name = name;
    }

    public CachedFile getFile() {
        return CachedFile.getCachedFile(this.getBook().getBookFolder(), this.getName() + this.getExtension());
    }

    public String toString() {
        return "" + this.getFormat() + " - " + this.getName();
    }
}

