/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.dpierron.calibre.datamodel;

import java.util.Date;
import java.util.GregorianCalendar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum DateRange {
    ONEDAY(1),
    ONEWEEK(7),
    FORTNIGHT(15),
    MONTH(30),
    TWOMONTHS(60),
    THREEMONTHS(90),
    SIXMONTHS(180),
    YEAR(360),
    MORE(-1);

    private int nbDays;

    private DateRange(int nbDays) {
        this.nbDays = nbDays;
    }

    private int getNbDays() {
        return this.nbDays;
    }

    public static DateRange valueOf(Date d) {
        if (d == null) {
            return MORE;
        }
        GregorianCalendar da1 = new GregorianCalendar();
        GregorianCalendar da2 = new GregorianCalendar();
        da1.setTime(d);
        long d1 = da1.getTime().getTime();
        long d2 = da2.getTime().getTime();
        long difMil = d2 - d1;
        long milPerDay = 86400000L;
        long days = difMil / milPerDay;
        for (DateRange range : DateRange.values()) {
            if ((long)range.getNbDays() < days) continue;
            return range;
        }
        return MORE;
    }
}

