/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.dpierron.calibre.datamodel;

import com.gmail.dpierron.calibre.database.Database;
import com.gmail.dpierron.calibre.datamodel.Author;
import com.gmail.dpierron.calibre.datamodel.Book;
import com.gmail.dpierron.calibre.datamodel.BookRating;
import com.gmail.dpierron.calibre.datamodel.DateRange;
import com.gmail.dpierron.calibre.datamodel.EBookFile;
import com.gmail.dpierron.calibre.datamodel.Publisher;
import com.gmail.dpierron.calibre.datamodel.Series;
import com.gmail.dpierron.calibre.datamodel.SplitableByLetter;
import com.gmail.dpierron.calibre.datamodel.Tag;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum DataModel {
    INSTANCE;

    Map<String, List<EBookFile>> mapOfFilesByBookId;
    Map<String, List<Publisher>> mapOfPublishersByBookId;
    Map<String, List<Author>> mapOfAuthorsByBookId;
    Map<String, List<Tag>> mapOfTagsByBookId;
    Map<String, List<Series>> mapOfSeriesByBookId;
    Map<String, List<String>> mapOfCommentsByBookId;
    List<Book> listOfBooks;
    Map<String, Book> mapOfBooks;
    List<Tag> listOfTags;
    Map<String, Tag> mapOfTags;
    Map<Tag, List<Book>> mapOfBooksByTag;
    List<Author> listOfAuthors;
    Map<String, Author> mapOfAuthors;
    Map<Author, List<Book>> mapOfBooksByAuthor;
    Map<Author, List<Series>> mapOfSeriesByAuthor;
    Map<Author, List<Book>> mapOfBooksNotInSerieByAuthor;
    List<Series> listOfSeries;
    Map<String, Series> mapOfSeries;
    Map<Series, List<Book>> mapOfBooksBySerie;
    Map<BookRating, List<Book>> mapOfBooksByRating;
    List<Publisher> listOfPublishers;
    Map<String, Publisher> mapOfPublishers;
    Map<Publisher, List<Book>> mapOfBooksByPublisher;

    public void reset() {
        this.mapOfFilesByBookId = null;
        this.mapOfPublishersByBookId = null;
        this.mapOfAuthorsByBookId = null;
        this.mapOfTagsByBookId = null;
        this.mapOfSeriesByBookId = null;
        this.mapOfCommentsByBookId = null;
        this.listOfBooks = null;
        this.mapOfBooks = null;
        this.listOfTags = null;
        this.mapOfTags = null;
        this.mapOfBooksByTag = null;
        this.listOfAuthors = null;
        this.mapOfAuthors = null;
        this.mapOfBooksByAuthor = null;
        this.mapOfSeriesByAuthor = null;
        this.mapOfBooksNotInSerieByAuthor = null;
        this.listOfSeries = null;
        this.mapOfSeries = null;
        this.mapOfBooksBySerie = null;
        this.mapOfBooksByRating = null;
        this.listOfPublishers = null;
        this.mapOfPublishers = null;
        this.mapOfBooksByPublisher = null;
    }

    public void preloadDataModel() {
        this.getListOfBooks();
        this.getMapOfFilesByBookId();
        this.getMapOfAuthorsByBookId();
        this.getMapOfTagsByBookId();
        this.getMapOfSeriesByBookId();
        this.getMapOfCommentsByBookId();
        this.getMapOfBooks();
        this.getListOfTags();
        this.getMapOfTags();
        this.getMapOfBooksByTag();
        this.getListOfAuthors();
        this.getMapOfAuthors();
        this.getMapOfBooksByAuthor();
        this.getMapOfSeriesByAuthor();
        this.getMapOfBooksNotInSeriesByAuthor();
        this.getListOfSeries();
        this.getMapOfSeries();
        this.getMapOfBooksBySerie();
        this.getMapOfBooksByRating();
    }

    public Map<String, List<EBookFile>> getMapOfFilesByBookId() {
        if (this.mapOfFilesByBookId == null) {
            this.mapOfFilesByBookId = Database.INSTANCE.listFilesByBookId();
        }
        return this.mapOfFilesByBookId;
    }

    public Map<String, List<Author>> getMapOfAuthorsByBookId() {
        if (this.mapOfAuthorsByBookId == null) {
            this.mapOfAuthorsByBookId = Database.INSTANCE.listAuthorsByBookId();
        }
        return this.mapOfAuthorsByBookId;
    }

    public Map<String, List<Publisher>> getMapOfPublishersByBookId() {
        if (this.mapOfPublishersByBookId == null) {
            this.mapOfPublishersByBookId = Database.INSTANCE.listPublishersByBookId();
        }
        return this.mapOfPublishersByBookId;
    }

    public Map<String, List<Tag>> getMapOfTagsByBookId() {
        if (this.mapOfTagsByBookId == null) {
            this.mapOfTagsByBookId = Database.INSTANCE.listTagsByBookId();
        }
        return this.mapOfTagsByBookId;
    }

    public Map<String, List<Series>> getMapOfSeriesByBookId() {
        if (this.mapOfSeriesByBookId == null) {
            this.mapOfSeriesByBookId = Database.INSTANCE.listSeriesByBookId();
        }
        return this.mapOfSeriesByBookId;
    }

    public Map<String, List<String>> getMapOfCommentsByBookId() {
        if (this.mapOfCommentsByBookId == null) {
            this.mapOfCommentsByBookId = Database.INSTANCE.listCommentsByBookId();
        }
        return this.mapOfCommentsByBookId;
    }

    public List<Book> getListOfBooks() {
        if (this.listOfBooks == null) {
            this.listOfBooks = Database.INSTANCE.listBooks();
        }
        return this.listOfBooks;
    }

    public Map<String, Book> getMapOfBooks() {
        if (this.mapOfBooks == null) {
            this.mapOfBooks = new HashMap<String, Book>();
            for (Book book : this.getListOfBooks()) {
                this.mapOfBooks.put(book.getId(), book);
            }
        }
        return this.mapOfBooks;
    }

    private List<Tag> getListOfTags() {
        if (this.listOfTags == null) {
            this.listOfTags = Database.INSTANCE.listTags();
        }
        return this.listOfTags;
    }

    public List<Tag> getListOfTags(List<Book> books) {
        if (books == null) {
            return this.getListOfTags();
        }
        Vector<Tag> result = new Vector<Tag>();
        for (Book book : books) {
            for (Tag tag : book.getTags()) {
                if (result.contains(tag)) continue;
                result.add(tag);
            }
        }
        return result;
    }

    public Map<String, Tag> getMapOfTags() {
        if (this.mapOfTags == null) {
            this.mapOfTags = new HashMap<String, Tag>();
            for (Tag tag : this.getListOfTags()) {
                this.mapOfTags.put(tag.getId(), tag);
            }
        }
        return this.mapOfTags;
    }

    public Map<Tag, List<Book>> getMapOfBooksByTag() {
        if (this.mapOfBooksByTag == null) {
            this.mapOfBooksByTag = new HashMap<Tag, List<Book>>();
            for (Book book : this.getListOfBooks()) {
                for (Tag tag : book.getTags()) {
                    List<Book> books = this.mapOfBooksByTag.get(tag);
                    if (books == null) {
                        books = new Vector<Book>();
                        this.mapOfBooksByTag.put(tag, books);
                    }
                    books.add(book);
                }
            }
        }
        return this.mapOfBooksByTag;
    }

    public List<Author> getListOfAuthors(List<Book> books) {
        if (books == null) {
            return this.getListOfAuthors();
        }
        Vector<Author> result = new Vector<Author>();
        for (Book book : books) {
            for (Author author : book.getAuthors()) {
                if (result.contains(author)) continue;
                result.add(author);
            }
        }
        return result;
    }

    public List<Author> getListOfAuthors() {
        if (this.listOfAuthors == null) {
            this.listOfAuthors = Database.INSTANCE.listAuthors();
        }
        return this.listOfAuthors;
    }

    public Map<String, Author> getMapOfAuthors() {
        if (this.mapOfAuthors == null) {
            this.mapOfAuthors = new HashMap<String, Author>();
            for (Author author : this.getListOfAuthors()) {
                this.mapOfAuthors.put(author.getId(), author);
            }
        }
        return this.mapOfAuthors;
    }

    public Map<Author, List<Book>> getMapOfBooksByAuthor() {
        if (this.mapOfBooksByAuthor == null) {
            this.mapOfBooksByAuthor = new HashMap<Author, List<Book>>();
            for (Book book : this.getListOfBooks()) {
                for (Author author : book.getAuthors()) {
                    List<Book> books = this.mapOfBooksByAuthor.get(author);
                    if (books == null) {
                        books = new Vector<Book>();
                        this.mapOfBooksByAuthor.put(author, books);
                    }
                    books.add(book);
                }
            }
        }
        return this.mapOfBooksByAuthor;
    }

    public Map<Author, List<Series>> getMapOfSeriesByAuthor() {
        if (this.mapOfSeriesByAuthor == null) {
            this.computeMapOfSeriesByAuthor();
        }
        return this.mapOfSeriesByAuthor;
    }

    public Map<Author, List<Book>> getMapOfBooksNotInSeriesByAuthor() {
        if (this.mapOfBooksNotInSerieByAuthor == null) {
            this.computeMapOfSeriesByAuthor();
        }
        return this.mapOfBooksNotInSerieByAuthor;
    }

    private void computeMapOfSeriesByAuthor() {
        this.mapOfSeriesByAuthor = new HashMap<Author, List<Series>>();
        this.mapOfBooksNotInSerieByAuthor = new HashMap<Author, List<Book>>();
        for (Book book : this.getListOfBooks()) {
            for (Author author : book.getAuthors()) {
                Series serie = book.getSeries();
                if (serie != null) {
                    List<Series> series = this.mapOfSeriesByAuthor.get(author);
                    if (series == null) {
                        series = new Vector<Series>();
                        this.mapOfSeriesByAuthor.put(author, series);
                    }
                    if (series.contains(serie)) continue;
                    series.add(serie);
                    continue;
                }
                List<Book> books = this.mapOfBooksNotInSerieByAuthor.get(author);
                if (books == null) {
                    books = new Vector<Book>();
                    this.mapOfBooksNotInSerieByAuthor.put(author, books);
                }
                if (books.contains(book)) continue;
                books.add(book);
            }
        }
    }

    public List<Series> getListOfSeries() {
        if (this.listOfSeries == null) {
            this.listOfSeries = Database.INSTANCE.listSeries();
        }
        return this.listOfSeries;
    }

    public Map<String, Series> getMapOfSeries() {
        if (this.mapOfSeries == null) {
            this.mapOfSeries = new HashMap<String, Series>();
            for (Series serie : this.getListOfSeries()) {
                this.mapOfSeries.put(serie.getId(), serie);
            }
        }
        return this.mapOfSeries;
    }

    public Map<Series, List<Book>> getMapOfBooksBySerie() {
        if (this.mapOfBooksBySerie == null) {
            this.mapOfBooksBySerie = new HashMap<Series, List<Book>>();
            for (Book book : this.getListOfBooks()) {
                List<Book> books = this.mapOfBooksBySerie.get(book.getSeries());
                if (books == null) {
                    books = new Vector<Book>();
                    Series serie = book.getSeries();
                    if (serie != null) {
                        this.mapOfBooksBySerie.put(serie, books);
                    }
                }
                books.add(book);
            }
        }
        return this.mapOfBooksBySerie;
    }

    public Map<BookRating, List<Book>> getMapOfBooksByRating() {
        if (this.mapOfBooksByRating == null) {
            this.mapOfBooksByRating = new HashMap<BookRating, List<Book>>();
            for (Book book : this.getListOfBooks()) {
                List<Book> books = this.mapOfBooksByRating.get((Object)book.getRating());
                if (books == null) {
                    books = new Vector<Book>();
                    BookRating rating = book.getRating();
                    if (rating != null) {
                        this.mapOfBooksByRating.put(rating, books);
                    }
                }
                books.add(book);
            }
        }
        return this.mapOfBooksByRating;
    }

    public List<Publisher> getListOfPublishers() {
        if (this.listOfPublishers == null) {
            this.listOfPublishers = Database.INSTANCE.listPublishers();
        }
        return this.listOfPublishers;
    }

    public Map<String, Publisher> getMapOfPublishers() {
        if (this.mapOfPublishers == null) {
            this.mapOfPublishers = new HashMap<String, Publisher>();
            for (Publisher publisher : this.getListOfPublishers()) {
                this.mapOfPublishers.put(publisher.getId(), publisher);
            }
        }
        return this.mapOfPublishers;
    }

    public Map<Publisher, List<Book>> getMapOfBooksByPublisher() {
        if (this.mapOfBooksByPublisher == null) {
            this.mapOfBooksByPublisher = new HashMap<Publisher, List<Book>>();
            for (Book book : this.getListOfBooks()) {
                Publisher publisher = book.getPublisher();
                List<Book> books = this.mapOfBooksByPublisher.get(publisher);
                if (books == null) {
                    books = new Vector<Book>();
                    this.mapOfBooksByPublisher.put(publisher, books);
                }
                books.add(book);
            }
        }
        return this.mapOfBooksByPublisher;
    }

    public static Map<String, List<Book>> splitBooksByLetter(List<Book> books, final String bookLanguageTag) {
        Comparator<Book> comparator = new Comparator<Book>(){

            @Override
            public int compare(Book o1, Book o2) {
                String title1 = o1 == null ? "" : o1.getTitleForSort(bookLanguageTag);
                String title2 = o2 == null ? "" : o2.getTitleForSort(bookLanguageTag);
                return title1.compareTo(title2);
            }
        };
        return DataModel.splitByLetter(books, comparator, bookLanguageTag);
    }

    public static Map<String, List<Author>> splitAuthorsByLetter(List<Author> authors) {
        Comparator<Author> comparator = new Comparator<Author>(){

            @Override
            public int compare(Author o1, Author o2) {
                String author1 = o1 == null ? "" : o1.getNameForSort();
                String author2 = o2 == null ? "" : o2.getNameForSort();
                return author1.compareTo(author2);
            }
        };
        return DataModel.splitByLetter(authors, comparator);
    }

    public static Map<String, List<Series>> splitSeriesByLetter(List<Series> series) {
        Comparator<Series> comparator = new Comparator<Series>(){

            @Override
            public int compare(Series o1, Series o2) {
                String serie1 = o1 == null ? "" : o1.getName();
                String serie2 = o2 == null ? "" : o2.getName();
                return serie1.compareTo(serie2);
            }
        };
        return DataModel.splitByLetter(series, comparator);
    }

    public static Map<String, List<Tag>> splitTagsByLetter(List<Tag> tags) {
        Comparator<Tag> comparator = new Comparator<Tag>(){

            @Override
            public int compare(Tag o1, Tag o2) {
                String tag1 = o1 == null ? "" : o1.getName();
                String tag2 = o2 == null ? "" : o2.getName();
                return tag1.compareTo(tag2);
            }
        };
        return DataModel.splitByLetter(tags, comparator);
    }

    public static Map<DateRange, List<Book>> splitBooksByDate(List<Book> books) {
        HashMap<DateRange, List<Book>> splitByDate = new HashMap<DateRange, List<Book>>();
        for (Book book : books) {
            DateRange range = DateRange.valueOf(book.getTimestamp());
            Vector<Book> list = (Vector<Book>)splitByDate.get((Object)range);
            if (list == null) {
                list = new Vector<Book>();
                splitByDate.put(range, list);
            }
            list.add(book);
        }
        return splitByDate;
    }

    private static <T extends SplitableByLetter> Map<String, List<T>> splitByLetter(List<T> objects, Comparator<T> comparator) {
        return DataModel.splitByLetter(objects, comparator, null);
    }

    private static <T extends SplitableByLetter> Map<String, List<T>> splitByLetter(List<T> objects, Comparator<T> comparator, Object options) {
        String LETTERS = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        HashMap<String, List<T>> splitByLetter = new HashMap<String, List<T>>();
        for (SplitableByLetter object : objects) {
            Vector<SplitableByLetter> list;
            if (object == null) continue;
            String firstLetter = "";
            String string = object.getTitleToSplitByLetter(options);
            if (string == null) {
                string = "";
            } else {
                firstLetter = string.substring(0, 1).toUpperCase(Locale.ENGLISH);
            }
            if (!"0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ".contains(firstLetter)) {
                firstLetter = "_";
            }
            if ((list = (Vector<SplitableByLetter>)splitByLetter.get(firstLetter)) == null) {
                list = new Vector<SplitableByLetter>();
                splitByLetter.put(firstLetter, list);
            }
            list.add(object);
        }
        for (String letter : splitByLetter.keySet()) {
            List objectsInThisLetter = (List)splitByLetter.get(letter);
            Collections.sort(objectsInThisLetter, comparator);
        }
        return splitByLetter;
    }
}

