/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.dpierron.calibre.datamodel;

import com.gmail.dpierron.calibre.cache.CachedFile;
import com.gmail.dpierron.calibre.configuration.Configuration;
import com.gmail.dpierron.calibre.datamodel.Author;
import com.gmail.dpierron.calibre.datamodel.BookRating;
import com.gmail.dpierron.calibre.datamodel.DataModel;
import com.gmail.dpierron.calibre.datamodel.EBookFile;
import com.gmail.dpierron.calibre.datamodel.EBookFormat;
import com.gmail.dpierron.calibre.datamodel.NoiseWord;
import com.gmail.dpierron.calibre.datamodel.Publisher;
import com.gmail.dpierron.calibre.datamodel.Series;
import com.gmail.dpierron.calibre.datamodel.SplitableByLetter;
import com.gmail.dpierron.calibre.datamodel.Tag;
import com.gmail.dpierron.tools.Helper;
import java.io.File;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Book
implements SplitableByLetter {
    private static final DateFormat TIMESTAMP_INTITLE_FORMAT = new SimpleDateFormat("dd/MM");
    private File bookFolder;
    private String id;
    private String uuid;
    private String title;
    private String titleForSort;
    private String titleWithSerieNumber;
    private String titleWithTimestamp;
    private String titleWithRating;
    private String path;
    private String comment;
    private String shortComment;
    private Integer serieIndex;
    private Date timestamp;
    private Date publicationDate;
    private String isbn;
    private List<Author> authors;
    private String listOfAuthors;
    private String authorSort;
    private Publisher publisher;
    private Series series;
    private List<Tag> tags;
    private List<EBookFile> files;
    private boolean filesSorted = false;
    private EBookFile preferredFile;
    private EBookFile epubFile;
    private boolean epubFileComputed = false;
    private boolean preferredFileComputed = false;
    private String epubFileName;
    private long latestFileModifiedDate = -1L;
    private BookRating rating;
    private String bookLanguage;

    public Book(String id, String uuid, String title, String path, Integer serieIndex, Date timestamp, Date publicationDate, String isbn, String authorSort, BookRating rating) {
        this.id = id;
        this.uuid = uuid;
        this.setTitle(title);
        this.path = path;
        this.serieIndex = serieIndex;
        this.timestamp = timestamp;
        this.publicationDate = publicationDate;
        this.tags = new Vector<Tag>();
        this.files = new Vector<EBookFile>();
        this.authors = new Vector<Author>();
        this.isbn = isbn;
        this.authorSort = authorSort;
        this.rating = rating;
    }

    public String getId() {
        return this.id;
    }

    public String getUuid() {
        return this.uuid;
    }

    private void setTitle(String value) {
        this.titleForSort = null;
        this.titleWithRating = null;
        this.titleWithSerieNumber = null;
        this.titleWithTimestamp = null;
        this.title = value;
        if (Helper.isNotNullOrEmpty((Object)this.title)) {
            this.title = this.title.trim();
            this.title = this.title.substring(0, 1).toUpperCase() + this.title.substring(1);
        }
    }

    public String getTitle() {
        return this.title;
    }

    public String getTitleForSort(String bookTag) {
        if (this.titleForSort == null) {
            this.titleForSort = NoiseWord.fromLanguage(this.getBookLanguage(bookTag)).removeLeadingNoiseWords(this.getTitle());
        }
        return this.titleForSort;
    }

    public String getBookLanguage(String bookLanguageTag) {
        if (this.bookLanguage == null) {
            this.bookLanguage = NoiseWord.DEFAULT.getLang();
            bookLanguageTag = bookLanguageTag.toUpperCase();
            List<Tag> tags = DataModel.INSTANCE.getMapOfTagsByBookId().get(this.getId());
            if (Helper.isNotNullOrEmpty(tags)) {
                for (Tag tag : tags) {
                    if (!tag.getName().toUpperCase().startsWith(bookLanguageTag)) continue;
                    this.bookLanguage = tag.getName().substring(bookLanguageTag.length());
                    break;
                }
            }
        }
        return this.bookLanguage;
    }

    public String getIsbn() {
        return this.isbn;
    }

    public String getTitleWithSerieNumber() {
        if (this.titleWithSerieNumber == null) {
            this.titleWithSerieNumber = this.getSerieIndex() + " - " + this.title;
        }
        return this.titleWithSerieNumber;
    }

    public String getTitleWithTimestamp() {
        if (this.titleWithTimestamp == null) {
            this.titleWithTimestamp = this.getTimestamp() != null ? TIMESTAMP_INTITLE_FORMAT.format(this.getTimestamp()) + " - " + this.title : this.title;
        }
        return this.titleWithTimestamp;
    }

    public String getTitleWithRating(String message, String ratingText) {
        if (this.titleWithRating == null) {
            this.titleWithRating = this.getRating() != BookRating.NOTRATED ? MessageFormat.format(message, this.getTitle(), ratingText) : this.title;
        }
        return this.titleWithRating;
    }

    public String getPath() {
        return this.path;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String value) {
        this.shortComment = null;
        this.comment = value != null ? (value.toUpperCase(Locale.ENGLISH).startsWith("SUMMARY:") ? value.substring(8) : (value.toUpperCase(Locale.ENGLISH).startsWith("SUMMARY") ? value.substring(6) : value)) : null;
    }

    public String getShortComment(int maxLength) {
        if (this.shortComment == null) {
            this.shortComment = Helper.shorten((String)this.getComment(), (int)maxLength);
        }
        return this.shortComment;
    }

    public Integer getSerieIndex() {
        return this.serieIndex;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public Date getPublicationDate() {
        return this.publicationDate;
    }

    public boolean hasAuthor() {
        return Helper.isNotNullOrEmpty(this.getAuthors());
    }

    public boolean hasSingleAuthor() {
        return Helper.isNotNullOrEmpty(this.getAuthors()) && this.getAuthors().size() == 1;
    }

    public List<Author> getAuthors() {
        return this.authors;
    }

    public String getListOfAuthors() {
        if (this.listOfAuthors == null) {
            this.listOfAuthors = Helper.concatenateList((String)" & ", this.getAuthors(), (String[])new String[]{"getName"});
        }
        return this.listOfAuthors;
    }

    public Author getMainAuthor() {
        if (this.getAuthors() == null || this.getAuthors().size() == 0) {
            return null;
        }
        return this.getAuthors().get(0);
    }

    public String getAuthorSort() {
        return this.authorSort;
    }

    public void setAuthorSort(String authorSort) {
        this.authorSort = authorSort;
    }

    public Publisher getPublisher() {
        return this.publisher;
    }

    public void setPublisher(Publisher publisher) {
        this.publisher = publisher;
    }

    public Series getSeries() {
        return this.series;
    }

    public void setSeries(Series value) {
        this.series = value;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public List<EBookFile> getFiles() {
        if (!this.filesSorted) {
            if (this.files != null && this.files.size() > 1) {
                Collections.sort(this.files, new Comparator<EBookFile>(){

                    @Override
                    public int compare(EBookFile o1, EBookFile o2) {
                        if (o1 == null) {
                            if (o2 == null) {
                                return 0;
                            }
                            return 1;
                        }
                        if (o2 == null) {
                            if (o1 == null) {
                                return 0;
                            }
                            return -1;
                        }
                        return Helper.checkedCompare((Comparable)o1.getFormat(), (Comparable)o2.getFormat());
                    }
                });
            }
            this.filesSorted = true;
        }
        return this.files;
    }

    public void removeFile(EBookFile file) {
        this.files.remove(file);
        this.epubFileComputed = false;
        this.preferredFileComputed = false;
        this.epubFile = null;
        this.preferredFile = null;
        this.latestFileModifiedDate = -1L;
        this.filesSorted = false;
    }

    public void addFile(EBookFile file) {
        this.files.add(file);
        this.epubFileComputed = false;
        this.preferredFileComputed = false;
        this.epubFile = null;
        this.preferredFile = null;
        this.latestFileModifiedDate = -1L;
        this.filesSorted = false;
    }

    public EBookFile getPreferredFile() {
        if (!this.preferredFileComputed) {
            for (EBookFile file : this.getFiles()) {
                if (this.preferredFile != null && file.getFormat().getPriority() <= this.preferredFile.getFormat().getPriority()) continue;
                this.preferredFile = file;
            }
            this.preferredFileComputed = true;
        }
        return this.preferredFile;
    }

    public void addAuthor(Author author) {
        this.listOfAuthors = null;
        if (this.authors == null) {
            this.authors = new Vector<Author>();
        }
        if (!this.authors.contains(author)) {
            this.authors.add(author);
        }
    }

    public String toString() {
        return this.getId() + " - " + this.getTitle();
    }

    public String toDetailedString() {
        return this.getId() + " - " + this.getMainAuthor().getName() + " - " + this.getTitle() + " - " + Helper.concatenateList(this.getTags()) + " - " + this.getPath();
    }

    public File getBookFolder() {
        if (this.bookFolder == null) {
            File calibreLibraryFolder = Configuration.instance().getDatabaseFolder();
            this.bookFolder = new File(calibreLibraryFolder, this.getPath());
        }
        return this.bookFolder;
    }

    public String getEpubFilename() {
        if (!this.epubFileComputed) {
            this.getEpubFile();
        }
        return this.epubFileName;
    }

    public EBookFile getEpubFile() {
        if (!this.epubFileComputed) {
            for (EBookFile file : this.getFiles()) {
                if (file.getFormat() != EBookFormat.EPUB) continue;
                this.epubFile = file;
                this.epubFileName = this.epubFile.getName() + this.epubFile.getExtension();
            }
            this.epubFile = null;
            this.epubFileComputed = true;
            this.epubFileName = null;
        }
        return this.epubFile;
    }

    public boolean doesEpubFileExist() {
        EBookFile file = this.getEpubFile();
        if (file == null) {
            return false;
        }
        CachedFile f = file.getFile();
        return f != null && ((File)f).exists();
    }

    public long getLatestFileModifiedDate() {
        if (this.latestFileModifiedDate == -1L) {
            this.latestFileModifiedDate = 0L;
            for (EBookFile file : this.getFiles()) {
                long m;
                CachedFile f = file.getFile();
                if (!((File)f).exists() || (m = ((File)f).lastModified()) <= this.latestFileModifiedDate) continue;
                this.latestFileModifiedDate = m;
            }
        }
        return this.latestFileModifiedDate;
    }

    public BookRating getRating() {
        return this.rating;
    }

    @Override
    public String getTitleToSplitByLetter(Object options) {
        return this.getTitleForSort((String)options);
    }

    public Book copy() {
        Book result = new Book(this.id, this.uuid, this.title, this.path, this.serieIndex, this.timestamp, this.publicationDate, this.isbn, this.authorSort, this.rating);
        result.setComment(this.getComment());
        result.setSeries(this.getSeries());
        result.setPublisher(this.getPublisher());
        result.files = new Vector<EBookFile>(this.getFiles());
        result.tags = new Vector<Tag>(this.getTags());
        result.authors = new Vector<Author>(this.getAuthors());
        return result;
    }
}

