/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.dpierron.calibre.datamodel;

import com.gmail.dpierron.calibre.datamodel.Book;
import com.gmail.dpierron.calibre.datamodel.DataModel;
import com.gmail.dpierron.calibre.datamodel.SplitableByLetter;
import com.gmail.dpierron.tools.Helper;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Author
implements SplitableByLetter,
Comparable<Author> {
    private String id;
    private String name;
    private String sort;
    private String guessedLastName;
    private String nameForSort;

    public Author(String id, String name, String sort) {
        this.id = id;
        this.setName(name);
    }

    public void setName(String name) {
        this.name = name.replace('|', ',');
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getLastName() {
        if (this.guessedLastName == null) {
            String sortedName = this.getSort();
            if (Helper.isNotNullOrEmpty((Object)this.guessedLastName)) {
                return this.guessedLastName;
            }
            this.guessedLastName = sortedName;
            if (Helper.isNotNullOrEmpty((Object)this.getSort())) {
                int posOfSpace = this.getSort().indexOf(44);
                if (posOfSpace >= 0) {
                    this.guessedLastName = this.getSort().substring(0, posOfSpace);
                }
            } else {
                this.guessedLastName = this.name;
            }
        }
        return this.guessedLastName;
    }

    public String getNameForSort() {
        if (Helper.isNullOrEmpty((Object)this.nameForSort)) {
            this.nameForSort = this.getLastName().replaceAll(" ", "").toUpperCase();
        }
        return this.nameForSort;
    }

    public String getSort() {
        if (Helper.isNullOrEmpty((Object)this.sort)) {
            this.sort = this.computeSort();
        }
        return this.sort;
    }

    private String computeSort() {
        int posOfSpace;
        List<Book> books = DataModel.INSTANCE.getMapOfBooksByAuthor().get(this);
        if (books != null) {
            for (Book book : books) {
                String authorSort;
                if (!book.hasSingleAuthor() || !Helper.isNotNullOrEmpty((Object)(authorSort = book.getAuthorSort())) || !authorSort.contains(",")) continue;
                return authorSort;
            }
        }
        if ((posOfSpace = this.name.indexOf(44)) >= 0) {
            this.guessedLastName = this.name.substring(0, posOfSpace);
            return this.name;
        }
        List words = Helper.tokenize((String)this.name, (String)" ");
        if (words.size() == 1) {
            return (String)words.get(0);
        }
        this.guessedLastName = (String)words.get(words.size() - 1);
        words.remove(words.size() - 1);
        String result = this.guessedLastName + ", " + Helper.concatenateList((String)" ", (Collection)words);
        return result;
    }

    public String toString() {
        return this.getId() + " - " + this.getName();
    }

    @Override
    public String getTitleToSplitByLetter(Object options) {
        return this.getLastName();
    }

    @Override
    public int compareTo(Author o) {
        if (o == null) {
            return 1;
        }
        int i = Helper.trueStringCompare((Object)this.getSort(), (Object)o.getSort());
        return i;
    }
}

