/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.dpierron.calibre.database;

import com.gmail.dpierron.calibre.configuration.Configuration;
import com.gmail.dpierron.calibre.database.Database;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum DatabaseManager {
    INSTANCE;

    private static final Logger logger;
    private Connection connection;

    public Connection getConnection() {
        if (this.connection == null) {
            this.initConnection();
        }
        return this.connection;
    }

    public boolean databaseExists() {
        File database = new File(Configuration.instance().getDatabaseFolder(), "metadata.db");
        if (!database.exists()) {
            return false;
        }
        return Database.INSTANCE.test();
    }

    private Connection initConnection() {
        try {
            Class.forName("org.sqlite.JDBC");
            File database = new File(Configuration.instance().getDatabaseFolder(), "metadata.db");
            String url = database.toURI().getPath();
            this.connection = DriverManager.getConnection("jdbc:sqlite:" + url);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)e);
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return null;
    }

    static {
        logger = Logger.getLogger(DatabaseManager.class);
    }
}

