/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.dpierron.calibre.database;

import com.gmail.dpierron.calibre.database.DatabaseRequest;
import com.gmail.dpierron.calibre.datamodel.Author;
import com.gmail.dpierron.calibre.datamodel.Book;
import com.gmail.dpierron.calibre.datamodel.BookRating;
import com.gmail.dpierron.calibre.datamodel.DataModel;
import com.gmail.dpierron.calibre.datamodel.EBookFile;
import com.gmail.dpierron.calibre.datamodel.Publisher;
import com.gmail.dpierron.calibre.datamodel.Series;
import com.gmail.dpierron.calibre.datamodel.Tag;
import com.gmail.dpierron.tools.Helper;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Database {
    INSTANCE;

    private static final Logger logger;
    private static final DateFormat SQLITE_TIMESTAMP_FORMAT;

    public List<Tag> listTags() {
        Vector<Tag> result = new Vector<Tag>();
        PreparedStatement statement = DatabaseRequest.ALL_TAGS.getStatement();
        try {
            ResultSet set = statement.executeQuery();
            while (set.next()) {
                result.add(new Tag(set.getString("id"), set.getString("name")));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return result;
    }

    public boolean test() {
        PreparedStatement statement = DatabaseRequest.TEST.getStatement();
        try {
            statement.executeQuery();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public List<Book> listBooks() {
        Vector<Book> result = new Vector<Book>();
        PreparedStatement statement = DatabaseRequest.ALL_BOOKS.getStatement();
        try {
            ResultSet set = statement.executeQuery();
            while (set.next()) {
                List<EBookFile> files;
                List<Tag> tags;
                List<String> comments;
                List<Series> series;
                List<Publisher> publishers;
                String bookId = set.getString("book_id");
                String uuid = set.getString("uuid");
                Date timestamp = null;
                try {
                    timestamp = SQLITE_TIMESTAMP_FORMAT.parse(set.getString("book_timestamp"));
                }
                catch (ParseException e) {
                    // empty catch block
                }
                Date publicationDate = null;
                try {
                    publicationDate = SQLITE_TIMESTAMP_FORMAT.parse(set.getString("book_pubdate"));
                }
                catch (ParseException e) {
                    // empty catch block
                }
                String title = set.getString("book_title");
                String path = set.getString("book_path");
                int index = set.getInt("serie_index");
                String isbn = set.getString("isbn");
                String authorSort = set.getString("author_sort");
                int iRating = set.getInt("rating");
                BookRating rating = BookRating.fromValue(iRating);
                Book book = new Book(bookId, uuid, title, path, index, timestamp, publicationDate, isbn, authorSort, rating);
                List<Author> authors = DataModel.INSTANCE.getMapOfAuthorsByBookId().get(bookId);
                if (Helper.isNotNullOrEmpty(authors)) {
                    for (Author author : authors) {
                        book.addAuthor(author);
                    }
                }
                if (Helper.isNotNullOrEmpty(publishers = DataModel.INSTANCE.getMapOfPublishersByBookId().get(bookId))) {
                    book.setPublisher(publishers.get(0));
                }
                if (Helper.isNotNullOrEmpty(series = DataModel.INSTANCE.getMapOfSeriesByBookId().get(bookId))) {
                    book.setSeries(series.get(0));
                }
                if (Helper.isNotNullOrEmpty(comments = DataModel.INSTANCE.getMapOfCommentsByBookId().get(bookId))) {
                    book.setComment(comments.get(0));
                }
                if (Helper.isNotNullOrEmpty(tags = DataModel.INSTANCE.getMapOfTagsByBookId().get(bookId))) {
                    book.getTags().addAll(tags);
                }
                if (Helper.isNotNullOrEmpty(files = DataModel.INSTANCE.getMapOfFilesByBookId().get(bookId))) {
                    for (EBookFile file : files) {
                        file.setBook(book);
                        book.addFile(file);
                    }
                }
                result.add(book);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return result;
    }

    public List<Author> listAuthors() {
        Vector<Author> result = new Vector<Author>();
        Vector<String> ids = new Vector<String>();
        PreparedStatement statement = DatabaseRequest.ALL_AUTHORS.getStatement();
        try {
            ResultSet set = statement.executeQuery();
            while (set.next()) {
                String id = set.getString("id");
                if (ids.contains(id)) continue;
                ids.add(id);
                result.add(new Author(id, set.getString("name"), set.getString("sort")));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return result;
    }

    public List<Publisher> listPublishers() {
        Vector<Publisher> result = new Vector<Publisher>();
        Vector<String> ids = new Vector<String>();
        PreparedStatement statement = DatabaseRequest.ALL_PUBLISHERS.getStatement();
        try {
            ResultSet set = statement.executeQuery();
            while (set.next()) {
                String id = set.getString("id");
                if (ids.contains(id)) continue;
                ids.add(id);
                result.add(new Publisher(id, set.getString("name"), set.getString("sort")));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return result;
    }

    public List<Series> listSeries() {
        Vector<Series> result = new Vector<Series>();
        Vector<String> ids = new Vector<String>();
        PreparedStatement statement = DatabaseRequest.ALL_SERIES.getStatement();
        try {
            ResultSet set = statement.executeQuery();
            while (set.next()) {
                String id = set.getString("id");
                if (ids.contains(id)) continue;
                ids.add(id);
                result.add(new Series(id, set.getString("name"), set.getString("serie_sort")));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return result;
    }

    public Map<String, List<EBookFile>> listFilesByBookId() {
        HashMap<String, List<EBookFile>> result = new HashMap<String, List<EBookFile>>();
        PreparedStatement statement = DatabaseRequest.BOOKS_DATA.getStatement();
        try {
            ResultSet set = statement.executeQuery();
            while (set.next()) {
                String id = set.getString("book");
                String format = set.getString("format");
                String name = set.getString("name");
                Vector<EBookFile> files = (Vector<EBookFile>)result.get(id);
                if (files == null) {
                    files = new Vector<EBookFile>();
                    result.put(id, files);
                }
                files.add(new EBookFile(format, name));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return result;
    }

    public Map<String, List<Author>> listAuthorsByBookId() {
        HashMap<String, List<Author>> result = new HashMap<String, List<Author>>();
        PreparedStatement statement = DatabaseRequest.BOOKS_AUTHORS.getStatement();
        try {
            ResultSet set = statement.executeQuery();
            while (set.next()) {
                Author author;
                String bookId = set.getString("book");
                String authorId = set.getString("author");
                Vector<Author> authors = (Vector<Author>)result.get(bookId);
                if (authors == null) {
                    authors = new Vector<Author>();
                    result.put(bookId, authors);
                }
                if ((author = DataModel.INSTANCE.getMapOfAuthors().get(authorId)) != null) {
                    authors.add(author);
                    continue;
                }
                logger.warn((Object)("cannot find author #" + authorId));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return result;
    }

    public Map<String, List<Publisher>> listPublishersByBookId() {
        HashMap<String, List<Publisher>> result = new HashMap<String, List<Publisher>>();
        PreparedStatement statement = DatabaseRequest.BOOKS_PUBLISHERS.getStatement();
        try {
            ResultSet set = statement.executeQuery();
            while (set.next()) {
                Publisher publisher;
                String bookId = set.getString("book");
                String publisherId = set.getString("publisher");
                Vector<Publisher> publishers = (Vector<Publisher>)result.get(bookId);
                if (publishers == null) {
                    publishers = new Vector<Publisher>();
                    result.put(bookId, publishers);
                }
                if ((publisher = DataModel.INSTANCE.getMapOfPublishers().get(publisherId)) != null) {
                    publishers.add(publisher);
                    continue;
                }
                logger.warn((Object)("cannot find publisher #" + publisherId));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return result;
    }

    public Map<String, List<Tag>> listTagsByBookId() {
        HashMap<String, List<Tag>> result = new HashMap<String, List<Tag>>();
        PreparedStatement statement = DatabaseRequest.BOOKS_TAGS.getStatement();
        try {
            ResultSet set = statement.executeQuery();
            while (set.next()) {
                Tag tag;
                String bookId = set.getString("book");
                String tagId = set.getString("tag");
                Vector<Tag> tags = (Vector<Tag>)result.get(bookId);
                if (tags == null) {
                    tags = new Vector<Tag>();
                    result.put(bookId, tags);
                }
                if ((tag = DataModel.INSTANCE.getMapOfTags().get(tagId)) != null) {
                    tags.add(tag);
                    continue;
                }
                logger.warn((Object)("cannot find tag #" + tagId));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return result;
    }

    public Map<String, List<Series>> listSeriesByBookId() {
        HashMap<String, List<Series>> result = new HashMap<String, List<Series>>();
        PreparedStatement statement = DatabaseRequest.BOOKS_SERIES.getStatement();
        try {
            ResultSet set = statement.executeQuery();
            while (set.next()) {
                Series serie;
                String bookId = set.getString("book");
                String serieId = set.getString("series");
                Vector<Series> series = (Vector<Series>)result.get(bookId);
                if (series == null) {
                    series = new Vector<Series>();
                    result.put(bookId, series);
                }
                if ((serie = DataModel.INSTANCE.getMapOfSeries().get(serieId)) != null) {
                    series.add(serie);
                    continue;
                }
                logger.warn((Object)("cannot find serie #" + serieId));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return result;
    }

    public Map<String, List<String>> listCommentsByBookId() {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        PreparedStatement statement = DatabaseRequest.BOOKS_COMMENTS.getStatement();
        try {
            ResultSet set = statement.executeQuery();
            while (set.next()) {
                String id = set.getString("book");
                String text = set.getString("text");
                Vector<String> comments = (Vector<String>)result.get(id);
                if (comments == null) {
                    comments = new Vector<String>();
                    result.put(id, comments);
                }
                comments.add(text);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return result;
    }

    static {
        logger = Logger.getLogger(Database.class);
        SQLITE_TIMESTAMP_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    }
}

