/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.dpierron.calibre.cache;

import com.gmail.dpierron.calibre.cache.CachedFileManager;
import java.io.File;
import org.apache.log4j.Logger;

public class CachedFile
extends File {
    private static final Logger logger = Logger.getLogger(CachedFile.class);
    private boolean exists;
    private boolean existsChecked = false;
    private long lastModified;
    private boolean lastModifiedChecked = false;
    private boolean isDirectory;
    private boolean isDirectoryChecked = false;
    private long length;
    private boolean lengthChecked = false;

    public CachedFile(String pathname) {
        super(pathname);
        this.preload();
    }

    protected void preload() {
        if (logger.isTraceEnabled()) {
            logger.debug((Object)("preloading cache for " + this.getAbsolutePath()));
        }
        this.setExists(super.isFile());
        if (this.exists) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"... as standard file");
            }
            this.setLastModified(super.lastModified());
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"... as directory file");
            }
            this.setExists(super.isDirectory());
            this.setIsDirectory(this.exists);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("... exists=" + this.exists));
        }
    }

    public long lastModified() {
        if (!this.lastModifiedChecked) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("checking lastModified for " + this.getAbsolutePath()));
            }
            this.lastModified = super.lastModified();
            this.lastModifiedChecked = true;
        } else if (logger.isTraceEnabled()) {
            logger.trace((Object)("skipping check lastModified for " + this.getAbsolutePath()));
        }
        return this.lastModified;
    }

    public boolean setLastModified(long value) {
        this.lastModified = value;
        this.lastModifiedChecked = true;
        return true;
    }

    public long length() {
        if (!this.lengthChecked) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("checking length for " + this.getAbsolutePath()));
            }
            this.length = super.length();
            this.lengthChecked = true;
        } else if (logger.isTraceEnabled()) {
            logger.trace((Object)("skipping check length for " + this.getAbsolutePath()));
        }
        return this.length;
    }

    public boolean setLength(long value) {
        this.length = value;
        this.lengthChecked = true;
        return true;
    }

    public boolean exists() {
        if (!this.existsChecked) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("checking exists for " + this.getAbsolutePath()));
            }
            this.exists = super.exists();
            this.existsChecked = true;
        } else if (logger.isTraceEnabled()) {
            logger.trace((Object)("skipping check exists for " + this.getAbsolutePath()));
        }
        return this.exists;
    }

    public boolean setExists(boolean value) {
        this.exists = value;
        this.existsChecked = true;
        return true;
    }

    public boolean isDirectory() {
        if (!this.isDirectoryChecked) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("checking isDirectory for " + this.getAbsolutePath()));
            }
            this.isDirectory = super.isDirectory();
            this.isDirectoryChecked = true;
        } else if (logger.isTraceEnabled()) {
            logger.trace((Object)("skipping check isDirectory for " + this.getAbsolutePath()));
        }
        return this.isDirectory;
    }

    public boolean setIsDirectory(boolean value) {
        this.isDirectory = value;
        this.isDirectoryChecked = true;
        return true;
    }

    public static CachedFile getCachedFile(File parent, String child) {
        String absolutePath = new File(parent, child).getAbsolutePath();
        return CachedFileManager.INSTANCE.getCachedFile(absolutePath);
    }
}

