/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.util.converter;

import com.l2fprod.common.util.converter.Converter;
import com.l2fprod.common.util.converter.ConverterRegistry;
import java.text.NumberFormat;

public class NumberConverters
implements Converter {
    private static NumberFormat defaultFormat;
    private NumberFormat format;

    public NumberConverters() {
        this(NumberConverters.getDefaultFormat());
    }

    public NumberConverters(NumberFormat format) {
        this.format = format;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NumberFormat getDefaultFormat() {
        Class<NumberConverters> clazz = NumberConverters.class;
        synchronized (NumberConverters.class) {
            if (defaultFormat == null) {
                defaultFormat = NumberFormat.getNumberInstance();
                defaultFormat.setMinimumIntegerDigits(1);
                defaultFormat.setMaximumIntegerDigits(64);
                defaultFormat.setMinimumFractionDigits(0);
                defaultFormat.setMaximumFractionDigits(64);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return defaultFormat;
        }
    }

    public void register(ConverterRegistry registry) {
        registry.addConverter(Number.class, Double.class, this);
        registry.addConverter(Number.class, Float.class, this);
        registry.addConverter(Number.class, Integer.class, this);
        registry.addConverter(Number.class, Long.class, this);
        registry.addConverter(Number.class, Short.class, this);
        registry.addConverter(Double.class, Double.class, this);
        registry.addConverter(Double.class, Float.class, this);
        registry.addConverter(Double.class, Integer.class, this);
        registry.addConverter(Double.class, Long.class, this);
        registry.addConverter(Double.class, Short.class, this);
        registry.addConverter(Double.class, String.class, this);
        registry.addConverter(Float.class, Double.class, this);
        registry.addConverter(Float.class, Float.class, this);
        registry.addConverter(Float.class, Integer.class, this);
        registry.addConverter(Float.class, Long.class, this);
        registry.addConverter(Float.class, Short.class, this);
        registry.addConverter(Float.class, String.class, this);
        registry.addConverter(Integer.class, Double.class, this);
        registry.addConverter(Integer.class, Float.class, this);
        registry.addConverter(Integer.class, Integer.class, this);
        registry.addConverter(Integer.class, Long.class, this);
        registry.addConverter(Integer.class, Short.class, this);
        registry.addConverter(Integer.class, String.class, this);
        registry.addConverter(Long.class, Double.class, this);
        registry.addConverter(Long.class, Float.class, this);
        registry.addConverter(Long.class, Integer.class, this);
        registry.addConverter(Long.class, Long.class, this);
        registry.addConverter(Long.class, Short.class, this);
        registry.addConverter(Long.class, String.class, this);
        registry.addConverter(Short.class, Double.class, this);
        registry.addConverter(Short.class, Float.class, this);
        registry.addConverter(Short.class, Integer.class, this);
        registry.addConverter(Short.class, Long.class, this);
        registry.addConverter(Short.class, Short.class, this);
        registry.addConverter(Short.class, String.class, this);
        registry.addConverter(String.class, Double.class, this);
        registry.addConverter(String.class, Float.class, this);
        registry.addConverter(String.class, Integer.class, this);
        registry.addConverter(String.class, Long.class, this);
        registry.addConverter(String.class, Short.class, this);
    }

    public Object convert(Class targetType, Object value) {
        if (value instanceof Number && Number.class.isAssignableFrom(targetType)) {
            if (Double.class.equals((Object)targetType)) {
                return new Double(((Number)value).doubleValue());
            }
            if (Float.class.equals((Object)targetType)) {
                return new Float(((Number)value).floatValue());
            }
            if (Integer.class.equals((Object)targetType)) {
                return new Integer(((Number)value).intValue());
            }
            if (Long.class.equals((Object)targetType)) {
                return new Long(((Number)value).longValue());
            }
            if (Short.class.equals((Object)targetType)) {
                return new Short(((Number)value).shortValue());
            }
            throw new IllegalArgumentException("this code must not be reached");
        }
        if (value instanceof Number && String.class.equals((Object)targetType)) {
            if (value instanceof Double || value instanceof Float) {
                return this.format.format(((Number)value).doubleValue());
            }
            return this.format.format(((Number)value).longValue());
        }
        if (value instanceof String && Number.class.isAssignableFrom(targetType)) {
            if (Double.class.equals((Object)targetType)) {
                return new Double((String)value);
            }
            if (Float.class.equals((Object)targetType)) {
                return new Float((String)value);
            }
            if (Integer.class.equals((Object)targetType)) {
                return new Integer((String)value);
            }
            if (Long.class.equals((Object)targetType)) {
                return new Long((String)value);
            }
            if (Short.class.equals((Object)targetType)) {
                return new Short((String)value);
            }
            throw new IllegalArgumentException("this code must not be reached");
        }
        throw new IllegalArgumentException("no conversion supported");
    }
}

