/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.swing;

import com.l2fprod.common.swing.plaf.ButtonBarButtonUI;
import com.l2fprod.common.swing.plaf.ButtonBarUI;
import com.l2fprod.common.swing.plaf.JButtonBarAddon;
import com.l2fprod.common.swing.plaf.LookAndFeelAddons;
import java.awt.Component;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.SwingConstants;

public class JButtonBar
extends JComponent
implements SwingConstants {
    public static final String UI_CLASS_ID = "ButtonBarUI";
    public static final String ORIENTATION_CHANGED_KEY = "orientation";
    private int orientation;
    private static PropertyChangeListener uiUpdater;
    private static ContainerListener buttonTracker;

    public JButtonBar() {
        this(0);
    }

    public JButtonBar(int orientation) {
        this.orientation = orientation;
        this.updateUI();
        this.addContainerListener(buttonTracker);
    }

    public void updateUI() {
        this.setUI((ButtonBarUI)LookAndFeelAddons.getUI(this, ButtonBarUI.class));
    }

    public ButtonBarUI getUI() {
        return (ButtonBarUI)this.ui;
    }

    public void setUI(ButtonBarUI ui) {
        super.setUI(ui);
        Component[] components = this.getComponents();
        int c = components.length;
        for (int i = 0; i < c; ++i) {
            if (!(components[i] instanceof AbstractButton)) continue;
            ui.installButtonBarUI((AbstractButton)components[i]);
        }
    }

    public String getUIClassID() {
        return UI_CLASS_ID;
    }

    public void setOrientation(int orientation) {
        if (orientation != 0 && orientation != 1) {
            throw new IllegalArgumentException("orientation must be one of: VERTICAL, HORIZONTAL");
        }
        if (this.orientation != orientation) {
            int oldOrientation = this.orientation;
            this.orientation = orientation;
            this.firePropertyChange(ORIENTATION_CHANGED_KEY, oldOrientation, this.orientation);
        }
    }

    public int getOrientation() {
        return this.orientation;
    }

    static {
        LookAndFeelAddons.contribute(new JButtonBarAddon());
        uiUpdater = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                AbstractButton button;
                if (evt.getSource() instanceof AbstractButton && (button = (AbstractButton)evt.getSource()).getParent() instanceof JButtonBar && !(button.getUI() instanceof ButtonBarButtonUI)) {
                    ((ButtonBarUI)((JButtonBar)button.getParent()).ui).installButtonBarUI(button);
                }
            }
        };
        buttonTracker = new ContainerAdapter(){

            public void componentAdded(ContainerEvent e) {
                JButtonBar container = (JButtonBar)e.getContainer();
                if (e.getChild() instanceof AbstractButton) {
                    ((ButtonBarUI)container.ui).installButtonBarUI((AbstractButton)e.getChild());
                    ((AbstractButton)e.getChild()).addPropertyChangeListener("UI", uiUpdater);
                }
            }

            public void componentRemoved(ContainerEvent e) {
                if (e.getChild() instanceof AbstractButton) {
                    ((AbstractButton)e.getChild()).removePropertyChangeListener("UI", uiUpdater);
                }
            }
        };
    }
}

