/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.propertysheet;

import com.l2fprod.common.beans.ExtendedPropertyDescriptor;
import com.l2fprod.common.propertysheet.Property;
import com.l2fprod.common.propertysheet.PropertyDescriptorAdapter;
import com.l2fprod.common.propertysheet.PropertyRendererFactory;
import com.l2fprod.common.swing.renderer.BooleanCellRenderer;
import com.l2fprod.common.swing.renderer.ColorCellRenderer;
import com.l2fprod.common.swing.renderer.DateRenderer;
import com.l2fprod.common.swing.renderer.DefaultCellRenderer;
import java.awt.Color;
import java.beans.PropertyDescriptor;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.table.TableCellRenderer;

public class PropertyRendererRegistry
implements PropertyRendererFactory {
    private Map typeToRenderer = new HashMap();
    private Map propertyToRenderer = new HashMap();

    public PropertyRendererRegistry() {
        this.registerDefaults();
    }

    public TableCellRenderer createTableCellRenderer(Property property) {
        return this.getRenderer(property);
    }

    public TableCellRenderer createTableCellRenderer(Class type) {
        return this.getRenderer(type);
    }

    public synchronized TableCellRenderer getRenderer(Property property) {
        Object value;
        PropertyDescriptor descriptor;
        TableCellRenderer renderer = null;
        if (property instanceof PropertyDescriptorAdapter && (descriptor = ((PropertyDescriptorAdapter)property).getDescriptor()) instanceof ExtendedPropertyDescriptor && ((ExtendedPropertyDescriptor)descriptor).getPropertyTableRendererClass() != null) {
            try {
                return (TableCellRenderer)((ExtendedPropertyDescriptor)descriptor).getPropertyTableRendererClass().newInstance();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if ((value = this.propertyToRenderer.get(property)) instanceof TableCellRenderer) {
            renderer = (TableCellRenderer)value;
        } else if (value instanceof Class) {
            try {
                renderer = (TableCellRenderer)((Class)value).newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            renderer = this.getRenderer(property.getType());
        }
        return renderer;
    }

    public synchronized TableCellRenderer getRenderer(Class type) {
        TableCellRenderer renderer = null;
        Object value = this.typeToRenderer.get(type);
        if (value instanceof TableCellRenderer) {
            renderer = (TableCellRenderer)value;
        } else if (value instanceof Class) {
            try {
                renderer = (TableCellRenderer)((Class)value).newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return renderer;
    }

    public synchronized void registerRenderer(Class type, Class rendererClass) {
        this.typeToRenderer.put(type, rendererClass);
    }

    public synchronized void registerRenderer(Class type, TableCellRenderer renderer) {
        this.typeToRenderer.put(type, renderer);
    }

    public synchronized void unregisterRenderer(Class type) {
        this.typeToRenderer.remove(type);
    }

    public synchronized void registerRenderer(Property property, Class rendererClass) {
        this.propertyToRenderer.put(property, rendererClass);
    }

    public synchronized void registerRenderer(Property property, TableCellRenderer renderer) {
        this.propertyToRenderer.put(property, renderer);
    }

    public synchronized void unregisterRenderer(Property property) {
        this.propertyToRenderer.remove(property);
    }

    public void registerDefaults() {
        this.typeToRenderer.clear();
        this.propertyToRenderer.clear();
        DefaultCellRenderer renderer = new DefaultCellRenderer();
        renderer.setShowOddAndEvenRows(false);
        ColorCellRenderer colorRenderer = new ColorCellRenderer();
        colorRenderer.setShowOddAndEvenRows(false);
        BooleanCellRenderer booleanRenderer = new BooleanCellRenderer();
        DateRenderer dateRenderer = new DateRenderer();
        dateRenderer.setShowOddAndEvenRows(false);
        this.registerRenderer(Object.class, (TableCellRenderer)renderer);
        this.registerRenderer(Color.class, (TableCellRenderer)colorRenderer);
        this.registerRenderer(Boolean.TYPE, (TableCellRenderer)booleanRenderer);
        this.registerRenderer(Boolean.class, (TableCellRenderer)booleanRenderer);
        this.registerRenderer(Byte.TYPE, (TableCellRenderer)renderer);
        this.registerRenderer(Byte.class, (TableCellRenderer)renderer);
        this.registerRenderer(Character.TYPE, (TableCellRenderer)renderer);
        this.registerRenderer(Character.class, (TableCellRenderer)renderer);
        this.registerRenderer(Double.TYPE, (TableCellRenderer)renderer);
        this.registerRenderer(Double.class, (TableCellRenderer)renderer);
        this.registerRenderer(Float.TYPE, (TableCellRenderer)renderer);
        this.registerRenderer(Float.class, (TableCellRenderer)renderer);
        this.registerRenderer(Integer.TYPE, (TableCellRenderer)renderer);
        this.registerRenderer(Integer.class, (TableCellRenderer)renderer);
        this.registerRenderer(Long.TYPE, (TableCellRenderer)renderer);
        this.registerRenderer(Long.class, (TableCellRenderer)renderer);
        this.registerRenderer(Short.TYPE, (TableCellRenderer)renderer);
        this.registerRenderer(Short.class, (TableCellRenderer)renderer);
        this.registerRenderer(Date.class, (TableCellRenderer)dateRenderer);
    }
}

