/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.propertysheet;

import com.l2fprod.common.beans.editor.BooleanAsCheckBoxPropertyEditor;
import com.l2fprod.common.beans.editor.ColorPropertyEditor;
import com.l2fprod.common.beans.editor.DimensionPropertyEditor;
import com.l2fprod.common.beans.editor.DoublePropertyEditor;
import com.l2fprod.common.beans.editor.FilePropertyEditor;
import com.l2fprod.common.beans.editor.FloatPropertyEditor;
import com.l2fprod.common.beans.editor.InsetsPropertyEditor;
import com.l2fprod.common.beans.editor.IntegerPropertyEditor;
import com.l2fprod.common.beans.editor.LongPropertyEditor;
import com.l2fprod.common.beans.editor.RectanglePropertyEditor;
import com.l2fprod.common.beans.editor.ShortPropertyEditor;
import com.l2fprod.common.beans.editor.StringPropertyEditor;
import com.l2fprod.common.propertysheet.Property;
import com.l2fprod.common.propertysheet.PropertyDescriptorAdapter;
import com.l2fprod.common.propertysheet.PropertyEditorFactory;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class PropertyEditorRegistry
implements PropertyEditorFactory {
    private Map typeToEditor = new HashMap();
    private Map propertyToEditor = new HashMap();

    public PropertyEditorRegistry() {
        this.registerDefaults();
    }

    public PropertyEditor createPropertyEditor(Property property) {
        return this.getEditor(property);
    }

    public synchronized PropertyEditor getEditor(Property property) {
        Class<?> clz;
        PropertyDescriptor descriptor;
        PropertyEditor editor = null;
        if (property instanceof PropertyDescriptorAdapter && (descriptor = ((PropertyDescriptorAdapter)property).getDescriptor()) != null && (clz = descriptor.getPropertyEditorClass()) != null) {
            editor = this.loadPropertyEditor(clz);
        }
        if (editor == null) {
            Object value = this.propertyToEditor.get(property);
            editor = value instanceof PropertyEditor ? (PropertyEditor)value : (value instanceof Class ? this.loadPropertyEditor((Class)value) : this.getEditor(property.getType()));
        }
        if (editor == null && property instanceof PropertyDescriptorAdapter) {
            descriptor = ((PropertyDescriptorAdapter)property).getDescriptor();
            clz = descriptor.getPropertyType();
            editor = PropertyEditorManager.findEditor(clz);
        }
        return editor;
    }

    private PropertyEditor loadPropertyEditor(Class clz) {
        PropertyEditor editor = null;
        try {
            editor = (PropertyEditor)clz.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return editor;
    }

    public synchronized PropertyEditor getEditor(Class type) {
        PropertyEditor editor = null;
        Object value = this.typeToEditor.get(type);
        if (value instanceof PropertyEditor) {
            editor = (PropertyEditor)value;
        } else if (value instanceof Class) {
            try {
                editor = (PropertyEditor)((Class)value).newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return editor;
    }

    public synchronized void registerEditor(Class type, Class editorClass) {
        this.typeToEditor.put(type, editorClass);
    }

    public synchronized void registerEditor(Class type, PropertyEditor editor) {
        this.typeToEditor.put(type, editor);
    }

    public synchronized void unregisterEditor(Class type) {
        this.typeToEditor.remove(type);
    }

    public synchronized void registerEditor(Property property, Class editorClass) {
        this.propertyToEditor.put(property, editorClass);
    }

    public synchronized void registerEditor(Property property, PropertyEditor editor) {
        this.propertyToEditor.put(property, editor);
    }

    public synchronized void unregisterEditor(Property property) {
        this.propertyToEditor.remove(property);
    }

    public void registerDefaults() {
        this.typeToEditor.clear();
        this.propertyToEditor.clear();
        this.registerEditor(String.class, StringPropertyEditor.class);
        this.registerEditor(Double.TYPE, DoublePropertyEditor.class);
        this.registerEditor(Double.class, DoublePropertyEditor.class);
        this.registerEditor(Float.TYPE, FloatPropertyEditor.class);
        this.registerEditor(Float.class, FloatPropertyEditor.class);
        this.registerEditor(Integer.TYPE, IntegerPropertyEditor.class);
        this.registerEditor(Integer.class, IntegerPropertyEditor.class);
        this.registerEditor(Long.TYPE, LongPropertyEditor.class);
        this.registerEditor(Long.class, LongPropertyEditor.class);
        this.registerEditor(Short.TYPE, ShortPropertyEditor.class);
        this.registerEditor(Short.class, ShortPropertyEditor.class);
        this.registerEditor(Boolean.TYPE, BooleanAsCheckBoxPropertyEditor.class);
        this.registerEditor(Boolean.class, BooleanAsCheckBoxPropertyEditor.class);
        this.registerEditor(File.class, FilePropertyEditor.class);
        this.registerEditor(Color.class, ColorPropertyEditor.class);
        this.registerEditor(Dimension.class, DimensionPropertyEditor.class);
        this.registerEditor(Insets.class, InsetsPropertyEditor.class);
        try {
            Class<?> fontEditor = Class.forName("com.l2fprod.common.beans.editor.FontPropertyEditor");
            this.registerEditor(Font.class, fontEditor);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.registerEditor(Rectangle.class, RectanglePropertyEditor.class);
        boolean foundDateEditor = false;
        try {
            Class.forName("com.toedter.calendar.JDateChooser");
            this.registerEditor(Date.class, Class.forName("com.l2fprod.common.beans.editor.JCalendarDatePropertyEditor"));
            foundDateEditor = true;
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        if (!foundDateEditor) {
            try {
                Class.forName("net.sf.nachocalendar.components.DateField");
                this.registerEditor(Date.class, Class.forName("com.l2fprod.common.beans.editor.NachoCalendarDatePropertyEditor"));
                foundDateEditor = true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }
}

