/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.beans.editor;

import com.l2fprod.common.beans.editor.AbstractPropertyEditor;
import com.l2fprod.common.swing.ComponentFactory;
import com.l2fprod.common.swing.JFontChooser;
import com.l2fprod.common.swing.PercentLayout;
import com.l2fprod.common.swing.renderer.DefaultCellRenderer;
import com.l2fprod.common.util.ResourceManager;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;

public class FontPropertyEditor
extends AbstractPropertyEditor {
    private DefaultCellRenderer label;
    private JButton button;
    private Font font;

    public FontPropertyEditor() {
        this.editor = new JPanel(new PercentLayout(0, 0));
        this.label = new DefaultCellRenderer();
        ((JPanel)this.editor).add("*", this.label);
        this.label.setOpaque(false);
        this.button = ComponentFactory.Helper.getFactory().createMiniButton();
        ((JPanel)this.editor).add(this.button);
        this.button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FontPropertyEditor.this.selectFont();
            }
        });
        this.button = ComponentFactory.Helper.getFactory().createMiniButton();
        ((JPanel)this.editor).add(this.button);
        this.button.setText("X");
        this.button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FontPropertyEditor.this.selectNull();
            }
        });
        ((JPanel)this.editor).setOpaque(false);
    }

    public Object getValue() {
        return this.font;
    }

    public void setValue(Object value) {
        this.font = (Font)value;
        this.label.setValue(value);
    }

    protected void selectFont() {
        ResourceManager rm = ResourceManager.all(FontPropertyEditor.class);
        String title = rm.getString("FontPropertyEditor.title");
        Font selectedFont = JFontChooser.showDialog(this.editor, title, this.font);
        if (selectedFont != null) {
            Font oldFont = this.font;
            Font newFont = selectedFont;
            this.label.setValue(newFont);
            this.font = newFont;
            this.firePropertyChange(oldFont, newFont);
        }
    }

    protected void selectNull() {
        Font oldFont = this.font;
        this.label.setValue(null);
        this.font = null;
        this.firePropertyChange(oldFont, null);
    }
}

