/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.dpierron.calibre.thumbnails;

import com.gmail.dpierron.calibre.opds.CatalogContext;
import com.gmail.dpierron.calibre.opds.i18n.Localization;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;

public class CreateThumbnail {
    public static final int VERTICAL = 0;
    public static final int HORIZONTAL = 1;
    public static final String IMAGE_JPEG = "jpeg";
    public static final String IMAGE_JPG = "jpg";
    public static final String IMAGE_PNG = "png";
    private ImageIcon image;
    private ImageIcon thumb;

    public CreateThumbnail(String fileName) {
        this.image = new ImageIcon(fileName);
        if (!this.isImageLoaded()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.isImageLoaded()) {
                CatalogContext.INSTANCE.getCallback().errorOccured(Localization.Main.getText("error.loadingThumbnail", fileName), null);
            }
        }
    }

    public boolean isImageLoaded() {
        return this.image != null && this.image.getImageLoadStatus() == 8;
    }

    public Image getThumbnail(int size, int dir) {
        this.thumb = dir == 1 ? new ImageIcon(this.image.getImage().getScaledInstance(size, -1, 4)) : new ImageIcon(this.image.getImage().getScaledInstance(-1, size, 4));
        return this.thumb.getImage();
    }

    public Image getThumbnail(int size, int dir, int scale) {
        this.thumb = dir == 1 ? new ImageIcon(this.image.getImage().getScaledInstance(size, -1, scale)) : new ImageIcon(this.image.getImage().getScaledInstance(-1, size, scale));
        return this.thumb.getImage();
    }

    public void saveThumbnail(File file, String imageType) {
        if (this.thumb != null) {
            BufferedImage bi = new BufferedImage(this.thumb.getIconWidth(), this.thumb.getIconHeight(), 1);
            Graphics g = bi.getGraphics();
            g.drawImage(this.thumb.getImage(), 0, 0, null);
            try {
                ImageIO.write((RenderedImage)bi, imageType, file);
            }
            catch (IOException ioe) {
                CatalogContext.INSTANCE.getCallback().errorOccured(Localization.Main.getText("error.savingThumbnail", file.getAbsolutePath()), ioe);
            }
        } else {
            CatalogContext.INSTANCE.getCallback().errorOccured(Localization.Main.getText("error.generatingThumbnail", file.getAbsolutePath()), null);
        }
    }
}

