/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.dpierron.calibre.opds.secure;

import com.gmail.dpierron.calibre.configuration.StanzaConfiguration;
import com.gmail.dpierron.tools.Helper;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum SecureFileManager {
    INSTANCE;

    private static final boolean autosave = false;
    private static final char DELIM1 = '_';
    private static final String PROPERTY_FILENAME = ".calibre2opds.secureFileManager.xml";
    private static final Logger logger;
    private static final String COMMENT = "calibre2opds 2.3 cr1";
    private Properties properties;
    private File propertiesFile;

    private boolean isSecurityOn() {
        return StanzaConfiguration.INSTANCE.getCryptFilenames();
    }

    public void reset() {
        this.reset(true);
    }

    private void reset(boolean deleteFile) {
        if (deleteFile) {
            this.getPropertiesFile().delete();
        }
        this.properties = new Properties();
        this.tryAndLoadProperties();
    }

    private SecureFileManager() {
        this.reset(false);
    }

    private File getPropertiesFile() {
        File configurationFolder = StanzaConfiguration.INSTANCE.getConfigurationDirectory();
        if (configurationFolder != null && configurationFolder.exists()) {
            this.propertiesFile = new File(configurationFolder, PROPERTY_FILENAME);
        }
        return this.propertiesFile;
    }

    private void tryAndLoadProperties() {
        if (this.getPropertiesFile().exists()) {
            this.load();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        BufferedInputStream bis = null;
        try {
            try {
                bis = new BufferedInputStream(new FileInputStream(this.getPropertiesFile()));
                this.properties.loadFromXML(bis);
            }
            finally {
                if (bis != null) {
                    bis.close();
                }
            }
        }
        catch (IOException e) {
            logger.error("error while loading properties from " + this.getPropertiesFile().getAbsolutePath(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        FilterOutputStream bos = null;
        try {
            try {
                bos = new BufferedOutputStream(new FileOutputStream(this.getPropertiesFile()));
                this.properties.storeToXML(bos, COMMENT);
            }
            finally {
                if (bos != null) {
                    bos.close();
                }
            }
        }
        catch (IOException e) {
            logger.error("error while storing properties in " + this.getPropertiesFile().getAbsolutePath(), e);
        }
    }

    private void setProperty(String name, String value) {
        this.properties.setProperty(name, value);
    }

    private String getProperty(String name) {
        return this.properties.getProperty(name);
    }

    public String generateNewRandomFile(String naked) {
        if (Helper.isNullOrEmpty((Object)naked)) {
            return naked;
        }
        String base = naked;
        String ext = null;
        int pos = base.lastIndexOf(46);
        if (pos > -1) {
            ext = base.substring(pos);
            base = base.substring(0, pos);
        }
        StringBuffer sb = new StringBuffer();
        sb.append(base);
        sb.append('_');
        sb.append(this.getNewRandomCypher());
        if (Helper.isNotNullOrEmpty((Object)ext)) {
            sb.append(ext);
        }
        return sb.toString();
    }

    public String encode(String naked) {
        if (!this.isSecurityOn()) {
            return naked;
        }
        String result = this.getProperty("naked." + naked);
        if (Helper.isNullOrEmpty((Object)result)) {
            result = this.generateNewRandomFile(naked);
            this.setProperty("naked." + naked, result);
            this.setProperty("coded." + result, naked);
        }
        return result;
    }

    public String decode(String coded) {
        if (!this.isSecurityOn()) {
            return coded;
        }
        String result = this.getProperty("coded." + coded);
        return result;
    }

    private String getNewRandomCypher() {
        int CYPHERLEN = 12;
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < CYPHERLEN; ++i) {
            double random = Math.random() * 36.0 + 1.0;
            int r = (int)random;
            r = r <= 10 ? (r += 47) : (r += 54);
            char c = (char)r;
            sb.append(c);
        }
        return sb.toString();
    }

    static {
        logger = Logger.getLogger(SecureFileManager.class);
    }
}

